/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import org.apache.camel.component.mllp.MllpException;

public class MllpFrameException
extends MllpException {
    private final byte[] mllpPayload;

    public MllpFrameException(String message, byte[] mllpPayload) {
        super(message);
        this.mllpPayload = mllpPayload;
    }

    public MllpFrameException(String message, byte[] mllpPayload, Throwable cause) {
        super(message, cause);
        this.mllpPayload = mllpPayload;
    }

    public byte[] getMllpPayload() {
        return this.mllpPayload;
    }

    @Override
    public String getMessage() {
        if (this.isLogPhi()) {
            return String.format("%s:\n\tMLLP Payload: %s", super.getMessage(), this.covertBytesToPrintFriendlyString(this.mllpPayload));
        }
        return super.getMessage();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
        stringBuilder.append(": {mllpPayload=").append(this.covertBytesToPrintFriendlyString(this.mllpPayload)).append("}");
        return stringBuilder.toString();
    }
}

