/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import org.apache.camel.component.mllp.MllpException;

public abstract class MllpAcknowledgementException
extends MllpException {
    private final byte[] hl7Message;
    private final byte[] hl7Acknowledgement;

    public MllpAcknowledgementException(String message, byte[] hl7Message, byte[] hl7Acknowledgement) {
        super(message);
        this.hl7Message = hl7Message;
        this.hl7Acknowledgement = hl7Acknowledgement;
    }

    public MllpAcknowledgementException(String message, byte[] hl7Message, byte[] hl7Acknowledgement, Throwable cause) {
        super(message, cause);
        this.hl7Message = hl7Message;
        this.hl7Acknowledgement = hl7Acknowledgement;
    }

    public byte[] getHl7Message() {
        return this.hl7Message;
    }

    public byte[] getHl7Acknowledgement() {
        return this.hl7Acknowledgement;
    }

    @Override
    public String getMessage() {
        if (this.isLogPhi()) {
            return String.format("%s:\n\tHL7 Message: %s\n\tHL7 Acknowledgement: %s", super.getMessage(), this.covertBytesToPrintFriendlyString(this.hl7Message), this.covertBytesToPrintFriendlyString(this.hl7Acknowledgement));
        }
        return super.getMessage();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
        stringBuilder.append(": {hl7Message=").append(this.covertBytesToPrintFriendlyString(this.hl7Message)).append(", hl7Acknowledgement=").append(this.covertBytesToPrintFriendlyString(this.hl7Acknowledgement)).append("}");
        return stringBuilder.toString();
    }
}

