/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.routepolicy;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.NonManagedService;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.component.micrometer.MicrometerUtils;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyConfiguration;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyNamingStrategy;
import org.apache.camel.component.micrometer.routepolicy.MicrometerRoutePolicyService;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;

public class MicrometerRoutePolicy
extends RoutePolicySupport
implements NonManagedService {
    private MeterRegistry meterRegistry;
    private boolean prettyPrint;
    private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
    private MicrometerRoutePolicyNamingStrategy namingStrategy = MicrometerRoutePolicyNamingStrategy.DEFAULT;
    private MicrometerRoutePolicyConfiguration configuration = MicrometerRoutePolicyConfiguration.DEFAULT;
    private final Map<Route, MetricsStatistics> statisticsMap = new HashMap<Route, MetricsStatistics>();

    public MeterRegistry getMeterRegistry() {
        return this.meterRegistry;
    }

    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public TimeUnit getDurationUnit() {
        return this.durationUnit;
    }

    public void setDurationUnit(TimeUnit durationUnit) {
        this.durationUnit = durationUnit;
    }

    public MicrometerRoutePolicyNamingStrategy getNamingStrategy() {
        return this.namingStrategy;
    }

    public void setNamingStrategy(MicrometerRoutePolicyNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    public MicrometerRoutePolicyConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MicrometerRoutePolicyConfiguration configuration) {
        this.configuration = configuration;
    }

    public void onInit(Route route) {
        super.onInit(route);
        if (this.getMeterRegistry() == null) {
            this.setMeterRegistry(MicrometerUtils.getOrCreateMeterRegistry(route.getCamelContext().getRegistry(), "metricsRegistry"));
        }
        try {
            MicrometerRoutePolicyService registryService = (MicrometerRoutePolicyService)route.getCamelContext().hasService(MicrometerRoutePolicyService.class);
            if (registryService == null) {
                registryService = new MicrometerRoutePolicyService();
                registryService.setMeterRegistry(this.getMeterRegistry());
                registryService.setPrettyPrint(this.isPrettyPrint());
                registryService.setDurationUnit(this.getDurationUnit());
                registryService.setMatchingTags((Iterable<Tag>)Tags.of((String)"serviceName", (String)MicrometerRoutePolicyService.class.getSimpleName()));
                route.getCamelContext().addService((Object)registryService);
                ServiceHelper.startService((Service)registryService);
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        this.statisticsMap.computeIfAbsent(route, it -> new MetricsStatistics(this.getMeterRegistry(), (Route)it, this.getNamingStrategy(), this.configuration));
    }

    public void onExchangeBegin(Route route, Exchange exchange) {
        Optional.ofNullable(this.statisticsMap.get(route)).ifPresent(statistics -> statistics.onExchangeBegin(exchange));
    }

    public void onExchangeDone(Route route, Exchange exchange) {
        Optional.ofNullable(this.statisticsMap.get(route)).ifPresent(statistics -> statistics.onExchangeDone(exchange));
    }

    private static final class MetricsStatistics {
        private final MeterRegistry meterRegistry;
        private final Route route;
        private final MicrometerRoutePolicyNamingStrategy namingStrategy;
        private final MicrometerRoutePolicyConfiguration configuration;
        private Counter exchangesSucceeded;
        private Counter exchangesFailed;
        private Counter exchangesTotal;
        private Counter externalRedeliveries;
        private Counter failuresHandled;
        private Timer timer;
        private LongTaskTimer longTaskTimer;

        private MetricsStatistics(MeterRegistry meterRegistry, Route route, MicrometerRoutePolicyNamingStrategy namingStrategy, MicrometerRoutePolicyConfiguration configuration) {
            this.configuration = (MicrometerRoutePolicyConfiguration)ObjectHelper.notNull((Object)configuration, (String)"MicrometerRoutePolicyConfiguration", (Object)this);
            this.meterRegistry = (MeterRegistry)ObjectHelper.notNull((Object)meterRegistry, (String)"MeterRegistry", (Object)this);
            this.namingStrategy = (MicrometerRoutePolicyNamingStrategy)ObjectHelper.notNull((Object)namingStrategy, (String)"MicrometerRoutePolicyNamingStrategy", (Object)this);
            this.route = route;
            if (configuration.isAdditionalCounters()) {
                this.initAdditionalCounters();
            }
        }

        private void initAdditionalCounters() {
            if (this.configuration.isExchangesSucceeded()) {
                this.exchangesSucceeded = this.createCounter(this.namingStrategy.getExchangesSucceededName(this.route), "Number of successfully completed exchanges");
            }
            if (this.configuration.isExchangesFailed()) {
                this.exchangesFailed = this.createCounter(this.namingStrategy.getExchangesFailedName(this.route), "Number of failed exchanges");
            }
            if (this.configuration.isExchangesTotal()) {
                this.exchangesTotal = this.createCounter(this.namingStrategy.getExchangesTotalName(this.route), "Total number of processed exchanges");
            }
            if (this.configuration.isExternalRedeliveries()) {
                this.externalRedeliveries = this.createCounter(this.namingStrategy.getExternalRedeliveriesName(this.route), "Number of external initiated redeliveries (such as from JMS broker)");
            }
            if (this.configuration.isFailuresHandled()) {
                this.failuresHandled = this.createCounter(this.namingStrategy.getFailuresHandledName(this.route), "Number of failures handled");
            }
            if (this.configuration.isLongTask()) {
                LongTaskTimer.Builder builder = LongTaskTimer.builder((String)this.namingStrategy.getLongTaskName(this.route)).tags((Iterable)this.namingStrategy.getTags(this.route)).description("Route long task metric");
                if (this.configuration.getLongTaskInitiator() != null) {
                    this.configuration.getLongTaskInitiator().accept(builder);
                }
                this.longTaskTimer = builder.register(this.meterRegistry);
            }
        }

        public void onExchangeBegin(Exchange exchange) {
            Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry);
            exchange.setProperty(this.propertyName(exchange), (Object)sample);
            if (this.longTaskTimer != null) {
                exchange.setProperty(this.propertyName(exchange) + "_long_task", (Object)this.longTaskTimer.start());
            }
        }

        public void onExchangeDone(Exchange exchange) {
            LongTaskTimer.Sample ltSampler;
            Timer.Sample sample = (Timer.Sample)exchange.removeProperty(this.propertyName(exchange));
            if (sample != null) {
                if (this.timer == null) {
                    Timer.Builder builder = Timer.builder((String)this.namingStrategy.getName(this.route)).tags((Iterable)this.namingStrategy.getTags(this.route)).description("Route performance metrics");
                    if (this.configuration.getTimerInitiator() != null) {
                        this.configuration.getTimerInitiator().accept(builder);
                    }
                    this.timer = builder.register(this.meterRegistry);
                }
                sample.stop(this.timer);
            }
            if ((ltSampler = (LongTaskTimer.Sample)exchange.removeProperty(this.propertyName(exchange) + "_long_task")) != null) {
                ltSampler.stop();
            }
            if (this.configuration.isAdditionalCounters()) {
                this.updateAdditionalCounters(exchange);
            }
        }

        private void updateAdditionalCounters(Exchange exchange) {
            if (this.exchangesTotal != null) {
                this.exchangesTotal.increment();
            }
            if (exchange.isFailed()) {
                if (this.exchangesFailed != null) {
                    this.exchangesFailed.increment();
                }
            } else {
                if (this.exchangesSucceeded != null) {
                    this.exchangesSucceeded.increment();
                }
                if (this.failuresHandled != null && ExchangeHelper.isFailureHandled((Exchange)exchange)) {
                    this.failuresHandled.increment();
                }
                if (this.externalRedeliveries != null && exchange.isExternalRedelivered()) {
                    this.externalRedeliveries.increment();
                }
            }
        }

        private String propertyName(Exchange exchange) {
            return String.format("%s-%s-%s", "camel.route.policy", this.route.getId(), exchange.getExchangeId());
        }

        private Counter createCounter(String meterName, String description) {
            return Counter.builder((String)meterName).tags((Iterable)this.namingStrategy.getExchangeStatusTags(this.route)).description(description).register(this.meterRegistry);
        }
    }
}

