/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.lucene;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.lucene.LuceneConfiguration;
import org.apache.camel.component.lucene.LuceneIndexer;
import org.apache.camel.support.DefaultProducer;

public class LuceneIndexProducer
extends DefaultProducer {
    LuceneConfiguration config;
    LuceneIndexer indexer;

    public LuceneIndexProducer(Endpoint endpoint, LuceneConfiguration config, LuceneIndexer indexer) {
        super(endpoint);
        this.config = config;
        this.indexer = indexer;
    }

    public void doStop() throws Exception {
        this.indexer.getNiofsDirectory().close();
        super.doStop();
    }

    public void process(Exchange exchange) throws Exception {
        this.indexer.index(exchange);
    }

    public LuceneConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(LuceneConfiguration config) {
        this.config = config;
    }

    public LuceneIndexer getIndexer() {
        return this.indexer;
    }

    public void setIndexer(LuceneIndexer indexer) {
        this.indexer = indexer;
    }
}

