/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.support.classic;

import java.util.Collection;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.consumer.CommitManager;
import org.apache.camel.component.kafka.consumer.support.classic.AssignmentAdapterHelper;
import org.apache.camel.component.kafka.consumer.support.classic.PartitionAssignmentAdapter;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassicRebalanceListener
implements ConsumerRebalanceListener {
    private static final Logger LOG = LoggerFactory.getLogger(ClassicRebalanceListener.class);
    private final String threadId;
    private final KafkaConfiguration configuration;
    private final PartitionAssignmentAdapter assignmentAdapter;
    private final CommitManager commitManager;

    public ClassicRebalanceListener(String threadId, KafkaConfiguration configuration, CommitManager commitManager, Consumer<?, ?> consumer) {
        this.threadId = threadId;
        this.configuration = configuration;
        this.commitManager = commitManager;
        this.assignmentAdapter = AssignmentAdapterHelper.resolveBuiltinResumeAdapters(configuration);
        this.assignmentAdapter.setConsumer(consumer);
    }

    public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
        for (TopicPartition partition : partitions) {
            LOG.debug("onPartitionsRevoked: {} from {}", (Object)this.threadId, (Object)partition.topic());
            if (this.configuration.getAutoCommitEnable()) continue;
            this.commitManager.commit(partition);
        }
    }

    public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
        if (LOG.isDebugEnabled()) {
            partitions.forEach(p -> LOG.debug("onPartitionsAssigned: {} from {}", (Object)this.threadId, (Object)p.topic()));
        }
        this.assignmentAdapter.handlePartitionAssignment();
    }
}

