/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import java.io.IOException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ibatis.IBatisComponent;
import org.apache.camel.component.ibatis.IBatisConsumer;
import org.apache.camel.component.ibatis.IBatisProducer;
import org.apache.camel.component.ibatis.StatementType;
import org.apache.camel.component.ibatis.strategy.DefaultIBatisProcessingStategy;
import org.apache.camel.component.ibatis.strategy.IBatisProcessingStrategy;
import org.apache.camel.component.ibatis.strategy.TransactionIsolationLevel;
import org.apache.camel.impl.DefaultPollingEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(scheme="ibatis", title="iBatis", syntax="ibatis:statement", consumerClass=IBatisConsumer.class, label="database,sql")
public class IBatisEndpoint
extends DefaultPollingEndpoint {
    @UriPath
    @Metadata(required="true")
    private String statement;
    @UriParam(defaultValue="true")
    private boolean useTransactions = true;
    @UriParam(label="producer")
    private StatementType statementType;
    @UriParam(label="consumer", defaultValue="0")
    private int maxMessagesPerPoll;
    @UriParam(label="consumer")
    private IBatisProcessingStrategy strategy;
    @UriParam(defaultValue="TRANSACTION_REPEATABLE_READ", enums="TRANSACTION_NONE,TRANSACTION_READ_UNCOMMITTED,TRANSACTION_READ_COMMITTED,TRANSACTION_REPEATABLE_READ,TRANSACTION_SERIALIZABLE")
    private String isolation;
    @UriParam(label="consumer", optionalPrefix="consumer.")
    private String onConsume;
    @UriParam(label="consumer", optionalPrefix="consumer.", defaultValue="true")
    private boolean useIterator = true;
    @UriParam(label="consumer", optionalPrefix="consumer.")
    private boolean routeEmptyResultSet;

    public IBatisEndpoint() {
    }

    public IBatisEndpoint(String uri, IBatisComponent component, String statement) throws Exception {
        super(uri, (Component)component);
        this.setUseTransactions(component.isUseTransactions());
        this.setStatement(statement);
    }

    public IBatisComponent getComponent() {
        return (IBatisComponent)super.getComponent();
    }

    public boolean isSingleton() {
        return true;
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)((Object)this.statementType), (String)"statementType", (Object)((Object)this));
        return new IBatisProducer(this);
    }

    public IBatisConsumer createConsumer(Processor processor) throws Exception {
        IBatisConsumer consumer = new IBatisConsumer(this, processor);
        consumer.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        consumer.setOnConsume(this.getOnConsume());
        consumer.setUseIterator(this.isUseIterator());
        consumer.setRouteEmptyResultSet(this.isRouteEmptyResultSet());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public SqlMapClient getSqlMapClient() throws IOException {
        return this.getComponent().getSqlMapClient();
    }

    public IBatisProcessingStrategy getProcessingStrategy() throws Exception {
        return this.strategy;
    }

    public void setStrategy(IBatisProcessingStrategy strategy) {
        this.strategy = strategy;
    }

    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String statement) {
        this.statement = statement;
    }

    public boolean isUseTransactions() {
        return this.useTransactions;
    }

    public void setUseTransactions(boolean useTransactions) {
        this.useTransactions = useTransactions;
    }

    public StatementType getStatementType() {
        return this.statementType;
    }

    public void setStatementType(StatementType statementType) {
        this.statementType = statementType;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public String getIsolation() throws Exception {
        return this.isolation;
    }

    public void setIsolation(String isolation) throws Exception {
        this.isolation = isolation;
    }

    public String getOnConsume() {
        return this.onConsume;
    }

    public void setOnConsume(String onConsume) {
        this.onConsume = onConsume;
    }

    public boolean isUseIterator() {
        return this.useIterator;
    }

    public void setUseIterator(boolean useIterator) {
        this.useIterator = useIterator;
    }

    public boolean isRouteEmptyResultSet() {
        return this.routeEmptyResultSet;
    }

    public void setRouteEmptyResultSet(boolean routeEmptyResultSet) {
        this.routeEmptyResultSet = routeEmptyResultSet;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.strategy == null) {
            this.strategy = new DefaultIBatisProcessingStategy();
        }
        if (this.isolation != null) {
            this.strategy.setIsolation(TransactionIsolationLevel.intValueOf(this.isolation));
        }
    }
}

