/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.http4.BasicAuthenticationHttpClientConfigurer;
import org.apache.camel.component.http4.CompositeHttpConfigurer;
import org.apache.camel.component.http4.HttpBinding;
import org.apache.camel.component.http4.HttpClientConfigurer;
import org.apache.camel.component.http4.HttpConsumer;
import org.apache.camel.component.http4.HttpEndpoint;
import org.apache.camel.component.http4.ProxyHttpClientConfigurer;
import org.apache.camel.component.http4.UrlRewrite;
import org.apache.camel.component.http4.helper.HttpHelper;
import org.apache.camel.impl.HeaderFilterStrategyComponent;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.http.auth.params.AuthParamBean;
import org.apache.http.client.CookieStore;
import org.apache.http.client.params.ClientParamBean;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnRouteParamBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.cookie.params.CookieSpecParamBean;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParamBean;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParamBean;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpComponent
extends HeaderFilterStrategyComponent {
    private static final Logger LOG = LoggerFactory.getLogger(HttpComponent.class);
    protected HttpClientConfigurer httpClientConfigurer;
    protected ClientConnectionManager clientConnectionManager;
    protected HttpBinding httpBinding;
    protected HttpContext httpContext;
    protected SSLContextParameters sslContextParameters;
    protected X509HostnameVerifier x509HostnameVerifier = new BrowserCompatHostnameVerifier();
    protected CookieStore cookieStore;
    protected int maxTotalConnections = 200;
    protected int connectionsPerRoute = 20;
    protected long connectionTimeToLive = -1L;
    private volatile SSLContextParameters usedSslContextParams;

    public void connect(HttpConsumer consumer) throws Exception {
    }

    public void disconnect(HttpConsumer consumer) throws Exception {
    }

    protected HttpClientConfigurer createHttpClientConfigurer(Map<String, Object> parameters, boolean secure) throws Exception {
        HttpClientConfigurer configurer = (HttpClientConfigurer)this.resolveAndRemoveReferenceParameter(parameters, "httpClientConfigurerRef", HttpClientConfigurer.class);
        if (configurer == null && (configurer = (HttpClientConfigurer)this.resolveAndRemoveReferenceParameter(parameters, "httpClientConfigurer", HttpClientConfigurer.class)) == null) {
            configurer = this.getHttpClientConfigurer();
        }
        configurer = this.configureBasicAuthentication(parameters, configurer);
        configurer = this.configureHttpProxy(parameters, configurer, secure);
        return configurer;
    }

    private HttpClientConfigurer configureBasicAuthentication(Map<String, Object> parameters, HttpClientConfigurer configurer) {
        String authUsername = (String)this.getAndRemoveParameter(parameters, "authUsername", String.class);
        String authPassword = (String)this.getAndRemoveParameter(parameters, "authPassword", String.class);
        if (authUsername != null && authPassword != null) {
            String authDomain = (String)this.getAndRemoveParameter(parameters, "authDomain", String.class);
            String authHost = (String)this.getAndRemoveParameter(parameters, "authHost", String.class);
            return CompositeHttpConfigurer.combineConfigurers(configurer, new BasicAuthenticationHttpClientConfigurer(authUsername, authPassword, authDomain, authHost));
        }
        return configurer;
    }

    private HttpClientConfigurer configureHttpProxy(Map<String, Object> parameters, HttpClientConfigurer configurer, boolean secure) throws Exception {
        String proxyAuthScheme = (String)this.getAndRemoveParameter(parameters, "proxyAuthScheme", String.class);
        if (proxyAuthScheme == null) {
            proxyAuthScheme = secure ? "https" : "http";
        }
        String proxyAuthHost = (String)this.getAndRemoveParameter(parameters, "proxyAuthHost", String.class);
        Integer proxyAuthPort = (Integer)this.getAndRemoveParameter(parameters, "proxyAuthPort", Integer.class);
        if (proxyAuthHost != null && proxyAuthPort != null) {
            String proxyAuthUsername = (String)this.getAndRemoveParameter(parameters, "proxyAuthUsername", String.class);
            String proxyAuthPassword = (String)this.getAndRemoveParameter(parameters, "proxyAuthPassword", String.class);
            String proxyAuthDomain = (String)this.getAndRemoveParameter(parameters, "proxyAuthDomain", String.class);
            String proxyAuthNtHost = (String)this.getAndRemoveParameter(parameters, "proxyAuthNtHost", String.class);
            boolean secureProxy = HttpHelper.isSecureConnection(proxyAuthScheme);
            this.registerPort(secureProxy, this.x509HostnameVerifier, proxyAuthPort, this.sslContextParameters);
            if (proxyAuthUsername != null && proxyAuthPassword != null) {
                return CompositeHttpConfigurer.combineConfigurers(configurer, new ProxyHttpClientConfigurer(proxyAuthHost, proxyAuthPort, proxyAuthScheme, proxyAuthUsername, proxyAuthPassword, proxyAuthDomain, proxyAuthNtHost));
            }
            return CompositeHttpConfigurer.combineConfigurers(configurer, new ProxyHttpClientConfigurer(proxyAuthHost, proxyAuthPort, proxyAuthScheme));
        }
        return configurer;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String part;
        SSLContextParameters sslContextParameters;
        X509HostnameVerifier x509HostnameVerifier;
        HttpContext httpContext;
        HashMap<String, Object> httpClientParameters = new HashMap<String, Object>(parameters);
        HttpParams clientParams = this.configureHttpParams(parameters);
        this.validateParameters(uri, parameters, "httpClient.");
        HttpBinding httpBinding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBindingRef", HttpBinding.class);
        if (httpBinding == null) {
            httpBinding = (HttpBinding)this.resolveAndRemoveReferenceParameter(parameters, "httpBinding", HttpBinding.class);
        }
        if ((httpContext = (HttpContext)this.resolveAndRemoveReferenceParameter(parameters, "httpContextRef", HttpContext.class)) == null) {
            httpContext = (HttpContext)this.resolveAndRemoveReferenceParameter(parameters, "httpContext", HttpContext.class);
        }
        if ((x509HostnameVerifier = (X509HostnameVerifier)this.resolveAndRemoveReferenceParameter(parameters, "x509HostnameVerifier", X509HostnameVerifier.class)) == null) {
            x509HostnameVerifier = this.getX509HostnameVerifier();
        }
        if ((sslContextParameters = (SSLContextParameters)this.resolveAndRemoveReferenceParameter(parameters, "sslContextParametersRef", SSLContextParameters.class)) == null) {
            sslContextParameters = (SSLContextParameters)this.resolveAndRemoveReferenceParameter(parameters, "sslContextParameters", SSLContextParameters.class);
        }
        if (sslContextParameters == null) {
            sslContextParameters = this.getSslContextParameters();
        }
        String httpMethodRestrict = (String)this.getAndRemoveParameter(parameters, "httpMethodRestrict", String.class);
        HeaderFilterStrategy headerFilterStrategy = (HeaderFilterStrategy)this.resolveAndRemoveReferenceParameter(parameters, "headerFilterStrategy", HeaderFilterStrategy.class);
        UrlRewrite urlRewrite = (UrlRewrite)this.resolveAndRemoveReferenceParameter(parameters, "urlRewrite", UrlRewrite.class);
        boolean secure = HttpHelper.isSecureConnection(uri) || sslContextParameters != null;
        String addressUri = (secure ? "https://" : "http://") + remaining;
        addressUri = UnsafeUriCharactersEncoder.encodeHttpURI((String)addressUri);
        URI uriHttpUriAddress = new URI(addressUri);
        int pos = uri.indexOf("//");
        if (pos != -1 && ((part = uri.substring(pos + 2)).startsWith("http:") || part.startsWith("https:"))) {
            throw new ResolveEndpointFailedException(uri, "The uri part is not configured correctly. You have duplicated the http(s) protocol.");
        }
        HttpClientConfigurer configurer = this.createHttpClientConfigurer(parameters, secure);
        URI endpointUri = URISupport.createRemainingURI((URI)uriHttpUriAddress, httpClientParameters);
        String scheme = ObjectHelper.before((String)uri, (String)"://");
        endpointUri = URISupport.createRemainingURI((URI)new URI(scheme, endpointUri.getUserInfo(), endpointUri.getHost(), endpointUri.getPort(), endpointUri.getPath(), endpointUri.getQuery(), endpointUri.getFragment()), httpClientParameters);
        String endpointUriString = endpointUri.toString();
        LOG.debug("Creating endpoint uri {}", (Object)endpointUriString);
        HttpEndpoint endpoint = new HttpEndpoint(endpointUriString, this, clientParams, this.clientConnectionManager, configurer);
        if (urlRewrite != null) {
            this.getCamelContext().addService((Object)urlRewrite);
            endpoint.setUrlRewrite(urlRewrite);
        }
        this.setProperties((Object)endpoint, parameters);
        URI httpUri = URISupport.createRemainingURI((URI)new URI(uriHttpUriAddress.getScheme(), uriHttpUriAddress.getUserInfo(), uriHttpUriAddress.getHost(), uriHttpUriAddress.getPort(), uriHttpUriAddress.getPath(), uriHttpUriAddress.getQuery(), uriHttpUriAddress.getFragment()), parameters);
        endpoint.setHttpUri(httpUri);
        if (headerFilterStrategy != null) {
            endpoint.setHeaderFilterStrategy(headerFilterStrategy);
        } else {
            this.setEndpointHeaderFilterStrategy((Endpoint)endpoint);
        }
        endpoint.setBinding(this.getHttpBinding());
        if (httpBinding != null) {
            endpoint.setHttpBinding(httpBinding);
        }
        if (httpMethodRestrict != null) {
            endpoint.setHttpMethodRestrict(httpMethodRestrict);
        }
        endpoint.setHttpContext(this.getHttpContext());
        if (httpContext != null) {
            endpoint.setHttpContext(httpContext);
        }
        if (endpoint.getCookieStore() == null) {
            endpoint.setCookieStore(this.getCookieStore());
        }
        int port = HttpComponent.getPort(uriHttpUriAddress);
        this.registerPort(secure, x509HostnameVerifier, port, sslContextParameters);
        return endpoint;
    }

    private static int getPort(URI uri) {
        int port = uri.getPort();
        if (port < 0) {
            if ("http4".equals(uri.getScheme()) || "http".equals(uri.getScheme())) {
                port = 80;
            } else if ("https4".equals(uri.getScheme()) || "https".equals(uri.getScheme())) {
                port = 443;
            } else {
                throw new IllegalArgumentException("Unknown scheme, cannot determine port number for uri: " + uri);
            }
        }
        return port;
    }

    protected void registerPort(boolean secure, X509HostnameVerifier x509HostnameVerifier, int port, SSLContextParameters sslContextParams) throws Exception {
        if (this.usedSslContextParams == null) {
            this.usedSslContextParams = sslContextParams;
        }
        if (this.usedSslContextParams != sslContextParams) {
            String previous = ObjectHelper.getIdentityHashCode((Object)this.usedSslContextParams);
            String next = ObjectHelper.getIdentityHashCode((Object)sslContextParams);
            throw new IllegalArgumentException("Only same instance of SSLContextParameters is supported. Cannot use a different instance. Previous instance hashcode: " + previous + ", New instance hashcode: " + next);
        }
        SchemeRegistry registry = this.clientConnectionManager.getSchemeRegistry();
        if (secure) {
            SSLSocketFactory socketFactory = sslContextParams == null ? SSLSocketFactory.getSocketFactory() : new SSLSocketFactory(sslContextParams.createSSLContext());
            socketFactory.setHostnameVerifier(x509HostnameVerifier);
            registry.register(new Scheme("https", port, (SchemeSocketFactory)socketFactory));
            LOG.info("Registering SSL scheme https on port " + port);
            registry.register(new Scheme("https4", port, (SchemeSocketFactory)socketFactory));
            LOG.info("Registering SSL scheme https4 on port " + port);
        } else {
            registry.register(new Scheme("http", port, (SchemeSocketFactory)new PlainSocketFactory()));
            LOG.info("Registering PLAIN scheme http on port " + port);
            registry.register(new Scheme("http4", port, (SchemeSocketFactory)new PlainSocketFactory()));
            LOG.info("Registering PLAIN scheme http4 on port " + port);
        }
    }

    protected ClientConnectionManager createConnectionManager() {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        PoolingClientConnectionManager answer = new PoolingClientConnectionManager(schemeRegistry, this.getConnectionTimeToLive(), TimeUnit.MILLISECONDS);
        if (this.getMaxTotalConnections() > 0) {
            answer.setMaxTotal(this.getMaxTotalConnections());
        }
        if (this.getConnectionsPerRoute() > 0) {
            answer.setDefaultMaxPerRoute(this.getConnectionsPerRoute());
        }
        LOG.info("Created ClientConnectionManager " + answer);
        return answer;
    }

    protected HttpParams configureHttpParams(Map<String, Object> parameters) throws Exception {
        BasicHttpParams clientParams = new BasicHttpParams();
        AuthParamBean authParamBean = new AuthParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)authParamBean, parameters, (String)"httpClient.");
        ClientParamBean clientParamBean = new ClientParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)clientParamBean, parameters, (String)"httpClient.");
        ConnRouteParamBean connRouteParamBean = new ConnRouteParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)connRouteParamBean, parameters, (String)"httpClient.");
        CookieSpecParamBean cookieSpecParamBean = new CookieSpecParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)cookieSpecParamBean, parameters, (String)"httpClient.");
        HttpConnectionParamBean httpConnectionParamBean = new HttpConnectionParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)httpConnectionParamBean, parameters, (String)"httpClient.");
        HttpProtocolParamBean httpProtocolParamBean = new HttpProtocolParamBean((HttpParams)clientParams);
        IntrospectionSupport.setProperties((Object)httpProtocolParamBean, parameters, (String)"httpClient.");
        return clientParams;
    }

    protected boolean useIntrospectionOnEndpoint() {
        return false;
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        return this.httpClientConfigurer;
    }

    public void setHttpClientConfigurer(HttpClientConfigurer httpClientConfigurer) {
        this.httpClientConfigurer = httpClientConfigurer;
    }

    public ClientConnectionManager getClientConnectionManager() {
        return this.clientConnectionManager;
    }

    public void setClientConnectionManager(ClientConnectionManager clientConnectionManager) {
        this.clientConnectionManager = clientConnectionManager;
    }

    public HttpBinding getHttpBinding() {
        return this.httpBinding;
    }

    public void setHttpBinding(HttpBinding httpBinding) {
        this.httpBinding = httpBinding;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public X509HostnameVerifier getX509HostnameVerifier() {
        return this.x509HostnameVerifier;
    }

    public void setX509HostnameVerifier(X509HostnameVerifier x509HostnameVerifier) {
        this.x509HostnameVerifier = x509HostnameVerifier;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public int getConnectionsPerRoute() {
        return this.connectionsPerRoute;
    }

    public void setConnectionsPerRoute(int connectionsPerRoute) {
        this.connectionsPerRoute = connectionsPerRoute;
    }

    public long getConnectionTimeToLive() {
        return this.connectionTimeToLive;
    }

    public void setConnectionTimeToLive(long connectionTimeToLive) {
        this.connectionTimeToLive = connectionTimeToLive;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public void doStart() throws Exception {
        super.doStart();
        if (this.clientConnectionManager == null) {
            this.clientConnectionManager = this.createConnectionManager();
        }
    }

    public void doStop() throws Exception {
        if (this.clientConnectionManager != null) {
            LOG.info("Shutting down ClientConnectionManager: " + this.clientConnectionManager);
            this.clientConnectionManager.shutdown();
            this.clientConnectionManager = null;
        }
        this.usedSslContextParams = null;
        super.doStop();
    }
}

