/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.guice.inject;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.BindingImpl;
import com.google.inject.internal.Scoping;
import com.google.inject.matcher.Matcher;
import com.google.inject.name.Names;
import com.google.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.camel.guice.jndi.GuiceInitialContextFactory;
import org.apache.camel.guice.jndi.internal.Classes;
import org.apache.camel.guice.support.CloseErrors;
import org.apache.camel.guice.support.CloseFailedException;
import org.apache.camel.guice.support.Closer;
import org.apache.camel.guice.support.Closers;
import org.apache.camel.guice.support.CompositeCloser;
import org.apache.camel.guice.support.HasScopeAnnotation;
import org.apache.camel.guice.support.internal.CloseErrorsImpl;

public final class Injectors {
    public static final String MODULE_CLASS_NAMES = "org.guiceyfruit.modules";

    private Injectors() {
    }

    public static Injector createInjector(final Map environment, Module ... overridingModules) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ArrayList modules = Lists.newArrayList();
        modules.add(new AbstractModule(){

            protected void configure() {
                Names.bindProperties((Binder)this.binder(), (Map)environment);
            }
        });
        Object moduleValue = environment.get(MODULE_CLASS_NAMES);
        if (moduleValue instanceof String) {
            String names = (String)moduleValue;
            StringTokenizer iter = new StringTokenizer(names);
            while (iter.hasMoreTokens()) {
                String moduleName = iter.nextToken();
                Module module = Injectors.loadModule(moduleName);
                if (module == null) continue;
                modules.add(module);
            }
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{Modules.override((Iterable)modules).with(overridingModules)});
        return injector;
    }

    public static <T> T getInstance(Injector injector, Class<T> type, String name) {
        return (T)injector.getInstance(Key.get(type, (Annotation)Names.named((String)name)));
    }

    public static <T> Set<T> getInstancesOf(Injector injector, Class<T> baseClass) {
        HashSet answer = Sets.newHashSet();
        Set entries = injector.getBindings().entrySet();
        for (Map.Entry entry : entries) {
            Binding binding;
            Object value;
            Key key = (Key)entry.getKey();
            Class<?> keyType = Injectors.getKeyType(key);
            if (keyType == null || !baseClass.isAssignableFrom(keyType) || (value = (binding = (Binding)entry.getValue()).getProvider().get()) == null) continue;
            T castValue = baseClass.cast(value);
            answer.add(castValue);
        }
        return answer;
    }

    public static <T> Set<T> getInstancesOf(Injector injector, Matcher<Class> matcher) {
        HashSet answer = Sets.newHashSet();
        Set entries = injector.getBindings().entrySet();
        for (Map.Entry entry : entries) {
            Key key = (Key)entry.getKey();
            Class<?> keyType = Injectors.getKeyType(key);
            if (keyType == null || !matcher.matches(keyType)) continue;
            Binding binding = (Binding)entry.getValue();
            Object value = binding.getProvider().get();
            answer.add(value);
        }
        return answer;
    }

    public static <T> Set<Provider<T>> getProvidersOf(Injector injector, Matcher<Class> matcher) {
        HashSet answer = Sets.newHashSet();
        Set entries = injector.getBindings().entrySet();
        for (Map.Entry entry : entries) {
            Key key = (Key)entry.getKey();
            Class<?> keyType = Injectors.getKeyType(key);
            if (keyType == null || !matcher.matches(keyType)) continue;
            Binding binding = (Binding)entry.getValue();
            answer.add(binding.getProvider());
        }
        return answer;
    }

    public static <T> Set<Provider<T>> getProvidersOf(Injector injector, Class<T> baseClass) {
        HashSet answer = Sets.newHashSet();
        Set entries = injector.getBindings().entrySet();
        for (Map.Entry entry : entries) {
            Key key = (Key)entry.getKey();
            Class<?> keyType = Injectors.getKeyType(key);
            if (keyType == null || !baseClass.isAssignableFrom(keyType)) continue;
            Binding binding = (Binding)entry.getValue();
            answer.add(binding.getProvider());
        }
        return answer;
    }

    public static boolean hasBinding(Injector injector, Matcher<Class> matcher) {
        return !Injectors.getBindingsOf(injector, matcher).isEmpty();
    }

    public static boolean hasBinding(Injector injector, Class<?> baseClass) {
        return !Injectors.getBindingsOf(injector, baseClass).isEmpty();
    }

    public static boolean hasBinding(Injector injector, Key<?> key) {
        Binding<?> binding = Injectors.getBinding(injector, key);
        return binding != null;
    }

    public static Binding<?> getBinding(Injector injector, Key<?> key) {
        Map bindings = injector.getBindings();
        Binding binding = (Binding)bindings.get(key);
        return binding;
    }

    public static Set<Binding<?>> getBindingsOf(Injector injector, Matcher<Class> matcher) {
        HashSet answer = Sets.newHashSet();
        Set entries = injector.getBindings().entrySet();
        for (Map.Entry entry : entries) {
            Key key = (Key)entry.getKey();
            Class<?> keyType = Injectors.getKeyType(key);
            if (keyType == null || !matcher.matches(keyType)) continue;
            answer.add(entry.getValue());
        }
        return answer;
    }

    public static Set<Binding<?>> getBindingsOf(Injector injector, Class<?> baseClass) {
        HashSet answer = Sets.newHashSet();
        Set entries = injector.getBindings().entrySet();
        for (Map.Entry entry : entries) {
            Key key = (Key)entry.getKey();
            Class<?> keyType = Injectors.getKeyType(key);
            if (keyType == null || !baseClass.isAssignableFrom(keyType)) continue;
            answer.add(entry.getValue());
        }
        return answer;
    }

    public static <T> Class<?> getKeyType(Key<?> key) {
        Class keyType = null;
        TypeLiteral typeLiteral = key.getTypeLiteral();
        Type type = typeLiteral.getType();
        if (type instanceof Class) {
            keyType = (Class)type;
        }
        return keyType;
    }

    protected static Module loadModule(String moduleName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> type = Classes.loadClass(moduleName, GuiceInitialContextFactory.class.getClassLoader());
        return (Module)type.newInstance();
    }

    public static void close(Injector injector) throws CloseFailedException {
        Injectors.close(injector, new CloseErrorsImpl(Injectors.class));
    }

    public static void close(Injector injector, CloseErrors errors) throws CloseFailedException {
        Injectors.close(injector, Singleton.class, errors);
    }

    public static void close(Injector injector, Class<? extends Annotation> scopeAnnotationToClose) throws CloseFailedException {
        Injectors.close(injector, scopeAnnotationToClose, new CloseErrorsImpl(Injectors.class));
    }

    public static void close(Injector injector, Class<? extends Annotation> scopeAnnotationToClose, CloseErrors errors) throws CloseFailedException {
        Set<Closer> closers = Injectors.getInstancesOf(injector, Closer.class);
        Closer closer = CompositeCloser.newInstance(closers);
        if (closer == null) {
            return;
        }
        Set entries = injector.getBindings().entrySet();
        for (Map.Entry entry : entries) {
            Key key = (Key)entry.getKey();
            Binding binding = (Binding)entry.getValue();
            Injectors.closeBinding(key, binding, scopeAnnotationToClose, closer, errors);
        }
        Injectors.tryCloseJitBindings(closer, injector, scopeAnnotationToClose, errors);
        errors.throwIfNecessary();
    }

    private static void tryCloseJitBindings(Closer closer, Injector injector, Class<? extends Annotation> scopeAnnotationToClose, CloseErrors errors) {
        Class<?> type = injector.getClass();
        try {
            Field field = type.getDeclaredField("jitBindings");
            field.setAccessible(true);
            Object bindings = field.get(injector);
            if (bindings != null && bindings instanceof Map) {
                Map map = (Map)bindings;
                Set entries = map.entrySet();
                for (Map.Entry entry : entries) {
                    Injectors.closeBinding((Key)entry.getKey(), (Binding)entry.getValue(), scopeAnnotationToClose, closer, errors);
                }
            }
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
    }

    private static void closeBinding(Key<?> key, Binding<?> binding, Class<? extends Annotation> scopeAnnotationToClose, Closer closer, CloseErrors errors) {
        Object value;
        Provider provider = binding.getProvider();
        Class<? extends Annotation> scopeAnnotation = Injectors.getScopeAnnotation(binding);
        if (scopeAnnotation != null && scopeAnnotation.equals(scopeAnnotationToClose) && (value = provider.get()) != null) {
            Closers.close(key, value, closer, errors);
        }
    }

    public static Class<? extends Annotation> getScopeAnnotation(Binding<?> binding) {
        BindingImpl bindingImpl;
        Scoping scoping;
        Class<? extends Annotation> scopeAnnotation = null;
        if (binding instanceof BindingImpl && (scoping = (bindingImpl = (BindingImpl)binding).getScoping()) != null && (scopeAnnotation = scoping.getScopeAnnotation()) == null) {
            Scope scope = scoping.getScopeInstance();
            if (scope instanceof HasScopeAnnotation) {
                HasScopeAnnotation hasScopeAnnotation = (HasScopeAnnotation)scope;
                scopeAnnotation = hasScopeAnnotation.getScopeAnnotation();
            }
            if (scopeAnnotation == null && (scoping == Scoping.EAGER_SINGLETON || scoping == Scoping.SINGLETON_ANNOTATION || scoping == Scoping.SINGLETON_INSTANCE)) {
                scopeAnnotation = Singleton.class;
            }
        }
        return scopeAnnotation;
    }
}

