/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fop;

import java.io.IOException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.fop.FopComponent;
import org.apache.camel.component.fop.FopProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FopFactory;
import org.xml.sax.SAXException;

public class FopEndpoint
extends DefaultEndpoint {
    private String userConfigURL;
    private FopFactory fopFactory;
    private String remaining;

    public FopEndpoint(String uri, FopComponent component, String remaining) {
        super(uri, (Component)component);
        this.remaining = remaining;
        this.fopFactory = FopFactory.newInstance();
    }

    public Producer createProducer() throws Exception {
        return new FopProducer(this, this.fopFactory, this.remaining);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported for FOP endpoint");
    }

    public boolean isSingleton() {
        return true;
    }

    FopFactory getFopFactory() {
        return this.fopFactory;
    }

    public void setUserConfigURL(String userConfigURL) {
        this.userConfigURL = userConfigURL;
        this.updateConfigurations();
    }

    private void updateConfigurations() {
        Configuration cfg;
        DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
        try {
            cfg = cfgBuilder.buildFromFile(this.userConfigURL);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        try {
            this.fopFactory.setUserConfig(cfg);
        }
        catch (FOPException e) {
            throw new RuntimeException(e);
        }
    }
}

