/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.exec.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import org.apache.camel.component.exec.ExecCommand;
import org.apache.camel.component.exec.ExecCommandExecutor;
import org.apache.camel.component.exec.ExecDefaultExecutor;
import org.apache.camel.component.exec.ExecException;
import org.apache.camel.component.exec.ExecResult;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecCommandExecutor
implements ExecCommandExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExecCommandExecutor.class);

    @Override
    public ExecResult execute(ExecCommand command) {
        ObjectHelper.notNull((Object)command, (String)"command");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        DefaultExecutor executor = this.prepareDefaultExecutor(command);
        PumpStreamHandler handler = new PumpStreamHandler((OutputStream)out, (OutputStream)err, command.getInput());
        executor.setStreamHandler((ExecuteStreamHandler)handler);
        CommandLine cl = this.toCommandLine(command);
        try {
            ExecResult result;
            int exitValue = executor.execute(cl);
            ByteArrayInputStream stdout = out.size() == 0 ? null : new ByteArrayInputStream(out.toByteArray());
            ByteArrayInputStream stderr = err.size() == 0 ? null : new ByteArrayInputStream(err.toByteArray());
            ExecResult execResult = result = new ExecResult(command, stdout, stderr, exitValue);
            return execResult;
        }
        catch (ExecuteException ee) {
            LOG.error("ExecException while executing command: " + command.toString() + " - " + ee.getMessage());
            throw new ExecException("Failed to execute command " + command, ee);
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            if (msg != null && "stream closed".equals(msg.toLowerCase(Locale.ENGLISH))) {
                ExecResult result;
                LOG.debug("Ignoring Stream closed IOException", (Throwable)ioe);
                ByteArrayInputStream stdout = out.size() == 0 ? null : new ByteArrayInputStream(out.toByteArray());
                ByteArrayInputStream stderr = err.size() == 0 ? null : new ByteArrayInputStream(err.toByteArray());
                int exitValue = 0;
                if (executor instanceof ExecDefaultExecutor) {
                    exitValue = ((ExecDefaultExecutor)executor).getExitValue();
                }
                ExecResult execResult = result = new ExecResult(command, stdout, stderr, exitValue);
                return execResult;
            }
            LOG.error("IOException while executing command: " + command.toString() + " - " + ioe.getMessage());
            throw new ExecException("Unable to execute command " + command, ioe);
        }
        finally {
            IOUtils.closeQuietly((InputStream)command.getInput());
        }
    }

    protected DefaultExecutor prepareDefaultExecutor(ExecCommand execCommand) {
        ExecDefaultExecutor executor = new ExecDefaultExecutor();
        executor.setExitValues(null);
        if (execCommand.getWorkingDir() != null) {
            executor.setWorkingDirectory(new File(execCommand.getWorkingDir()).getAbsoluteFile());
        }
        if (execCommand.getTimeout() != Long.MAX_VALUE) {
            executor.setWatchdog(new ExecuteWatchdog(execCommand.getTimeout()));
        }
        executor.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
        return executor;
    }

    protected CommandLine toCommandLine(ExecCommand execCommand) {
        ObjectHelper.notNull((Object)execCommand, (String)"execCommand");
        CommandLine cl = new CommandLine(execCommand.getExecutable());
        List<String> args = execCommand.getArgs();
        for (String arg : args) {
            cl.addArgument(arg, false);
        }
        return cl;
    }
}

