/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public final class PackageHelper {
    private PackageHelper() {
    }

    public static String fileToString(File file) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(file.toURI()));
        return new String(encoded, Charset.defaultCharset());
    }

    public static Map<String, File> findJsonFiles(File rootDir) {
        HashMap<String, File> results = new HashMap<String, File>();
        PackageHelper.findJsonFiles0(rootDir, results, new CamelComponentsModelFilter());
        return results;
    }

    private static void findJsonFiles0(File dir, Map<String, File> result, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null) {
            for (File file : files) {
                boolean jsonFile;
                boolean bl = jsonFile = file.isFile() && file.getName().endsWith(".json");
                if (jsonFile) {
                    result.put(file.getName().replaceAll("\\.json", ""), file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                PackageHelper.findJsonFiles0(file, result, filter);
            }
        }
    }

    private static class CamelComponentsModelFilter
    implements FileFilter {
        private CamelComponentsModelFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() || pathname.getName().endsWith(".json");
        }
    }
}

