/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.util;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.support.UnitOfWorkHelper;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;

public final class CxfUtils {
    private CxfUtils() {
    }

    public static String getStringFromInputStream(InputStream in) throws Exception {
        CachedOutputStream bos = new CachedOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)bos);
        in.close();
        bos.close();
        return bos.getOut().toString();
    }

    public static void closeCamelUnitOfWork(Message message) {
        Exchange exchange;
        org.apache.cxf.message.Exchange cxfExchange = message.getExchange();
        if (cxfExchange != null && (exchange = (Exchange)cxfExchange.get(Exchange.class)) != null) {
            UnitOfWorkHelper.doneUow((UnitOfWork)exchange.getUnitOfWork(), (Exchange)exchange);
        }
    }
}

