/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.facebook.FacebookComponent;
import org.apache.camel.component.facebook.config.FacebookConfiguration;

public interface FacebookComponentBuilderFactory {
    public static FacebookComponentBuilder facebook() {
        return new FacebookComponentBuilderImpl();
    }

    public static class FacebookComponentBuilderImpl
    extends AbstractComponentBuilder<FacebookComponent>
    implements FacebookComponentBuilder {
        @Override
        protected FacebookComponent buildConcreteComponent() {
            return new FacebookComponent();
        }

        private FacebookConfiguration getOrCreateConfiguration(FacebookComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new FacebookConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "clientURL": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setClientURL((String)value);
                    return true;
                }
                case "clientVersion": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setClientVersion((String)value);
                    return true;
                }
                case "debugEnabled": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setDebugEnabled((Boolean)value);
                    return true;
                }
                case "gzipEnabled": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setGzipEnabled((Boolean)value);
                    return true;
                }
                case "httpConnectionTimeout": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setHttpConnectionTimeout((Integer)value);
                    return true;
                }
                case "httpDefaultMaxPerRoute": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setHttpDefaultMaxPerRoute((Integer)value);
                    return true;
                }
                case "httpMaxTotalConnections": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setHttpMaxTotalConnections((Integer)value);
                    return true;
                }
                case "httpReadTimeout": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setHttpReadTimeout((Integer)value);
                    return true;
                }
                case "httpRetryCount": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setHttpRetryCount((Integer)value);
                    return true;
                }
                case "httpRetryIntervalSeconds": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setHttpRetryIntervalSeconds((Integer)value);
                    return true;
                }
                case "httpStreamingReadTimeout": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setHttpStreamingReadTimeout((Integer)value);
                    return true;
                }
                case "jsonStoreEnabled": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setJsonStoreEnabled((Boolean)value);
                    return true;
                }
                case "mbeanEnabled": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setMbeanEnabled((Boolean)value);
                    return true;
                }
                case "prettyDebugEnabled": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setPrettyDebugEnabled((Boolean)value);
                    return true;
                }
                case "restBaseURL": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setRestBaseURL((String)value);
                    return true;
                }
                case "useSSL": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setUseSSL((Boolean)value);
                    return true;
                }
                case "videoBaseURL": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setVideoBaseURL((String)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((FacebookComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((FacebookComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((FacebookComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((FacebookComponent)component).setConfiguration((FacebookConfiguration)value);
                    return true;
                }
                case "httpProxyHost": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setHttpProxyHost((String)value);
                    return true;
                }
                case "httpProxyPassword": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setHttpProxyPassword((String)value);
                    return true;
                }
                case "httpProxyPort": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setHttpProxyPort((Integer)value);
                    return true;
                }
                case "httpProxyUser": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setHttpProxyUser((String)value);
                    return true;
                }
                case "oAuthAccessToken": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setOAuthAccessToken((String)value);
                    return true;
                }
                case "oAuthAccessTokenURL": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setOAuthAccessTokenURL((String)value);
                    return true;
                }
                case "oAuthAppId": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setOAuthAppId((String)value);
                    return true;
                }
                case "oAuthAppSecret": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setOAuthAppSecret((String)value);
                    return true;
                }
                case "oAuthAuthorizationURL": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setOAuthAuthorizationURL((String)value);
                    return true;
                }
                case "oAuthPermissions": {
                    this.getOrCreateConfiguration((FacebookComponent)component).setOAuthPermissions((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface FacebookComponentBuilder
    extends ComponentBuilder<FacebookComponent> {
        default public FacebookComponentBuilder clientURL(String clientURL) {
            this.doSetProperty("clientURL", clientURL);
            return this;
        }

        default public FacebookComponentBuilder clientVersion(String clientVersion) {
            this.doSetProperty("clientVersion", clientVersion);
            return this;
        }

        default public FacebookComponentBuilder debugEnabled(Boolean debugEnabled) {
            this.doSetProperty("debugEnabled", debugEnabled);
            return this;
        }

        default public FacebookComponentBuilder gzipEnabled(Boolean gzipEnabled) {
            this.doSetProperty("gzipEnabled", gzipEnabled);
            return this;
        }

        default public FacebookComponentBuilder httpConnectionTimeout(Integer httpConnectionTimeout) {
            this.doSetProperty("httpConnectionTimeout", httpConnectionTimeout);
            return this;
        }

        default public FacebookComponentBuilder httpDefaultMaxPerRoute(Integer httpDefaultMaxPerRoute) {
            this.doSetProperty("httpDefaultMaxPerRoute", httpDefaultMaxPerRoute);
            return this;
        }

        default public FacebookComponentBuilder httpMaxTotalConnections(Integer httpMaxTotalConnections) {
            this.doSetProperty("httpMaxTotalConnections", httpMaxTotalConnections);
            return this;
        }

        default public FacebookComponentBuilder httpReadTimeout(Integer httpReadTimeout) {
            this.doSetProperty("httpReadTimeout", httpReadTimeout);
            return this;
        }

        default public FacebookComponentBuilder httpRetryCount(Integer httpRetryCount) {
            this.doSetProperty("httpRetryCount", httpRetryCount);
            return this;
        }

        default public FacebookComponentBuilder httpRetryIntervalSeconds(Integer httpRetryIntervalSeconds) {
            this.doSetProperty("httpRetryIntervalSeconds", httpRetryIntervalSeconds);
            return this;
        }

        default public FacebookComponentBuilder httpStreamingReadTimeout(Integer httpStreamingReadTimeout) {
            this.doSetProperty("httpStreamingReadTimeout", httpStreamingReadTimeout);
            return this;
        }

        default public FacebookComponentBuilder jsonStoreEnabled(Boolean jsonStoreEnabled) {
            this.doSetProperty("jsonStoreEnabled", jsonStoreEnabled);
            return this;
        }

        default public FacebookComponentBuilder mbeanEnabled(Boolean mbeanEnabled) {
            this.doSetProperty("mbeanEnabled", mbeanEnabled);
            return this;
        }

        default public FacebookComponentBuilder prettyDebugEnabled(Boolean prettyDebugEnabled) {
            this.doSetProperty("prettyDebugEnabled", prettyDebugEnabled);
            return this;
        }

        default public FacebookComponentBuilder restBaseURL(String restBaseURL) {
            this.doSetProperty("restBaseURL", restBaseURL);
            return this;
        }

        default public FacebookComponentBuilder useSSL(Boolean useSSL) {
            this.doSetProperty("useSSL", useSSL);
            return this;
        }

        default public FacebookComponentBuilder videoBaseURL(String videoBaseURL) {
            this.doSetProperty("videoBaseURL", videoBaseURL);
            return this;
        }

        default public FacebookComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public FacebookComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public FacebookComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public FacebookComponentBuilder configuration(FacebookConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public FacebookComponentBuilder httpProxyHost(String httpProxyHost) {
            this.doSetProperty("httpProxyHost", httpProxyHost);
            return this;
        }

        default public FacebookComponentBuilder httpProxyPassword(String httpProxyPassword) {
            this.doSetProperty("httpProxyPassword", httpProxyPassword);
            return this;
        }

        default public FacebookComponentBuilder httpProxyPort(Integer httpProxyPort) {
            this.doSetProperty("httpProxyPort", httpProxyPort);
            return this;
        }

        default public FacebookComponentBuilder httpProxyUser(String httpProxyUser) {
            this.doSetProperty("httpProxyUser", httpProxyUser);
            return this;
        }

        default public FacebookComponentBuilder oAuthAccessToken(String oAuthAccessToken) {
            this.doSetProperty("oAuthAccessToken", oAuthAccessToken);
            return this;
        }

        default public FacebookComponentBuilder oAuthAccessTokenURL(String oAuthAccessTokenURL) {
            this.doSetProperty("oAuthAccessTokenURL", oAuthAccessTokenURL);
            return this;
        }

        default public FacebookComponentBuilder oAuthAppId(String oAuthAppId) {
            this.doSetProperty("oAuthAppId", oAuthAppId);
            return this;
        }

        default public FacebookComponentBuilder oAuthAppSecret(String oAuthAppSecret) {
            this.doSetProperty("oAuthAppSecret", oAuthAppSecret);
            return this;
        }

        default public FacebookComponentBuilder oAuthAuthorizationURL(String oAuthAuthorizationURL) {
            this.doSetProperty("oAuthAuthorizationURL", oAuthAuthorizationURL);
            return this;
        }

        default public FacebookComponentBuilder oAuthPermissions(String oAuthPermissions) {
            this.doSetProperty("oAuthPermissions", oAuthPermissions);
            return this;
        }
    }
}

