/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.caffeine.CaffeineConfiguration;
import org.apache.camel.component.caffeine.EvictionType;
import org.apache.camel.component.caffeine.cache.CaffeineCacheComponent;

public interface CaffeineCacheComponentBuilderFactory {
    public static CaffeineCacheComponentBuilder caffeineCache() {
        return new CaffeineCacheComponentBuilderImpl();
    }

    public static class CaffeineCacheComponentBuilderImpl
    extends AbstractComponentBuilder<CaffeineCacheComponent>
    implements CaffeineCacheComponentBuilder {
        @Override
        protected CaffeineCacheComponent buildConcreteComponent() {
            return new CaffeineCacheComponent();
        }

        private CaffeineConfiguration getOrCreateConfiguration(CaffeineCacheComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new CaffeineConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "action": {
                    this.getOrCreateConfiguration((CaffeineCacheComponent)component).setAction((String)value);
                    return true;
                }
                case "cacheLoader": {
                    this.getOrCreateConfiguration((CaffeineCacheComponent)component).setCacheLoader((CacheLoader)value);
                    return true;
                }
                case "createCacheIfNotExist": {
                    this.getOrCreateConfiguration((CaffeineCacheComponent)component).setCreateCacheIfNotExist(((Boolean)value).booleanValue());
                    return true;
                }
                case "evictionType": {
                    this.getOrCreateConfiguration((CaffeineCacheComponent)component).setEvictionType((EvictionType)value);
                    return true;
                }
                case "expireAfterAccessTime": {
                    this.getOrCreateConfiguration((CaffeineCacheComponent)component).setExpireAfterAccessTime(((Integer)value).intValue());
                    return true;
                }
                case "expireAfterWriteTime": {
                    this.getOrCreateConfiguration((CaffeineCacheComponent)component).setExpireAfterWriteTime(((Integer)value).intValue());
                    return true;
                }
                case "initialCapacity": {
                    this.getOrCreateConfiguration((CaffeineCacheComponent)component).setInitialCapacity(((Integer)value).intValue());
                    return true;
                }
                case "key": {
                    this.getOrCreateConfiguration((CaffeineCacheComponent)component).setKey(value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((CaffeineCacheComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "maximumSize": {
                    this.getOrCreateConfiguration((CaffeineCacheComponent)component).setMaximumSize(((Integer)value).intValue());
                    return true;
                }
                case "removalListener": {
                    this.getOrCreateConfiguration((CaffeineCacheComponent)component).setRemovalListener((RemovalListener)value);
                    return true;
                }
                case "statsCounter": {
                    this.getOrCreateConfiguration((CaffeineCacheComponent)component).setStatsCounter((StatsCounter)value);
                    return true;
                }
                case "statsEnabled": {
                    this.getOrCreateConfiguration((CaffeineCacheComponent)component).setStatsEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((CaffeineCacheComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((CaffeineCacheComponent)component).setConfiguration((CaffeineConfiguration)value);
                    return true;
                }
                case "keyType": {
                    this.getOrCreateConfiguration((CaffeineCacheComponent)component).setKeyType((String)value);
                    return true;
                }
                case "valueType": {
                    this.getOrCreateConfiguration((CaffeineCacheComponent)component).setValueType((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface CaffeineCacheComponentBuilder
    extends ComponentBuilder<CaffeineCacheComponent> {
        default public CaffeineCacheComponentBuilder action(String action) {
            this.doSetProperty("action", action);
            return this;
        }

        default public CaffeineCacheComponentBuilder cacheLoader(CacheLoader cacheLoader) {
            this.doSetProperty("cacheLoader", cacheLoader);
            return this;
        }

        default public CaffeineCacheComponentBuilder createCacheIfNotExist(boolean createCacheIfNotExist) {
            this.doSetProperty("createCacheIfNotExist", createCacheIfNotExist);
            return this;
        }

        default public CaffeineCacheComponentBuilder evictionType(EvictionType evictionType) {
            this.doSetProperty("evictionType", evictionType);
            return this;
        }

        default public CaffeineCacheComponentBuilder expireAfterAccessTime(int expireAfterAccessTime) {
            this.doSetProperty("expireAfterAccessTime", expireAfterAccessTime);
            return this;
        }

        default public CaffeineCacheComponentBuilder expireAfterWriteTime(int expireAfterWriteTime) {
            this.doSetProperty("expireAfterWriteTime", expireAfterWriteTime);
            return this;
        }

        default public CaffeineCacheComponentBuilder initialCapacity(int initialCapacity) {
            this.doSetProperty("initialCapacity", initialCapacity);
            return this;
        }

        default public CaffeineCacheComponentBuilder key(Object key) {
            this.doSetProperty("key", key);
            return this;
        }

        default public CaffeineCacheComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public CaffeineCacheComponentBuilder maximumSize(int maximumSize) {
            this.doSetProperty("maximumSize", maximumSize);
            return this;
        }

        default public CaffeineCacheComponentBuilder removalListener(RemovalListener removalListener) {
            this.doSetProperty("removalListener", removalListener);
            return this;
        }

        default public CaffeineCacheComponentBuilder statsCounter(StatsCounter statsCounter) {
            this.doSetProperty("statsCounter", statsCounter);
            return this;
        }

        default public CaffeineCacheComponentBuilder statsEnabled(boolean statsEnabled) {
            this.doSetProperty("statsEnabled", statsEnabled);
            return this;
        }

        default public CaffeineCacheComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public CaffeineCacheComponentBuilder configuration(CaffeineConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public CaffeineCacheComponentBuilder keyType(String keyType) {
            this.doSetProperty("keyType", keyType);
            return this;
        }

        default public CaffeineCacheComponentBuilder valueType(String valueType) {
            this.doSetProperty("valueType", valueType);
            return this;
        }
    }
}

