/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.eventbridge.EventbridgeComponent;
import org.apache.camel.component.aws2.eventbridge.EventbridgeConfiguration;
import org.apache.camel.component.aws2.eventbridge.EventbridgeOperations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.eventbridge.EventBridgeClient;

public interface Aws2EventbridgeComponentBuilderFactory {
    public static Aws2EventbridgeComponentBuilder aws2Eventbridge() {
        return new Aws2EventbridgeComponentBuilderImpl();
    }

    public static class Aws2EventbridgeComponentBuilderImpl
    extends AbstractComponentBuilder<EventbridgeComponent>
    implements Aws2EventbridgeComponentBuilder {
        @Override
        protected EventbridgeComponent buildConcreteComponent() {
            return new EventbridgeComponent();
        }

        private EventbridgeConfiguration getOrCreateConfiguration(EventbridgeComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new EventbridgeConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((EventbridgeComponent)component).setConfiguration((EventbridgeConfiguration)value);
                    return true;
                }
                case "eventbridgeClient": {
                    this.getOrCreateConfiguration((EventbridgeComponent)component).setEventbridgeClient((EventBridgeClient)value);
                    return true;
                }
                case "eventPatternFile": {
                    this.getOrCreateConfiguration((EventbridgeComponent)component).setEventPatternFile((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((EventbridgeComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((EventbridgeComponent)component).setOperation((EventbridgeOperations)value);
                    return true;
                }
                case "overrideEndpoint": {
                    this.getOrCreateConfiguration((EventbridgeComponent)component).setOverrideEndpoint(((Boolean)value).booleanValue());
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((EventbridgeComponent)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((EventbridgeComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((EventbridgeComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((EventbridgeComponent)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((EventbridgeComponent)component).setRegion((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((EventbridgeComponent)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "uriEndpointOverride": {
                    this.getOrCreateConfiguration((EventbridgeComponent)component).setUriEndpointOverride((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((EventbridgeComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((EventbridgeComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((EventbridgeComponent)component).setSecretKey((String)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface Aws2EventbridgeComponentBuilder
    extends ComponentBuilder<EventbridgeComponent> {
        default public Aws2EventbridgeComponentBuilder configuration(EventbridgeConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public Aws2EventbridgeComponentBuilder eventbridgeClient(EventBridgeClient eventbridgeClient) {
            this.doSetProperty("eventbridgeClient", eventbridgeClient);
            return this;
        }

        default public Aws2EventbridgeComponentBuilder eventPatternFile(String eventPatternFile) {
            this.doSetProperty("eventPatternFile", eventPatternFile);
            return this;
        }

        default public Aws2EventbridgeComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public Aws2EventbridgeComponentBuilder operation(EventbridgeOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public Aws2EventbridgeComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public Aws2EventbridgeComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public Aws2EventbridgeComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public Aws2EventbridgeComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public Aws2EventbridgeComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public Aws2EventbridgeComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public Aws2EventbridgeComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public Aws2EventbridgeComponentBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public Aws2EventbridgeComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public Aws2EventbridgeComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public Aws2EventbridgeComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }
    }
}

