/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cometd;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.cometd.CometdEndpoint;
import org.apache.camel.component.cometd.CometdProducerConsumer;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.ExchangeHelper;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.server.AbstractService;
import org.cometd.server.BayeuxServerImpl;

public class CometdConsumer
extends DefaultConsumer
implements CometdProducerConsumer {
    private BayeuxServerImpl bayeux;
    private final CometdEndpoint endpoint;
    private ConsumerService service;

    public CometdConsumer(CometdEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    public void start() throws Exception {
        super.start();
        this.endpoint.connect(this);
        this.service = new ConsumerService(this.endpoint.getPath(), this.bayeux, this);
    }

    public void stop() throws Exception {
        this.endpoint.disconnect(this);
        super.stop();
    }

    @Override
    public void setBayeux(BayeuxServerImpl bayeux) {
        this.bayeux = bayeux;
    }

    @Override
    public CometdEndpoint getEndpoint() {
        return this.endpoint;
    }

    public ConsumerService getConsumerService() {
        return this.service;
    }

    public static class ConsumerService
    extends AbstractService {
        private final CometdEndpoint endpoint;
        private final CometdConsumer consumer;

        public ConsumerService(String channel, BayeuxServerImpl bayeux, CometdConsumer consumer) {
            super((BayeuxServer)bayeux, channel);
            this.consumer = consumer;
            this.endpoint = consumer.getEndpoint();
            this.addService(channel, "push");
        }

        public void push(ServerSession remote, String channelName, ServerMessage cometdMessage, String messageId) throws Exception {
            Object data = null;
            if (cometdMessage != null) {
                data = cometdMessage.getData();
            }
            DefaultMessage message = new DefaultMessage();
            message.setBody(data);
            Exchange exchange = this.endpoint.createExchange();
            exchange.setIn((Message)message);
            this.consumer.getProcessor().process(exchange);
            if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
                Message camelOutMessage = exchange.getOut();
                remote.deliver((Session)this.getServerSession(), channelName, camelOutMessage.getBody(), null);
            }
        }
    }
}

