/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.cache;

import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.component.cache.DefaultCacheManagerFactory;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.processor.cache.CacheValidate;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheBasedTokenReplacer
extends CacheValidate
implements Processor,
Service {
    private static final Logger LOG = LoggerFactory.getLogger(CacheBasedTokenReplacer.class);
    private CacheManager cacheManager;
    private String cacheName;
    private Expression key;
    private String replacementToken;

    public CacheBasedTokenReplacer(String cacheName, String key, String replacementToken) {
        this(cacheName, ExpressionBuilder.constantExpression((Object)key), replacementToken);
    }

    public CacheBasedTokenReplacer(String cacheName, Expression key, String replacementToken) {
        if (cacheName.contains("cache://")) {
            this.setCacheName(cacheName.replace("cache://", ""));
        } else {
            this.setCacheName(cacheName);
        }
        this.setKey(key);
        this.setReplacementToken(replacementToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        String cacheKey = (String)this.key.evaluate(exchange, String.class);
        if (this.isValid(this.cacheManager, this.cacheName, cacheKey)) {
            byte[] buffer;
            Cache cache = this.cacheManager.getCache(this.cacheName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Replacing Token {} in Message with value stored against key {} in CacheName {}", new Object[]{this.replacementToken, cacheKey, this.cacheName});
            }
            exchange.getIn().setHeader("CamelCacheKey", (Object)cacheKey);
            Object body = exchange.getIn().getBody();
            InputStream is = (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, body);
            try {
                buffer = IOConverter.toBytes((InputStream)is);
            }
            finally {
                IOHelper.close((Closeable)is, (String)"is", (Logger)LOG);
            }
            String cacheValue = (String)exchange.getContext().getTypeConverter().convertTo(String.class, cache.get((Serializable)((Object)cacheKey)).getObjectValue());
            String replacedTokenString = new String(buffer).replaceAll(this.replacementToken, cacheValue);
            LOG.trace("replacedTokenString = {}", (Object)replacedTokenString);
            exchange.getIn().setBody((Object)replacedTokenString.getBytes());
        }
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public Expression getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = ExpressionBuilder.constantExpression((Object)key);
    }

    public void setKey(Expression key) {
        this.key = key;
    }

    public String getReplacementToken() {
        return this.replacementToken;
    }

    public void setReplacementToken(String replacementToken) {
        this.replacementToken = replacementToken;
    }

    public void start() throws Exception {
        if (this.cacheManager == null) {
            this.cacheManager = new DefaultCacheManagerFactory().getInstance();
        }
    }

    public void stop() throws Exception {
    }
}

