/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format.factories;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.FormattingOptions;
import org.apache.camel.dataformat.bindy.PatternFormat;
import org.apache.camel.dataformat.bindy.format.FormatException;
import org.apache.camel.dataformat.bindy.format.factories.AbstractFormatFactory;
import org.apache.camel.util.ObjectHelper;

public class DateFormatFactory
extends AbstractFormatFactory {
    public DateFormatFactory() {
        this.supportedClasses.add(Date.class);
    }

    @Override
    public Format<?> build(FormattingOptions formattingOptions) {
        return new DatePatternFormat(formattingOptions.getPattern(), formattingOptions.getTimezone(), formattingOptions.getLocale());
    }

    private static class DatePatternFormat
    implements PatternFormat<Date> {
        private String pattern;
        private Locale locale;
        private TimeZone timezone;

        DatePatternFormat(String pattern, String timezone, Locale locale) {
            this.pattern = pattern;
            this.locale = locale;
            if (!timezone.isEmpty()) {
                this.timezone = TimeZone.getTimeZone(timezone);
            }
        }

        @Override
        public String format(Date object) throws Exception {
            ObjectHelper.notNull((Object)this.pattern, (String)"pattern");
            return this.getDateFormat().format(object);
        }

        @Override
        public Date parse(String string) throws Exception {
            DateFormat df = this.getDateFormat();
            ObjectHelper.notNull((Object)this.pattern, (String)"pattern");
            if (string.length() <= this.pattern.length()) {
                df.setLenient(false);
                Date date = df.parse(string);
                return date;
            }
            throw new FormatException("Date provided does not fit the pattern defined");
        }

        protected DateFormat getDateFormat() {
            SimpleDateFormat result = this.locale != null ? new SimpleDateFormat(this.pattern, this.locale) : new SimpleDateFormat(this.pattern);
            if (this.timezone != null) {
                result.setTimeZone(this.timezone);
            }
            return result;
        }

        @Override
        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }
    }
}

