/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy.format;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.camel.dataformat.bindy.PatternFormat;

public abstract class NumberPatternFormat<T>
implements PatternFormat<T> {
    private String pattern;
    private Locale locale;

    public NumberPatternFormat() {
    }

    public NumberPatternFormat(String pattern, Locale locale) {
        this.pattern = pattern;
        this.locale = locale;
    }

    @Override
    public String format(T object) throws Exception {
        if (this.getNumberFormat() != null) {
            return this.getNumberFormat().format(object);
        }
        return object.toString();
    }

    @Override
    public abstract T parse(String var1) throws Exception;

    protected NumberFormat getNumberFormat() {
        if (this.locale == null) {
            return null;
        }
        NumberFormat format = NumberFormat.getNumberInstance(this.locale);
        if (format instanceof DecimalFormat) {
            ((DecimalFormat)format).applyLocalizedPattern(this.pattern);
        }
        return format;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }
}

