/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.engine.AbstractDynamicRegistry;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.NormalizedUri;

public class DefaultEndpointRegistry
extends AbstractDynamicRegistry<NormalizedUri, Endpoint>
implements EndpointRegistry<NormalizedUri> {
    public DefaultEndpointRegistry(CamelContext context) {
        super(context, CamelContextHelper.getMaximumEndpointCacheSize((CamelContext)context));
    }

    public DefaultEndpointRegistry(CamelContext context, Map<NormalizedUri, Endpoint> endpoints) {
        this(context);
        if (!context.isStarted()) {
            this.staticMap.putAll(endpoints);
        } else {
            this.putAll(endpoints);
        }
    }

    @Override
    public boolean isStatic(String key) {
        return this.isStatic(NormalizedUri.newNormalizedUri((String)key, (boolean)false));
    }

    @Override
    public boolean isDynamic(String key) {
        return this.isDynamic(NormalizedUri.newNormalizedUri((String)key, (boolean)false));
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            key = NormalizedUri.newNormalizedUri((String)key.toString(), (boolean)false);
        }
        return super.containsKey(key);
    }

    @Override
    public String toString() {
        return "EndpointRegistry for " + this.context.getName() + " [capacity: " + this.maxCacheSize + "]";
    }
}

