/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ses;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.ses.SesConfiguration;
import org.apache.camel.component.aws.ses.SesProducer;
import org.apache.camel.impl.DefaultEndpoint;

public class SesEndpoint
extends DefaultEndpoint {
    private SesConfiguration configuration;

    @Deprecated
    public SesEndpoint(String uri, CamelContext context, SesConfiguration configuration) {
        super(uri, context);
        this.configuration = configuration;
    }

    public SesEndpoint(String uri, Component component, SesConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new SesProducer((Endpoint)this);
    }

    public boolean isSingleton() {
        return true;
    }

    public SesConfiguration getConfiguration() {
        return this.configuration;
    }

    public AmazonSimpleEmailService getSESClient() {
        return this.configuration.getAmazonSESClient() != null ? this.configuration.getAmazonSESClient() : this.createSESClient();
    }

    private AmazonSimpleEmailService createSESClient() {
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
        AmazonSimpleEmailServiceClient client = new AmazonSimpleEmailServiceClient((AWSCredentials)credentials);
        if (this.configuration.getAmazonSESEndpoint() != null) {
            client.setEndpoint(this.configuration.getAmazonSESEndpoint());
        }
        this.configuration.setAmazonSESClient((AmazonSimpleEmailService)client);
        return client;
    }
}

