/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.s3;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import java.io.InputStream;
import java.util.Date;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws.s3.S3Configuration;
import org.apache.camel.component.aws.s3.S3Endpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(S3Producer.class);

    public S3Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        Date lastModified;
        String contentMD5;
        String contentEncoding;
        String contentDisposition;
        String cacheControl;
        String contentType;
        ObjectMetadata objectMetadata = new ObjectMetadata();
        Long contentLength = (Long)exchange.getIn().getHeader("CamelAwsS3ContentLength", Long.class);
        if (contentLength != null) {
            objectMetadata.setContentLength(contentLength.longValue());
        }
        if ((contentType = (String)exchange.getIn().getHeader("CamelAwsS3ContentType", String.class)) != null) {
            objectMetadata.setContentType(contentType);
        }
        if ((cacheControl = (String)exchange.getIn().getHeader("CamelAwsS3ContentControl", String.class)) != null) {
            objectMetadata.setCacheControl(cacheControl);
        }
        if ((contentDisposition = (String)exchange.getIn().getHeader("CamelAwsS3ContentDisposition", String.class)) != null) {
            objectMetadata.setContentDisposition(contentDisposition);
        }
        if ((contentEncoding = (String)exchange.getIn().getHeader("CamelAwsS3ContentEncoding", String.class)) != null) {
            objectMetadata.setContentEncoding(contentEncoding);
        }
        if ((contentMD5 = (String)exchange.getIn().getHeader("CamelAwsS3ContentMD5", String.class)) != null) {
            objectMetadata.setContentMD5(contentMD5);
        }
        if ((lastModified = (Date)exchange.getIn().getHeader("CamelAwsS3LastModified", Date.class)) != null) {
            objectMetadata.setLastModified(lastModified);
        }
        PutObjectRequest putObjectRequest = new PutObjectRequest(this.getConfiguration().getBucketName(), this.determineKey(exchange), (InputStream)exchange.getIn().getMandatoryBody(InputStream.class), objectMetadata);
        String storageClass = this.determineStorageClass(exchange);
        if (storageClass != null) {
            putObjectRequest.setStorageClass(storageClass);
        }
        LOG.trace("Put object [{}] from exchange [{}]...", (Object)putObjectRequest, (Object)exchange);
        PutObjectResult putObjectResult = this.getEndpoint().getS3Client().putObject(putObjectRequest);
        LOG.trace("Received result [{}]", (Object)putObjectResult);
        Message message = this.getMessageForResponse(exchange);
        message.setHeader("CamelAwsS3ETag", (Object)putObjectResult.getETag());
        if (putObjectResult.getVersionId() != null) {
            message.setHeader("CamelAwsS3VersionId", (Object)putObjectResult.getVersionId());
        }
    }

    private String determineKey(Exchange exchange) {
        String key = (String)exchange.getIn().getHeader("CamelAwsS3Key", String.class);
        if (key == null) {
            throw new IllegalArgumentException("AWS S3 Key header missing.");
        }
        return key;
    }

    private String determineStorageClass(Exchange exchange) {
        String storageClass = (String)exchange.getIn().getHeader("CamelAwsS3StorageClass", String.class);
        if (storageClass == null) {
            storageClass = this.getConfiguration().getStorageClass();
        }
        return storageClass;
    }

    private Message getMessageForResponse(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.copyFrom(exchange.getIn());
            return out;
        }
        return exchange.getIn();
    }

    protected S3Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        return "S3Producer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
    }

    public S3Endpoint getEndpoint() {
        return (S3Endpoint)super.getEndpoint();
    }
}

