/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.server;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.calcite.avatica.metrics.MetricsSystemConfiguration;
import org.apache.calcite.avatica.remote.AuthenticationType;
import org.apache.calcite.avatica.remote.Driver;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.server.AvaticaHandler;
import org.apache.calcite.avatica.server.AvaticaServerConfiguration;
import org.apache.calcite.avatica.server.DelegatingAvaticaHandler;
import org.apache.calcite.avatica.server.DoAsRemoteUserCallback;
import org.apache.calcite.avatica.server.HandlerFactory;
import org.apache.calcite.avatica.server.PropertyBasedSpnegoLoginService;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.DigestAuthenticator;
import org.eclipse.jetty.security.authentication.SpnegoAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServer {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServer.class);
    private Server server;
    private int port = -1;
    private final AvaticaHandler handler;
    private final AvaticaServerConfiguration config;
    private final Subject subject;

    @Deprecated
    public HttpServer(Handler handler) {
        this(HttpServer.wrapJettyHandler(handler));
    }

    public HttpServer(AvaticaHandler handler) {
        this(0, handler);
    }

    @Deprecated
    public HttpServer(int port, Handler handler) {
        this(port, HttpServer.wrapJettyHandler(handler));
    }

    public HttpServer(int port, AvaticaHandler handler) {
        this(port, handler, null);
    }

    public HttpServer(int port, AvaticaHandler handler, AvaticaServerConfiguration config) {
        this(port, handler, config, null);
    }

    public HttpServer(int port, AvaticaHandler handler, AvaticaServerConfiguration config, Subject subject) {
        this.port = port;
        this.handler = handler;
        this.config = config;
        this.subject = subject;
    }

    private static AvaticaHandler wrapJettyHandler(Handler handler) {
        if (handler instanceof AvaticaHandler) {
            return (AvaticaHandler)handler;
        }
        return new DelegatingAvaticaHandler(handler);
    }

    public void start() {
        if (null != this.subject) {
            Subject.doAs(this.subject, new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    HttpServer.this.internalStart();
                    return null;
                }
            });
        } else {
            this.internalStart();
        }
    }

    protected void internalStart() {
        if (this.server != null) {
            throw new RuntimeException("Server is already started");
        }
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setDaemon(true);
        this.server = new Server((ThreadPool)threadPool);
        this.server.manage((Object)threadPool);
        ServerConnector connector = this.configureConnector(new ServerConnector(this.server), this.port);
        ConstraintSecurityHandler securityHandler = null;
        if (null != this.config) {
            switch (this.config.getAuthenticationType()) {
                case SPNEGO: {
                    securityHandler = this.configureSpnego(this.server, connector, this.config);
                    break;
                }
                case BASIC: {
                    securityHandler = this.configureBasicAuthentication(this.server, connector, this.config);
                    break;
                }
                case DIGEST: {
                    securityHandler = this.configureDigestAuthentication(this.server, connector, this.config);
                    break;
                }
            }
        }
        this.server.setConnectors(new Connector[]{connector});
        HandlerList handlerList = new HandlerList();
        AvaticaHandler avaticaHandler = this.handler;
        if (null != securityHandler) {
            securityHandler.setHandler((Handler)this.handler);
            avaticaHandler = securityHandler;
        }
        handlerList.setHandlers(new Handler[]{avaticaHandler, new DefaultHandler()});
        this.server.setHandler((Handler)handlerList);
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.port = connector.getLocalPort();
        LOG.info("Service listening on port {}.", (Object)this.getPort());
        try {
            this.handler.setServerRpcMetadata(this.createRpcServerMetadata(connector));
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private Service.RpcMetadataResponse createRpcServerMetadata(ServerConnector connector) throws UnknownHostException {
        String host = connector.getHost();
        if (null == host) {
            host = InetAddress.getLocalHost().getHostName();
        }
        int port = connector.getLocalPort();
        return new Service.RpcMetadataResponse(String.format("%s:%d", host, port));
    }

    protected ConstraintSecurityHandler configureSpnego(Server server, ServerConnector connector, AvaticaServerConfiguration config) {
        String realm = Objects.requireNonNull(config.getKerberosRealm());
        String principal = Objects.requireNonNull(config.getKerberosPrincipal());
        PropertyBasedSpnegoLoginService spnegoLoginService = new PropertyBasedSpnegoLoginService(realm, principal);
        String[] allowedRealms = this.getAllowedRealms(realm, config);
        return this.configureCommonAuthentication(server, connector, config, "SPNEGO", allowedRealms, (Authenticator)new SpnegoAuthenticator(), realm, (LoginService)spnegoLoginService);
    }

    protected String[] getAllowedRealms(String serverRealm, AvaticaServerConfiguration config) {
        String[] allowedRealms = new String[]{serverRealm};
        if (null != config.getAllowedRoles()) {
            allowedRealms = new String[config.getAllowedRoles().length + 1];
            allowedRealms[0] = serverRealm;
            System.arraycopy(config.getAllowedRoles(), 0, allowedRealms, 1, config.getAllowedRoles().length);
        }
        return allowedRealms;
    }

    protected ConstraintSecurityHandler configureBasicAuthentication(Server server, ServerConnector connector, AvaticaServerConfiguration config) {
        String[] allowedRoles = config.getAllowedRoles();
        String realm = config.getHashLoginServiceRealm();
        String loginServiceProperties = config.getHashLoginServiceProperties();
        HashLoginService loginService = new HashLoginService(realm, loginServiceProperties);
        server.addBean((Object)loginService);
        return this.configureCommonAuthentication(server, connector, config, "BASIC", allowedRoles, (Authenticator)new BasicAuthenticator(), null, (LoginService)loginService);
    }

    protected ConstraintSecurityHandler configureDigestAuthentication(Server server, ServerConnector connector, AvaticaServerConfiguration config) {
        String[] allowedRoles = config.getAllowedRoles();
        String realm = config.getHashLoginServiceRealm();
        String loginServiceProperties = config.getHashLoginServiceProperties();
        HashLoginService loginService = new HashLoginService(realm, loginServiceProperties);
        server.addBean((Object)loginService);
        return this.configureCommonAuthentication(server, connector, config, "DIGEST", allowedRoles, (Authenticator)new DigestAuthenticator(), null, (LoginService)loginService);
    }

    protected ConstraintSecurityHandler configureCommonAuthentication(Server server, ServerConnector connector, AvaticaServerConfiguration config, String constraintName, String[] allowedRoles, Authenticator authenticator, String realm, LoginService loginService) {
        Constraint constraint = new Constraint();
        constraint.setName(constraintName);
        constraint.setRoles(allowedRoles);
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/*");
        ConstraintSecurityHandler sh = new ConstraintSecurityHandler();
        sh.setAuthenticator(authenticator);
        sh.setLoginService(loginService);
        sh.setConstraintMappings(new ConstraintMapping[]{cm});
        sh.setRealmName(realm);
        return sh;
    }

    protected ServerConnector configureConnector(ServerConnector connector, int port) {
        connector.setIdleTimeout(60000L);
        connector.setSoLingerTime(-1);
        connector.setPort(port);
        return connector;
    }

    protected AvaticaServerConfiguration getConfig() {
        return this.config;
    }

    public void stop() {
        if (this.server == null) {
            throw new RuntimeException("Server is already stopped");
        }
        LOG.info("Service terminating.");
        try {
            Server server1 = this.server;
            this.port = -1;
            this.server = null;
            server1.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void join() throws InterruptedException {
        this.server.join();
    }

    public int getPort() {
        return this.port;
    }

    public static class Builder {
        private int port;
        private Service service;
        private Driver.Serialization serialization;
        private AvaticaHandler handler = null;
        private MetricsSystemConfiguration<?> metricsConfig;
        private AuthenticationType authenticationType = AuthenticationType.NONE;
        private String kerberosPrincipal;
        private String kerberosRealm;
        private File keytab;
        private DoAsRemoteUserCallback remoteUserCallback;
        private String loginServiceRealm;
        private String loginServiceProperties;
        private String[] loginServiceAllowedRoles;

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withHandler(Service service, Driver.Serialization serialization) {
            this.service = Objects.requireNonNull(service);
            this.serialization = Objects.requireNonNull(serialization);
            return this;
        }

        public Builder withHandler(AvaticaHandler handler) {
            this.handler = Objects.requireNonNull(handler);
            return this;
        }

        public Builder withMetricsConfiguration(MetricsSystemConfiguration<?> metricsConfig) {
            this.metricsConfig = Objects.requireNonNull(metricsConfig);
            return this;
        }

        public Builder withSpnego(String principal) {
            return this.withSpnego(principal, (String[])null);
        }

        public Builder withSpnego(String principal, String[] additionalAllowedRealms) {
            int index = Objects.requireNonNull(principal).lastIndexOf(64);
            if (-1 == index) {
                throw new IllegalArgumentException("Could not find '@' symbol in '" + principal + "' to parse the Kerberos realm from the principal");
            }
            String realm = principal.substring(index + 1);
            return this.withSpnego(principal, realm, additionalAllowedRealms);
        }

        public Builder withSpnego(String principal, String realm) {
            return this.withSpnego(principal, realm, null);
        }

        public Builder withSpnego(String principal, String realm, String[] additionalAllowedRealms) {
            this.authenticationType = AuthenticationType.SPNEGO;
            this.kerberosPrincipal = Objects.requireNonNull(principal);
            this.kerberosRealm = Objects.requireNonNull(realm);
            this.loginServiceAllowedRoles = additionalAllowedRealms;
            return this;
        }

        public Builder withAutomaticLogin(File keytab) {
            this.keytab = Objects.requireNonNull(keytab);
            return this;
        }

        public Builder withImpersonation(DoAsRemoteUserCallback remoteUserCallback) {
            this.remoteUserCallback = Objects.requireNonNull(remoteUserCallback);
            return this;
        }

        public Builder withBasicAuthentication(String properties, String[] allowedRoles) {
            return this.withAuthentication(AuthenticationType.BASIC, properties, allowedRoles);
        }

        public Builder withDigestAuthentication(String properties, String[] allowedRoles) {
            return this.withAuthentication(AuthenticationType.DIGEST, properties, allowedRoles);
        }

        private Builder withAuthentication(AuthenticationType authType, String properties, String[] allowedRoles) {
            this.loginServiceRealm = "Avatica";
            this.authenticationType = authType;
            this.loginServiceProperties = Objects.requireNonNull(properties);
            this.loginServiceAllowedRoles = Objects.requireNonNull(allowedRoles);
            return this;
        }

        public HttpServer build() {
            Subject subject;
            AvaticaServerConfiguration serverConfig;
            switch (this.authenticationType) {
                case NONE: {
                    serverConfig = null;
                    subject = null;
                    break;
                }
                case BASIC: 
                case DIGEST: {
                    serverConfig = this.buildUserAuthenticationConfiguration(this);
                    subject = null;
                    break;
                }
                case SPNEGO: {
                    if (null != this.keytab) {
                        LOG.debug("Performing Kerberos login with {} as {}", (Object)this.keytab, (Object)this.kerberosPrincipal);
                        subject = this.loginViaKerberos(this);
                    } else {
                        LOG.debug("Not performing Kerberos login");
                        subject = null;
                    }
                    serverConfig = this.buildSpnegoConfiguration(this);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled AuthenticationType");
                }
            }
            AvaticaHandler handler = this.buildHandler(this, serverConfig);
            return new HttpServer(this.port, handler, serverConfig, subject);
        }

        private AvaticaHandler buildHandler(Builder b, AvaticaServerConfiguration config) {
            if (null != b.handler) {
                return b.handler;
            }
            HandlerFactory factory = new HandlerFactory();
            return factory.getHandler(b.service, b.serialization, b.metricsConfig, config);
        }

        private AvaticaServerConfiguration buildSpnegoConfiguration(Builder b) {
            final String principal = b.kerberosPrincipal;
            final String realm = b.kerberosRealm;
            final String[] additionalAllowedRealms = b.loginServiceAllowedRoles;
            final DoAsRemoteUserCallback callback = b.remoteUserCallback;
            return new AvaticaServerConfiguration(){

                @Override
                public AuthenticationType getAuthenticationType() {
                    return AuthenticationType.SPNEGO;
                }

                @Override
                public String getKerberosRealm() {
                    return realm;
                }

                @Override
                public String getKerberosPrincipal() {
                    return principal;
                }

                @Override
                public boolean supportsImpersonation() {
                    return null != callback;
                }

                @Override
                public <T> T doAsRemoteUser(String remoteUserName, String remoteAddress, Callable<T> action) throws Exception {
                    return callback.doAsRemoteUser(remoteUserName, remoteAddress, action);
                }

                @Override
                public String[] getAllowedRoles() {
                    return additionalAllowedRealms;
                }

                @Override
                public String getHashLoginServiceRealm() {
                    return null;
                }

                @Override
                public String getHashLoginServiceProperties() {
                    return null;
                }
            };
        }

        private AvaticaServerConfiguration buildUserAuthenticationConfiguration(Builder b) {
            final AuthenticationType authType = b.authenticationType;
            final String[] allowedRoles = b.loginServiceAllowedRoles;
            final String realm = b.loginServiceRealm;
            final String properties = b.loginServiceProperties;
            return new AvaticaServerConfiguration(){

                @Override
                public AuthenticationType getAuthenticationType() {
                    return authType;
                }

                @Override
                public String[] getAllowedRoles() {
                    return allowedRoles;
                }

                @Override
                public String getHashLoginServiceRealm() {
                    return realm;
                }

                @Override
                public String getHashLoginServiceProperties() {
                    return properties;
                }

                @Override
                public String getKerberosRealm() {
                    return null;
                }

                @Override
                public String getKerberosPrincipal() {
                    return null;
                }

                @Override
                public boolean supportsImpersonation() {
                    return false;
                }

                @Override
                public <T> T doAsRemoteUser(String remoteUserName, String remoteAddress, Callable<T> action) throws Exception {
                    return null;
                }
            };
        }

        private Subject loginViaKerberos(Builder b) {
            HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
            principals.add(new KerberosPrincipal(b.kerberosPrincipal));
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            KeytabJaasConf conf = new KeytabJaasConf(b.kerberosPrincipal, b.keytab.toString());
            String confName = "NotUsed";
            try {
                LoginContext loginContext = new LoginContext(confName, subject, null, conf);
                loginContext.login();
                return loginContext.getSubject();
            }
            catch (LoginException e) {
                throw new RuntimeException(e);
            }
        }

        private static String getKrb5LoginModuleName() {
            return System.getProperty("java.vendor").contains("IBM") ? "com.ibm.security.auth.module.Krb5LoginModule" : "com.sun.security.auth.module.Krb5LoginModule";
        }

        private static class KeytabJaasConf
        extends Configuration {
            private final String principal;
            private final String keytab;

            private KeytabJaasConf(String principal, String keytab) {
                this.principal = principal;
                this.keytab = keytab;
            }

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("storeKey", "true");
                options.put("principal", this.principal);
                options.put("keyTab", this.keytab);
                options.put("doNotPrompt", "true");
                options.put("useKeyTab", "true");
                options.put("isInitiator", "false");
                options.put("debug", System.getProperty("sun.security.krb5.debug", "false").toLowerCase());
                return new AppConfigurationEntry[]{new AppConfigurationEntry(Builder.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
            }
        }
    }
}

