/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.control;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.runners.fnexecution.control.BundleFinalizationHandler;
import org.apache.beam.runners.fnexecution.control.InstructionRequestHandler;

public class BundleFinalizationHandlers {
    public static InMemoryFinalizer inMemoryFinalizer(InstructionRequestHandler fnApiControlClient) {
        return new InMemoryFinalizer(fnApiControlClient);
    }

    public static class InMemoryFinalizer
    implements BundleFinalizationHandler {
        private final InstructionRequestHandler fnApiControlClient;
        private final List<String> bundleIds;

        private InMemoryFinalizer(InstructionRequestHandler fnApiControlClient) {
            this.fnApiControlClient = fnApiControlClient;
            this.bundleIds = new ArrayList<String>();
        }

        public synchronized void finalizeAllOutstandingBundles() {
            for (String bundleId : this.bundleIds) {
                BeamFnApi.InstructionRequest request = BeamFnApi.InstructionRequest.newBuilder().setFinalizeBundle(BeamFnApi.FinalizeBundleRequest.newBuilder().setInstructionId(bundleId).build()).build();
                this.fnApiControlClient.handle(request);
            }
            this.bundleIds.clear();
        }

        @Override
        public synchronized void requestsFinalization(String bundleId) {
            this.bundleIds.add(bundleId);
        }
    }
}

