/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.saaj;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.Text;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAP11Version;
import org.apache.axiom.soap.SOAP12Version;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.saaj.PrefixedQName;
import org.apache.axis2.saaj.SOAPElementImpl;
import org.apache.axis2.saaj.SOAPHeaderElementImpl;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPHeaderImpl
extends SOAPElementImpl<SOAPHeader>
implements javax.xml.soap.SOAPHeader {
    public SOAPHeaderImpl(SOAPHeader header) {
        super(header);
    }

    @Override
    public SOAPElement addChildElement(String localName) throws SOAPException {
        return this.addHeaderElement(new PrefixedQName(null, localName, null));
    }

    @Override
    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        String namespaceURI = this.getNamespaceURI(prefix);
        if (namespaceURI == null) {
            throw new SOAPException("Namespace not declared for the give prefix: " + prefix);
        }
        return this.addChildElement(localName, prefix, namespaceURI);
    }

    @Override
    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        OMNamespace ns = ((SOAPHeader)this.omTarget).getOMFactory().createOMNamespace(uri, prefix);
        SOAPHeaderBlock headerBlock = ((SOAPFactory)((SOAPHeader)this.omTarget).getOMFactory()).createSOAPHeaderBlock(localName, ns, (SOAPHeader)this.omTarget);
        SOAPHeaderElementImpl soapHeaderElement = new SOAPHeaderElementImpl(headerBlock);
        ((Element)this.target).setUserData("saaj.node", this, null);
        ((Element)soapHeaderElement.target).setUserData("saaj.node", soapHeaderElement, null);
        soapHeaderElement.setParentElement(this);
        return soapHeaderElement;
    }

    @Override
    public SOAPElement addChildElement(Name name) throws SOAPException {
        return this.addHeaderElement(name);
    }

    @Override
    public SOAPElement addChildElement(SOAPElement soapElement) throws SOAPException {
        OMNamespace ns = ((SOAPHeader)this.omTarget).getOMFactory().createOMNamespace(soapElement.getNamespaceURI(), soapElement.getPrefix());
        SOAPHeaderBlock headerBlock = ((SOAPFactory)((SOAPHeader)this.omTarget).getOMFactory()).createSOAPHeaderBlock(soapElement.getLocalName(), ns, (SOAPHeader)this.omTarget);
        SOAPHeaderElementImpl soapHeaderElement = new SOAPHeaderElementImpl(headerBlock);
        ((Element)this.target).setUserData("saaj.node", this, null);
        ((Element)soapHeaderElement.target).setUserData("saaj.node", soapHeaderElement, null);
        soapHeaderElement.setParentElement(this);
        return soapHeaderElement;
    }

    @Override
    protected Element appendElement(Element child) throws SOAPException {
        OMNamespace ns = ((SOAPHeader)this.omTarget).getOMFactory().createOMNamespace(child.getNamespaceURI(), child.getPrefix());
        SOAPHeaderBlock headerBlock = ((SOAPFactory)((SOAPHeader)this.omTarget).getOMFactory()).createSOAPHeaderBlock(child.getLocalName(), ns, (SOAPHeader)this.omTarget);
        ((Element)this.target).setUserData("saaj.node", this, null);
        SOAPHeaderElementImpl soapHeaderElement = new SOAPHeaderElementImpl(headerBlock);
        this.copyContents(soapHeaderElement, child);
        ((Element)soapHeaderElement.target).setUserData("saaj.node", soapHeaderElement, null);
        soapHeaderElement.setParentElement(this);
        return soapHeaderElement;
    }

    public SOAPHeaderElement addHeaderElement(Name name) throws SOAPException {
        if (name.getURI() == null || name.getURI().trim().length() == 0) {
            throw new SOAPException("SOAP1.1 and SOAP1.2 requires all HeaderElements to have a namespace.");
        }
        String prefix = name.getPrefix() == null ? "" : name.getPrefix();
        OMNamespace ns = ((SOAPHeader)this.omTarget).getOMFactory().createOMNamespace(name.getURI(), prefix);
        SOAPHeaderBlock headerBlock = ((SOAPFactory)((SOAPHeader)this.omTarget).getOMFactory()).createSOAPHeaderBlock(name.getLocalName(), ns, (SOAPHeader)this.omTarget);
        SOAPHeaderElementImpl soapHeaderElement = new SOAPHeaderElementImpl(headerBlock);
        ((Element)this.target).setUserData("saaj.node", this, null);
        ((Element)soapHeaderElement.target).setUserData("saaj.node", soapHeaderElement, null);
        soapHeaderElement.setParentElement(this);
        return soapHeaderElement;
    }

    public Iterator examineHeaderElements(String actor) {
        ArrayList<Node> elements = new ArrayList<Node>();
        Iterator iterator = ((SOAPHeader)this.omTarget).examineHeaderBlocks(actor);
        while (iterator.hasNext()) {
            elements.add(this.toSAAJNode((org.w3c.dom.Node)iterator.next()));
        }
        return elements.iterator();
    }

    public Iterator extractHeaderElements(String actor) {
        ArrayList<Node> elements = new ArrayList<Node>();
        Iterator iterator = ((SOAPHeader)this.omTarget).extractHeaderBlocks(actor);
        while (iterator.hasNext()) {
            elements.add(this.toSAAJNode((org.w3c.dom.Node)iterator.next()));
        }
        return elements.iterator();
    }

    public Iterator examineMustUnderstandHeaderElements(String actor) {
        ArrayList<Node> elements = new ArrayList<Node>();
        Iterator iterator = ((SOAPHeader)this.omTarget).examineMustUnderstandHeaderBlocks(actor);
        while (iterator.hasNext()) {
            elements.add(this.toSAAJNode((org.w3c.dom.Node)iterator.next()));
        }
        return elements.iterator();
    }

    public Iterator examineAllHeaderElements() {
        ArrayList<Node> elements = new ArrayList<Node>();
        Iterator iterator = ((SOAPHeader)this.omTarget).examineAllHeaderBlocks();
        while (iterator.hasNext()) {
            elements.add(this.toSAAJNode((org.w3c.dom.Node)iterator.next()));
        }
        return elements.iterator();
    }

    public Iterator extractAllHeaderElements() {
        ArrayList<Node> elements = new ArrayList<Node>();
        Iterator iterator = ((SOAPHeader)this.omTarget).extractAllHeaderBlocks();
        while (iterator.hasNext()) {
            elements.add(this.toSAAJNode((org.w3c.dom.Node)iterator.next()));
        }
        return elements.iterator();
    }

    public SOAPHeaderElement addHeaderElement(QName qname) throws SOAPException {
        return (SOAPHeaderElement)this.addChildElement(qname.getLocalPart(), qname.getPrefix(), qname.getNamespaceURI());
    }

    public SOAPHeaderElement addNotUnderstoodHeaderElement(QName qname) throws SOAPException {
        SOAPHeaderBlock soapHeaderBlock = null;
        OMNamespace ns = ((SOAPHeader)this.omTarget).getOMFactory().createOMNamespace(qname.getNamespaceURI(), qname.getPrefix());
        if (((SOAPFactory)((SOAPHeader)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            throw new UnsupportedOperationException();
        }
        soapHeaderBlock = ((SOAPHeader)this.omTarget).addHeaderBlock("NotUnderstood", ((SOAPHeader)this.omTarget).getNamespace());
        soapHeaderBlock.addAttribute(qname.getLocalPart(), qname.getPrefix(), ns);
        SOAPHeaderElementImpl soapHeaderElementImpl = new SOAPHeaderElementImpl(soapHeaderBlock);
        return soapHeaderElementImpl;
    }

    public SOAPHeaderElement addUpgradeHeaderElement(Iterator iterator) throws SOAPException {
        SOAPHeaderBlock upgrade = ((SOAPHeader)this.omTarget).addHeaderBlock("Upgrade", ((SOAPHeader)this.omTarget).getNamespace());
        int index = 0;
        String prefix = "ns";
        while (iterator.hasNext()) {
            String supported = (String)iterator.next();
            OMNamespace namespace = ((SOAPHeader)this.omTarget).getOMFactory().createOMNamespace(supported, prefix + ++index);
            OMElement supportedEnvelop = ((SOAPHeader)this.omTarget).getOMFactory().createOMElement("SupportedEnvelope", namespace);
            supportedEnvelop.addAttribute("qname", prefix + index + ":" + "Envelope", null);
            upgrade.addChild((OMNode)supportedEnvelop);
        }
        SOAPHeaderElementImpl soapHeaderElementImpl = new SOAPHeaderElementImpl(upgrade);
        return soapHeaderElementImpl;
    }

    public SOAPHeaderElement addUpgradeHeaderElement(String[] as) throws SOAPException {
        ArrayList<String> supportedEnvelops = new ArrayList<String>();
        for (int a = 0; a < as.length; ++a) {
            String supported = as[a];
            supportedEnvelops.add(supported);
        }
        if (supportedEnvelops.size() > 0) {
            return this.addUpgradeHeaderElement(supportedEnvelops.iterator());
        }
        return null;
    }

    public SOAPHeaderElement addUpgradeHeaderElement(String s) throws SOAPException {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        ArrayList<String> supportedEnvelops = new ArrayList<String>();
        supportedEnvelops.add(s);
        return this.addUpgradeHeaderElement(supportedEnvelops.iterator());
    }

    @Override
    public SOAPElement addTextNode(String text) throws SOAPException {
        if (((SOAPFactory)((SOAPHeader)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP11Version.getSingleton()) {
            return super.addTextNode(text);
        }
        if (((SOAPFactory)((SOAPHeader)this.omTarget).getOMFactory()).getSOAPVersion() == SOAP12Version.getSingleton()) {
            throw new SOAPException("Cannot add text node to SOAPHeader");
        }
        return null;
    }

    @Override
    public Iterator getChildElements(Name name) {
        QName qName = new QName(name.getURI(), name.getLocalName());
        return this.getChildren(((SOAPHeader)this.omTarget).getChildrenWithName(qName));
    }

    @Override
    public Iterator getChildElements() {
        return this.getChildren(((SOAPHeader)this.omTarget).getChildren());
    }

    private Iterator getChildren(Iterator childIter) {
        ArrayList<Node> childElements = new ArrayList<Node>();
        while (childIter.hasNext()) {
            org.w3c.dom.Node domNode = (org.w3c.dom.Node)childIter.next();
            Node saajNode = this.toSAAJNode(domNode);
            if (saajNode instanceof Text) {
                childElements.add(saajNode);
                continue;
            }
            if (!(saajNode instanceof SOAPHeaderElement)) {
                SOAPHeaderElementImpl headerEle = new SOAPHeaderElementImpl((SOAPHeaderBlock)domNode);
                domNode.setUserData("saaj.node", headerEle, null);
                childElements.add(headerEle);
                continue;
            }
            childElements.add(saajNode);
        }
        return childElements.iterator();
    }

    @Override
    public void detachNode() {
        this.detach();
    }

    @Override
    public OMNode detach() {
        OMNode omNode = ((SOAPHeader)this.omTarget).detach();
        this.parentElement = null;
        return omNode;
    }
}

