/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.stream;

import java.nio.channels.ClosedChannelException;
import java.util.Queue;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.stream.ChunkedInput;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.internal.QueueFactory;

public class ChunkedWriteHandler
implements ChannelUpstreamHandler,
ChannelDownstreamHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChunkedWriteHandler.class);
    private final Queue<MessageEvent> queue = QueueFactory.createQueue(MessageEvent.class);
    private ChannelHandlerContext ctx;
    private MessageEvent currentEvent;

    public void resumeTransfer() {
        block3: {
            ChannelHandlerContext ctx = this.ctx;
            if (ctx == null) {
                return;
            }
            try {
                this.flush(ctx, false);
            }
            catch (Exception e) {
                if (!logger.isWarnEnabled()) break block3;
                logger.warn("Unexpected exception while sending chunks.", e);
            }
        }
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (!(e instanceof MessageEvent)) {
            ctx.sendDownstream(e);
            return;
        }
        boolean offered = this.queue.offer((MessageEvent)e);
        assert (offered);
        Channel channel = ctx.getChannel();
        if (channel.isWritable()) {
            this.ctx = ctx;
            this.flush(ctx, false);
        } else if (!channel.isConnected()) {
            this.ctx = ctx;
            this.discard(ctx, false);
        }
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent cse = (ChannelStateEvent)e;
            switch (cse.getState()) {
                case INTEREST_OPS: {
                    this.flush(ctx, true);
                    break;
                }
                case OPEN: {
                    if (Boolean.TRUE.equals(cse.getValue())) break;
                    this.flush(ctx, true);
                }
            }
        }
        ctx.sendUpstream(e);
    }

    private void discard(ChannelHandlerContext ctx, boolean fireNow) {
        ClosedChannelException cause = null;
        boolean fireExceptionCaught = false;
        while (true) {
            MessageEvent currentEvent = this.currentEvent;
            if (this.currentEvent == null) {
                currentEvent = this.queue.poll();
            } else {
                this.currentEvent = null;
            }
            if (currentEvent == null) break;
            Object m = currentEvent.getMessage();
            if (m instanceof ChunkedInput) {
                ChunkedWriteHandler.closeInput((ChunkedInput)m);
            }
            if (cause == null) {
                cause = new ClosedChannelException();
            }
            currentEvent.getFuture().setFailure(cause);
            fireExceptionCaught = true;
            currentEvent = null;
        }
        if (fireExceptionCaught) {
            Channels.fireExceptionCaught(ctx.getChannel(), cause);
        }
    }

    private synchronized void flush(ChannelHandlerContext ctx, boolean fireNow) throws Exception {
        Channel channel = ctx.getChannel();
        if (!channel.isConnected()) {
            this.discard(ctx, fireNow);
        }
        while (channel.isWritable()) {
            if (this.currentEvent == null) {
                this.currentEvent = this.queue.poll();
            }
            if (this.currentEvent == null) break;
            if (this.currentEvent.getFuture().isDone()) {
                this.currentEvent = null;
            } else {
                final MessageEvent currentEvent = this.currentEvent;
                Object m = currentEvent.getMessage();
                if (m instanceof ChunkedInput) {
                    ChannelFuture writeFuture;
                    boolean suspend;
                    boolean endOfInput;
                    Object chunk;
                    ChunkedInput chunks = (ChunkedInput)m;
                    try {
                        chunk = chunks.nextChunk();
                        endOfInput = chunks.isEndOfInput();
                        if (chunk == null) {
                            chunk = ChannelBuffers.EMPTY_BUFFER;
                            suspend = !endOfInput;
                        } else {
                            suspend = false;
                        }
                    }
                    catch (Throwable t) {
                        this.currentEvent = null;
                        currentEvent.getFuture().setFailure(t);
                        if (fireNow) {
                            Channels.fireExceptionCaught(ctx, t);
                        } else {
                            Channels.fireExceptionCaughtLater(ctx, t);
                        }
                        ChunkedWriteHandler.closeInput(chunks);
                        break;
                    }
                    if (suspend) break;
                    if (endOfInput) {
                        this.currentEvent = null;
                        ChunkedWriteHandler.closeInput(chunks);
                        writeFuture = currentEvent.getFuture();
                    } else {
                        writeFuture = Channels.future(channel);
                        writeFuture.addListener(new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture future) throws Exception {
                                if (!future.isSuccess()) {
                                    currentEvent.getFuture().setFailure(future.getCause());
                                    ChunkedWriteHandler.closeInput((ChunkedInput)currentEvent.getMessage());
                                }
                            }
                        });
                    }
                    Channels.write(ctx, writeFuture, chunk, currentEvent.getRemoteAddress());
                } else {
                    this.currentEvent = null;
                    ctx.sendDownstream(currentEvent);
                }
            }
            if (channel.isConnected()) continue;
            this.discard(ctx, fireNow);
            break;
        }
    }

    static void closeInput(ChunkedInput chunks) {
        block2: {
            try {
                chunks.close();
            }
            catch (Throwable t) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("Failed to close a chunked input.", t);
            }
        }
    }
}

