/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.DatagramChannel;
import org.jboss.netty.channel.socket.nio.AbstractNioChannel;
import org.jboss.netty.channel.socket.nio.DefaultNioDatagramChannelConfig;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelConfig;
import org.jboss.netty.channel.socket.nio.NioDatagramWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioDatagramChannel
extends AbstractNioChannel<java.nio.channels.DatagramChannel>
implements DatagramChannel {
    private final NioDatagramChannelConfig config;

    NioDatagramChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, NioDatagramWorker worker) {
        super(null, factory, pipeline, sink, worker, NioDatagramChannel.openNonBlockingChannel());
        this.config = new DefaultNioDatagramChannelConfig(((java.nio.channels.DatagramChannel)this.channel).socket());
        Channels.fireChannelOpen(this);
    }

    private static java.nio.channels.DatagramChannel openNonBlockingChannel() {
        try {
            java.nio.channels.DatagramChannel channel = java.nio.channels.DatagramChannel.open();
            channel.configureBlocking(false);
            return channel;
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a DatagramChannel.", e);
        }
    }

    @Override
    public NioDatagramWorker getWorker() {
        return (NioDatagramWorker)super.getWorker();
    }

    @Override
    public boolean isBound() {
        return this.isOpen() && ((java.nio.channels.DatagramChannel)this.channel).socket().isBound();
    }

    @Override
    public boolean isConnected() {
        return ((java.nio.channels.DatagramChannel)this.channel).isConnected();
    }

    @Override
    protected boolean setClosed() {
        return super.setClosed();
    }

    @Override
    public NioDatagramChannelConfig getConfig() {
        return this.config;
    }

    java.nio.channels.DatagramChannel getDatagramChannel() {
        return (java.nio.channels.DatagramChannel)this.channel;
    }

    @Override
    public void joinGroup(InetAddress multicastAddress) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void leaveGroup(InetAddress multicastAddress) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        throw new UnsupportedOperationException();
    }

    @Override
    InetSocketAddress getLocalSocketAddress() throws Exception {
        return (InetSocketAddress)((java.nio.channels.DatagramChannel)this.channel).socket().getLocalSocketAddress();
    }

    @Override
    InetSocketAddress getRemoteSocketAddress() throws Exception {
        return (InetSocketAddress)((java.nio.channels.DatagramChannel)this.channel).socket().getRemoteSocketAddress();
    }

    @Override
    public ChannelFuture write(Object message, SocketAddress remoteAddress) {
        if (remoteAddress == null || remoteAddress.equals(this.getRemoteAddress())) {
            return super.write(message, null);
        }
        return super.write(message, remoteAddress);
    }
}

