/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.util.NativeCodeLoader;

public class JniBasedUnixGroupsMapping
implements GroupMappingServiceProvider {
    private static final Log LOG = LogFactory.getLog(JniBasedUnixGroupsMapping.class);

    native String[] getGroupForUser(String var1);

    @Override
    public List<String> getGroups(String user) throws IOException {
        String[] groups = null;
        try {
            groups = this.getGroupForUser(user);
        }
        catch (Exception e) {
            LOG.warn("Got exception while trying to obtain the groups for user " + user);
        }
        if (groups != null && groups.length != 0) {
            return Arrays.asList(groups);
        }
        return Arrays.asList(new String[0]);
    }

    @Override
    public void cacheGroupsRefresh() throws IOException {
    }

    @Override
    public void cacheGroupsAdd(List<String> groups) throws IOException {
    }

    static {
        if (!NativeCodeLoader.isNativeCodeLoaded()) {
            LOG.info("Bailing out since native library couldn't be loaded");
            throw new RuntimeException();
        }
        LOG.info("Using JniBasedUnixGroupsMapping for Group resolution");
    }
}

