/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.avro.Protocol;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.ipc.HandshakeRequest;
import org.apache.avro.ipc.HandshakeResponse;
import org.apache.avro.ipc.Ipc;
import org.apache.avro.ipc.MD5;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.tool.Tool;
import org.apache.avro.util.ByteBufferInputStream;
import org.apache.avro.util.ByteBufferOutputStream;

public class RpcProtocolTool
implements Tool {
    @Override
    public String getName() {
        return "rpcprotocol";
    }

    @Override
    public String getShortDescription() {
        return "Output the protocol of a RPC service";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        if (args.size() != 1) {
            err.println("Usage: uri");
            return 1;
        }
        URI uri = URI.create(args.get(0));
        Transceiver transceiver = null;
        try {
            transceiver = Ipc.createTransceiver(uri);
            HandshakeRequest rq = HandshakeRequest.newBuilder().setClientHash(new MD5(new byte[16])).setServerHash(new MD5(new byte[16])).setClientProtocol(null).setMeta(new LinkedHashMap<String, ByteBuffer>()).build();
            SpecificDatumWriter<HandshakeRequest> handshakeWriter = new SpecificDatumWriter<HandshakeRequest>(HandshakeRequest.class);
            ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream();
            BinaryEncoder encoder = EncoderFactory.get().binaryEncoder(byteBufferOutputStream, null);
            handshakeWriter.write(rq, encoder);
            encoder.flush();
            List<ByteBuffer> response = transceiver.transceive(byteBufferOutputStream.getBufferList());
            ByteBufferInputStream byteBufferInputStream = new ByteBufferInputStream(response);
            SpecificDatumReader<HandshakeResponse> handshakeReader = new SpecificDatumReader<HandshakeResponse>(HandshakeResponse.class);
            HandshakeResponse handshakeResponse = handshakeReader.read(null, DecoderFactory.get().binaryDecoder(byteBufferInputStream, null));
            Protocol p = Protocol.parse(handshakeResponse.getServerProtocol());
            out.println(p.toString(true));
        }
        finally {
            if (transceiver != null) {
                transceiver.close();
            }
        }
        return 0;
    }
}

