/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.tool.Tool;
import org.apache.avro.tool.Util;

public class DataFileGetMetaTool
implements Tool {
    @Override
    public String getName() {
        return "getmeta";
    }

    @Override
    public String getShortDescription() {
        return "Prints out the metadata of an Avro data file.";
    }

    @Override
    public int run(InputStream stdin, PrintStream out, PrintStream err, List<String> args) throws Exception {
        OptionParser p = new OptionParser();
        ArgumentAcceptingOptionSpec<String> keyOption = p.accepts("key", "Metadata key").withOptionalArg().ofType(String.class);
        OptionSet opts = p.parse(args.toArray(new String[0]));
        String keyName = (String)keyOption.value(opts);
        List<String> nargs = opts.nonOptionArguments();
        if (nargs.size() != 1) {
            err.println("Expected 1 arg: input_file");
            p.printHelpOn(err);
            return 1;
        }
        FsInput in = Util.openSeekableFromFS(args.get(0));
        DataFileReader reader = new DataFileReader(in, new GenericDatumReader());
        if (keyName != null) {
            byte[] value = reader.getMeta(keyName);
            if (value != null) {
                out.write(value, 0, value.length);
                out.println();
            }
        } else {
            List<String> keys = reader.getMetaKeys();
            for (String key : keys) {
                out.print(DataFileGetMetaTool.escapeKey(key));
                out.print('\t');
                byte[] value = reader.getMeta(key);
                out.write(value, 0, value.length);
                out.println();
            }
        }
        return 0;
    }

    static String escapeKey(String key) {
        key = key.replace("\\", "\\\\");
        key = key.replace("\t", "\\t");
        key = key.replace("\n", "\\n");
        key = key.replace("\r", "\\r");
        return key;
    }
}

