/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro;

import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.avro.ipc.HttpServer;
import org.apache.avro.ipc.HttpTransceiver;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.Server;
import org.apache.avro.ipc.Transceiver;
import org.apache.avro.ipc.specific.SpecificRequestor;
import org.apache.avro.ipc.specific.SpecificResponder;
import org.apache.avro.test.BulkData;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBulkData {
    private static final long COUNT = Integer.parseInt(System.getProperty("test.count", "10"));
    private static final int SIZE = Integer.parseInt(System.getProperty("test.size", "65536"));
    private static final ByteBuffer DATA = ByteBuffer.allocate(SIZE);
    private static Server server;
    private static Transceiver client;
    private static BulkData proxy;

    public TestBulkData() {
        Random rand = new Random();
        DATA.limit(DATA.capacity());
        DATA.position(0);
        rand.nextBytes(DATA.array());
    }

    @Before
    public void startServer() throws Exception {
        if (server != null) {
            return;
        }
        server = new HttpServer((Responder)new SpecificResponder(BulkData.class, (Object)new BulkDataImpl()), 0);
        server.start();
        client = new HttpTransceiver(new URL("http://127.0.0.1:" + server.getPort() + "/"));
        proxy = SpecificRequestor.getClient(BulkData.class, client);
    }

    @Test
    public void testRead() throws IOException {
        int i = 0;
        while ((long)i < COUNT) {
            Assert.assertEquals((long)SIZE, (long)proxy.read().remaining());
            ++i;
        }
    }

    @Test
    public void testWrite() throws IOException {
        int i = 0;
        while ((long)i < COUNT) {
            proxy.write(DATA.duplicate());
            ++i;
        }
    }

    @AfterClass
    public static void stopServer() throws Exception {
        server.close();
    }

    public static void main(String[] args) throws Exception {
        TestBulkData test = new TestBulkData();
        test.startServer();
        System.out.println("READ");
        long start = System.currentTimeMillis();
        test.testRead();
        TestBulkData.printStats(start);
        System.out.println("WRITE");
        start = System.currentTimeMillis();
        test.testWrite();
        TestBulkData.printStats(start);
        test.stopServer();
    }

    private static void printStats(long start) {
        double seconds = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.println("seconds = " + (int)seconds);
        System.out.println("requests/second = " + (int)((double)COUNT / seconds));
        double megabytes = (double)(COUNT * (long)SIZE) / 1048576.0;
        System.out.println("MB = " + (int)megabytes);
        System.out.println("MB/second = " + (int)(megabytes / seconds));
    }

    public static class BulkDataImpl
    implements BulkData {
        @Override
        public ByteBuffer read() {
            return DATA.duplicate();
        }

        @Override
        public Void write(ByteBuffer data) {
            Assert.assertEquals((long)SIZE, (long)data.remaining());
            return null;
        }
    }
}

