/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.junit;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.junit.EmbeddedActiveMQBroker;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractActiveMQClientResource
extends ExternalResource {
    Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    ActiveMQConnectionFactory connectionFactory;
    Connection connection;
    Session session;
    ActiveMQDestination destination;

    public AbstractActiveMQClientResource(ActiveMQConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public AbstractActiveMQClientResource(URI brokerURI) {
        this(new ActiveMQConnectionFactory(brokerURI));
    }

    public AbstractActiveMQClientResource(EmbeddedActiveMQBroker embeddedActiveMQBroker) {
        this(embeddedActiveMQBroker.createConnectionFactory());
    }

    public AbstractActiveMQClientResource(URI brokerURI, String userName, String password) {
        this(new ActiveMQConnectionFactory(userName, password, brokerURI));
    }

    public AbstractActiveMQClientResource(String destinationName, ActiveMQConnectionFactory connectionFactory) {
        this(connectionFactory);
        this.destination = this.createDestination(destinationName);
    }

    public AbstractActiveMQClientResource(String destinationName, URI brokerURI) {
        this(destinationName, new ActiveMQConnectionFactory(brokerURI));
    }

    public AbstractActiveMQClientResource(String destinationName, EmbeddedActiveMQBroker embeddedActiveMQBroker) {
        this(destinationName, embeddedActiveMQBroker.createConnectionFactory());
    }

    public AbstractActiveMQClientResource(String destinationName, URI brokerURI, String userName, String password) {
        this(destinationName, new ActiveMQConnectionFactory(userName, password, brokerURI));
    }

    public static void setMessageProperties(Message message, Map<String, Object> properties) throws JMSException {
        if (properties != null) {
            for (Map.Entry<String, Object> property : properties.entrySet()) {
                message.setObjectProperty(property.getKey(), property.getValue());
            }
        }
    }

    public String getClientId() {
        return null;
    }

    public String getDestinationName() {
        return this.destination != null ? this.destination.toString() : null;
    }

    public abstract byte getDestinationType();

    protected abstract void createClient() throws JMSException;

    protected void before() throws Throwable {
        this.log.info("Starting {}: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.connectionFactory.getBrokerURL());
        this.start();
        super.before();
    }

    protected void after() {
        this.log.info("Stopping {}: {}", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)this.connectionFactory.getBrokerURL());
        super.after();
        this.stop();
    }

    public void start() {
        try {
            try {
                this.connection = this.connectionFactory.createConnection();
                String clientId = this.getClientId();
                if (clientId != null) {
                    this.connection.setClientID(clientId);
                }
                this.session = this.connection.createSession(false, 1);
                this.createClient();
            }
            catch (JMSException jmsEx) {
                throw new RuntimeException("Producer initialization failed" + ((Object)((Object)this)).getClass().getSimpleName(), jmsEx);
            }
            this.connection.start();
        }
        catch (JMSException jmsEx) {
            throw new IllegalStateException("Producer failed to start", jmsEx);
        }
        this.log.info("Ready to produce messages to {}", (Object)this.connectionFactory.getBrokerURL());
    }

    public void stop() {
        try {
            this.connection.close();
        }
        catch (JMSException jmsEx) {
            this.log.warn("Exception encountered closing JMS Connection", (Throwable)jmsEx);
        }
    }

    public String getBrokerURL() {
        return this.connectionFactory.getBrokerURL();
    }

    protected ActiveMQDestination createDestination(String destinationName) {
        if (destinationName != null) {
            return ActiveMQDestination.createDestination((String)destinationName, (byte)this.getDestinationType());
        }
        return null;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.session.createBytesMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.session.createTextMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.session.createMapMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.session.createObjectMessage();
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.session.createStreamMessage();
    }

    public BytesMessage createMessage(byte[] body) throws JMSException {
        return this.createMessage(body, null);
    }

    public TextMessage createMessage(String body) throws JMSException {
        return this.createMessage(body, null);
    }

    public MapMessage createMessage(Map<String, Object> body) throws JMSException {
        return this.createMessage(body, null);
    }

    public ObjectMessage createMessage(Serializable body) throws JMSException {
        return this.createMessage(body, null);
    }

    public BytesMessage createMessage(byte[] body, Map<String, Object> properties) throws JMSException {
        BytesMessage message = this.createBytesMessage();
        if (body != null) {
            message.writeBytes(body);
        }
        AbstractActiveMQClientResource.setMessageProperties((Message)message, properties);
        return message;
    }

    public TextMessage createMessage(String body, Map<String, Object> properties) throws JMSException {
        TextMessage message = this.createTextMessage();
        if (body != null) {
            message.setText(body);
        }
        AbstractActiveMQClientResource.setMessageProperties((Message)message, properties);
        return message;
    }

    public MapMessage createMessage(Map<String, Object> body, Map<String, Object> properties) throws JMSException {
        MapMessage message = this.createMapMessage();
        if (body != null) {
            for (Map.Entry<String, Object> entry : body.entrySet()) {
                message.setObject(entry.getKey(), entry.getValue());
            }
        }
        AbstractActiveMQClientResource.setMessageProperties((Message)message, properties);
        return message;
    }

    public ObjectMessage createMessage(Serializable body, Map<String, Object> properties) throws JMSException {
        ObjectMessage message = this.createObjectMessage();
        if (body != null) {
            message.setObject(body);
        }
        AbstractActiveMQClientResource.setMessageProperties((Message)message, properties);
        return message;
    }
}

