/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.apache.activemq.artemis.rest.HttpHeaderProperty;
import org.apache.activemq.artemis.rest.UnknownMediaType;
import org.apache.activemq.artemis.rest.UnmarshalException;
import org.jboss.resteasy.core.Headers;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.GenericType;

public class Jms {
    public static void setHttpHeader(Message message, String name, String value) {
        try {
            message.setStringProperty(HttpHeaderProperty.toPropertyName(name), value);
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getHttpHeader(Message message, String name) {
        try {
            return message.getStringProperty(HttpHeaderProperty.toPropertyName(name));
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getEntity(Message message, Class<T> type) {
        return Jms.getEntity(message, type, null, ResteasyProviderFactory.getInstance());
    }

    public static <T> T getEntity(Message message, Class<T> type, ResteasyProviderFactory factory) {
        return Jms.getEntity(message, type, null, factory);
    }

    public static <T> T getEntity(Message message, GenericType<T> type, ResteasyProviderFactory factory) throws UnknownMediaType {
        return Jms.getEntity(message, type.getType(), type.getGenericType(), factory);
    }

    public static boolean isHttpMessage(Message message) {
        try {
            return message.getBooleanProperty("postedAsHttpMessage");
        }
        catch (JMSException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T getEntity(Message message, Class<T> type, Type genericType, ResteasyProviderFactory factory) throws UnknownMediaType {
        if (!Jms.isHttpMessage(message)) {
            try {
                return (T)((ObjectMessage)message).getObject();
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        }
        BytesMessage bytesMessage = (BytesMessage)message;
        try {
            long size = bytesMessage.getBodyLength();
            if (size <= 0L) {
                return null;
            }
            byte[] body = new byte[(int)size];
            bytesMessage.readBytes(body);
            String contentType = message.getStringProperty("http_content$type");
            if (contentType == null) {
                throw new UnknownMediaType("Message did not have a Content-Type header cannot extract entity");
            }
            MediaType ct = MediaType.valueOf((String)contentType);
            MessageBodyReader reader = factory.getMessageBodyReader(type, genericType, null, ct);
            if (reader == null) {
                throw new UnmarshalException("Unable to find a JAX-RS reader for type " + type.getName() + " and media type " + contentType);
            }
            Providers current = (Providers)ResteasyProviderFactory.getContextData(Providers.class);
            ResteasyProviderFactory.pushContext(Providers.class, (Object)factory);
            try {
                Object object = reader.readFrom(type, genericType, null, ct, (MultivaluedMap)new Headers(), (InputStream)new ByteArrayInputStream(body));
                return (T)object;
            }
            finally {
                ResteasyProviderFactory.popContextData(Providers.class);
                if (current != null) {
                    ResteasyProviderFactory.pushContext(Providers.class, (Object)current);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

