/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire;

import com.google.common.io.BaseEncoding;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQConsumer;
import org.apache.activemq.artemis.core.protocol.openwire.util.OpenWireUtil;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMapMessage;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.command.ActiveMQStreamMessage;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.util.ByteArrayInputStream;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.ByteSequenceData;
import org.apache.activemq.util.MarshallingSupport;
import org.apache.activemq.wireformat.WireFormat;
import org.fusesource.hawtbuf.UTF8Buffer;

public final class OpenWireMessageConverter {
    private static final SimpleString JMS_TYPE_PROPERTY = new SimpleString("JMSType");
    private static final SimpleString JMS_CORRELATION_ID_PROPERTY = new SimpleString("JMSCorrelationID");
    private static final SimpleString AMQ_PREFIX = new SimpleString("__HDR_");
    public static final SimpleString AMQ_MSG_DLQ_DELIVERY_FAILURE_CAUSE_PROPERTY = new SimpleString(AMQ_PREFIX + "dlqDeliveryFailureCause");
    private static final SimpleString AMQ_MSG_ARRIVAL = new SimpleString(AMQ_PREFIX + "ARRIVAL");
    private static final SimpleString AMQ_MSG_BROKER_IN_TIME = new SimpleString(AMQ_PREFIX + "BROKER_IN_TIME");
    private static final SimpleString AMQ_MSG_BROKER_PATH = new SimpleString(AMQ_PREFIX + "BROKER_PATH");
    private static final SimpleString AMQ_MSG_CLUSTER = new SimpleString(AMQ_PREFIX + "CLUSTER");
    private static final SimpleString AMQ_MSG_COMMAND_ID = new SimpleString(AMQ_PREFIX + "COMMAND_ID");
    private static final SimpleString AMQ_MSG_DATASTRUCTURE = new SimpleString(AMQ_PREFIX + "DATASTRUCTURE");
    private static final SimpleString AMQ_MSG_MESSAGE_ID = new SimpleString(AMQ_PREFIX + "MESSAGE_ID");
    private static final SimpleString AMQ_MSG_ORIG_DESTINATION = new SimpleString(AMQ_PREFIX + "ORIG_DESTINATION");
    private static final SimpleString AMQ_MSG_ORIG_TXID = new SimpleString(AMQ_PREFIX + "ORIG_TXID");
    private static final SimpleString AMQ_MSG_PRODUCER_ID = new SimpleString(AMQ_PREFIX + "PRODUCER_ID");
    private static final SimpleString AMQ_MSG_MARSHALL_PROP = new SimpleString(AMQ_PREFIX + "MARSHALL_PROP");
    private static final SimpleString AMQ_MSG_REPLY_TO = new SimpleString(AMQ_PREFIX + "REPLY_TO");
    private static final SimpleString AMQ_MSG_USER_ID = new SimpleString(AMQ_PREFIX + "USER_ID");
    private static final SimpleString AMQ_MSG_DROPPABLE = new SimpleString(AMQ_PREFIX + "DROPPABLE");
    private static final SimpleString AMQ_MSG_COMPRESSED = new SimpleString(AMQ_PREFIX + "COMPRESSED");

    public static Message inbound(org.apache.activemq.command.Message messageSend, WireFormat marshaller, CoreMessageObjectPools coreMessageObjectPools) throws Exception {
        String userId;
        ActiveMQDestination replyTo;
        ByteSequence propBytes;
        String groupId;
        DataStructure ds;
        BrokerId[] cluster;
        CoreMessage coreMessage = new CoreMessage(-1L, messageSend.getSize(), coreMessageObjectPools);
        String type = messageSend.getType();
        if (type != null) {
            coreMessage.putStringProperty(JMS_TYPE_PROPERTY, new SimpleString(type));
        }
        coreMessage.setDurable(messageSend.isPersistent());
        coreMessage.setExpiration(messageSend.getExpiration());
        coreMessage.setPriority(messageSend.getPriority());
        coreMessage.setTimestamp(messageSend.getTimestamp());
        byte coreType = OpenWireMessageConverter.toCoreType(messageSend.getDataStructureType());
        coreMessage.setType(coreType);
        ActiveMQBuffer body = coreMessage.getBodyBuffer();
        ByteSequence contents = messageSend.getContent();
        if (contents == null && coreType == 3) {
            body.writeNullableString(null);
        } else if (contents != null) {
            boolean messageCompressed = messageSend.isCompressed();
            if (messageCompressed) {
                coreMessage.putBooleanProperty(AMQ_MSG_COMPRESSED, true);
            }
            switch (coreType) {
                case 3: {
                    OpenWireMessageConverter.writeTextType(contents, messageCompressed, body);
                    break;
                }
                case 5: {
                    OpenWireMessageConverter.writeMapType(contents, messageCompressed, body);
                    break;
                }
                case 2: {
                    OpenWireMessageConverter.writeObjectType(contents, messageCompressed, body);
                    break;
                }
                case 6: {
                    OpenWireMessageConverter.writeStreamType(contents, messageCompressed, body);
                    break;
                }
                case 4: {
                    OpenWireMessageConverter.writeBytesType(contents, messageCompressed, body);
                    break;
                }
                default: {
                    OpenWireMessageConverter.writeDefaultType(contents, messageCompressed, body);
                }
            }
        }
        coreMessage.putLongProperty(AMQ_MSG_ARRIVAL, messageSend.getArrival());
        coreMessage.putLongProperty(AMQ_MSG_BROKER_IN_TIME, messageSend.getBrokerInTime());
        BrokerId[] brokers = messageSend.getBrokerPath();
        if (brokers != null) {
            OpenWireMessageConverter.putMsgBrokerPath(brokers, coreMessage);
        }
        if ((cluster = messageSend.getCluster()) != null) {
            OpenWireMessageConverter.putMsgCluster(cluster, coreMessage);
        }
        coreMessage.putIntProperty(AMQ_MSG_COMMAND_ID, messageSend.getCommandId());
        String corrId = messageSend.getCorrelationId();
        if (corrId != null) {
            coreMessage.putStringProperty(JMS_CORRELATION_ID_PROPERTY, new SimpleString(corrId));
        }
        if ((ds = messageSend.getDataStructure()) != null) {
            OpenWireMessageConverter.putMsgDataStructure(ds, marshaller, coreMessage);
        }
        if ((groupId = messageSend.getGroupID()) != null) {
            coreMessage.setGroupID(groupId);
        }
        coreMessage.setGroupSequence(messageSend.getGroupSequence());
        MessageId messageId = messageSend.getMessageId();
        ByteSequence midBytes = marshaller.marshal((Object)messageId);
        midBytes.compact();
        coreMessage.putBytesProperty(AMQ_MSG_MESSAGE_ID, midBytes.data);
        coreMessage.setUserID(UUIDGenerator.getInstance().generateUUID());
        ProducerId producerId = messageSend.getProducerId();
        if (producerId != null) {
            ByteSequence producerIdBytes = marshaller.marshal((Object)producerId);
            producerIdBytes.compact();
            coreMessage.putBytesProperty(AMQ_MSG_PRODUCER_ID, producerIdBytes.data);
        }
        if ((propBytes = messageSend.getMarshalledProperties()) != null) {
            OpenWireMessageConverter.putMsgMarshalledProperties(propBytes, messageSend, coreMessage);
        }
        if ((replyTo = messageSend.getReplyTo()) != null) {
            if (replyTo instanceof TemporaryQueue) {
                MessageUtil.setJMSReplyTo((Message)coreMessage, (String)("temp-queue://" + ((TemporaryQueue)replyTo).getQueueName()));
            } else if (replyTo instanceof TemporaryTopic) {
                MessageUtil.setJMSReplyTo((Message)coreMessage, (String)("temp-topic://" + ((TemporaryTopic)replyTo).getTopicName()));
            } else if (replyTo instanceof Queue) {
                MessageUtil.setJMSReplyTo((Message)coreMessage, (String)("queue://" + ((Queue)replyTo).getQueueName()));
            } else if (replyTo instanceof Topic) {
                MessageUtil.setJMSReplyTo((Message)coreMessage, (String)("topic://" + ((Topic)replyTo).getTopicName()));
            } else {
                MessageUtil.setJMSReplyTo((Message)coreMessage, (String)("queue://" + ((Queue)replyTo).getQueueName()));
            }
        }
        if ((userId = messageSend.getUserID()) != null) {
            coreMessage.putStringProperty(AMQ_MSG_USER_ID, new SimpleString(userId));
        }
        coreMessage.putBooleanProperty(AMQ_MSG_DROPPABLE, messageSend.isDroppable());
        ActiveMQDestination origDest = messageSend.getOriginalDestination();
        if (origDest != null) {
            OpenWireMessageConverter.putMsgOriginalDestination(origDest, marshaller, coreMessage);
        }
        return coreMessage;
    }

    private static void writeTextType(ByteSequence contents, boolean messageCompressed, ActiveMQBuffer body) throws IOException {
        Object tis = new ByteArrayInputStream(contents);
        if (messageCompressed) {
            tis = new InflaterInputStream((InputStream)tis);
        }
        DataInputStream tdataIn = new DataInputStream((InputStream)tis);
        String text = MarshallingSupport.readUTF8((DataInput)tdataIn);
        tdataIn.close();
        body.writeNullableSimpleString(new SimpleString(text));
    }

    private static void writeMapType(ByteSequence contents, boolean messageCompressed, ActiveMQBuffer body) throws IOException {
        Object mis = new ByteArrayInputStream(contents);
        if (messageCompressed) {
            mis = new InflaterInputStream((InputStream)mis);
        }
        DataInputStream mdataIn = new DataInputStream((InputStream)mis);
        Map map = MarshallingSupport.unmarshalPrimitiveMap((DataInputStream)mdataIn);
        mdataIn.close();
        TypedProperties props = new TypedProperties();
        OpenWireMessageConverter.loadMapIntoProperties(props, map);
        props.encode(body.byteBuf());
    }

    private static void writeObjectType(ByteSequence contents, boolean messageCompressed, ActiveMQBuffer body) throws IOException {
        if (messageCompressed) {
            contents = OpenWireMessageConverter.writeCompressedObjectType(contents);
        }
        body.writeInt(contents.length);
        body.writeBytes(contents.data, contents.offset, contents.length);
    }

    /*
     * Exception decompiling
     */
    private static ByteSequence writeCompressedObjectType(ByteSequence contents) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void writeStreamType(ByteSequence contents, boolean messageCompressed, ActiveMQBuffer body) throws IOException {
        Object sis = new ByteArrayInputStream(contents);
        if (messageCompressed) {
            sis = new InflaterInputStream((InputStream)sis);
        }
        DataInputStream sdis = new DataInputStream((InputStream)sis);
        int stype = sdis.read();
        while (stype != -1) {
            switch (stype) {
                case 1: {
                    body.writeByte((byte)2);
                    body.writeBoolean(sdis.readBoolean());
                    break;
                }
                case 2: {
                    body.writeByte((byte)3);
                    body.writeByte(sdis.readByte());
                    break;
                }
                case 10: {
                    body.writeByte((byte)4);
                    int slen = sdis.readInt();
                    byte[] sbytes = new byte[slen];
                    sdis.read(sbytes);
                    body.writeInt(slen);
                    body.writeBytes(sbytes);
                    break;
                }
                case 3: {
                    body.writeByte((byte)11);
                    char schar = sdis.readChar();
                    body.writeShort((short)schar);
                    break;
                }
                case 7: {
                    body.writeByte((byte)9);
                    double sdouble = sdis.readDouble();
                    body.writeLong(Double.doubleToLongBits(sdouble));
                    break;
                }
                case 8: {
                    body.writeByte((byte)8);
                    float sfloat = sdis.readFloat();
                    body.writeInt(Float.floatToIntBits(sfloat));
                    break;
                }
                case 5: {
                    body.writeByte((byte)6);
                    body.writeInt(sdis.readInt());
                    break;
                }
                case 6: {
                    body.writeByte((byte)7);
                    body.writeLong(sdis.readLong());
                    break;
                }
                case 4: {
                    body.writeByte((byte)5);
                    body.writeShort(sdis.readShort());
                    break;
                }
                case 9: {
                    body.writeByte((byte)10);
                    String sstring = sdis.readUTF();
                    body.writeNullableString(sstring);
                    break;
                }
                case 13: {
                    body.writeByte((byte)10);
                    String sbigString = MarshallingSupport.readUTF8((DataInput)sdis);
                    body.writeNullableString(sbigString);
                    break;
                }
                case 0: {
                    body.writeByte((byte)10);
                    body.writeNullableString(null);
                    break;
                }
            }
            stype = sdis.read();
        }
        sdis.close();
    }

    private static void writeBytesType(ByteSequence contents, boolean messageCompressed, ActiveMQBuffer body) throws IOException {
        if (messageCompressed) {
            contents = OpenWireMessageConverter.writeCompressedBytesType(contents);
        }
        body.writeBytes(contents.data, contents.offset, contents.length);
    }

    /*
     * Exception decompiling
     */
    private static ByteSequence writeCompressedBytesType(ByteSequence contents) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void writeDefaultType(ByteSequence contents, boolean messageCompressed, ActiveMQBuffer body) throws IOException {
        if (messageCompressed) {
            contents = OpenWireMessageConverter.writeCompressedDefaultType(contents);
        }
        body.writeBytes(contents.data, contents.offset, contents.length);
    }

    /*
     * Exception decompiling
     */
    private static ByteSequence writeCompressedDefaultType(ByteSequence contents) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void putMsgBrokerPath(BrokerId[] brokers, CoreMessage coreMessage) {
        StringBuilder builder = new StringBuilder();
        int size = brokers.length;
        for (int i = 0; i < size; ++i) {
            builder.append(brokers[i].getValue());
            if (i == size - 1) continue;
            builder.append(',');
        }
        coreMessage.putStringProperty(AMQ_MSG_BROKER_PATH, new SimpleString(builder.toString()));
    }

    private static void putMsgCluster(BrokerId[] cluster, CoreMessage coreMessage) {
        StringBuilder builder = new StringBuilder();
        int size = cluster.length;
        for (int i = 0; i < size; ++i) {
            builder.append(cluster[i].getValue());
            if (i == size - 1) continue;
            builder.append(',');
        }
        coreMessage.putStringProperty(AMQ_MSG_CLUSTER, new SimpleString(builder.toString()));
    }

    private static void putMsgDataStructure(DataStructure ds, WireFormat marshaller, CoreMessage coreMessage) throws IOException {
        ByteSequence dsBytes = marshaller.marshal((Object)ds);
        dsBytes.compact();
        coreMessage.putBytesProperty(AMQ_MSG_DATASTRUCTURE, dsBytes.data);
    }

    private static void putMsgMarshalledProperties(ByteSequence propBytes, org.apache.activemq.command.Message messageSend, CoreMessage coreMessage) throws IOException {
        propBytes.compact();
        coreMessage.putBytesProperty(AMQ_MSG_MARSHALL_PROP, propBytes.data);
        Map props = messageSend.getProperties();
        if (!props.isEmpty()) {
            props.forEach((key, value) -> {
                try {
                    coreMessage.putObjectProperty(key, value);
                }
                catch (ActiveMQPropertyConversionException e) {
                    coreMessage.putStringProperty(key, value.toString());
                }
            });
        }
    }

    private static void putMsgOriginalDestination(ActiveMQDestination origDest, WireFormat marshaller, CoreMessage coreMessage) throws IOException {
        ByteSequence origDestBytes = marshaller.marshal((Object)origDest);
        origDestBytes.compact();
        coreMessage.putBytesProperty(AMQ_MSG_ORIG_DESTINATION, origDestBytes.data);
    }

    private static void loadMapIntoProperties(TypedProperties props, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            SimpleString key = new SimpleString(entry.getKey());
            Object value = entry.getValue();
            if (value instanceof UTF8Buffer) {
                value = value.toString();
            }
            TypedProperties.setObjectProperty((SimpleString)key, (Object)value, (TypedProperties)props);
        }
    }

    public static byte toCoreType(byte amqType) {
        switch (amqType) {
            case 29: {
                throw new IllegalStateException("We don't support BLOB type yet!");
            }
            case 24: {
                return 4;
            }
            case 25: {
                return 5;
            }
            case 26: {
                return 2;
            }
            case 27: {
                return 6;
            }
            case 28: {
                return 3;
            }
            case 23: {
                return 0;
            }
        }
        throw new IllegalStateException("Unknown ActiveMQ Artemis message type: " + amqType);
    }

    public static MessageDispatch createMessageDispatch(MessageReference reference, ICoreMessage message, WireFormat marshaller, AMQConsumer consumer, UUID serverNodeUUID) throws IOException {
        ActiveMQMessage amqMessage = OpenWireMessageConverter.toAMQMessage(reference, message, marshaller, consumer, serverNodeUUID);
        amqMessage.getMessageId().setBrokerSequenceId(message.getMessageID());
        MessageDispatch md = new MessageDispatch();
        md.setConsumerId(consumer.getId());
        md.setRedeliveryCounter(reference.getDeliveryCount() - 1);
        md.setDeliverySequenceId(amqMessage.getMessageId().getBrokerSequenceId());
        md.setMessage((org.apache.activemq.command.Message)amqMessage);
        ActiveMQDestination destination = amqMessage.getDestination();
        md.setDestination(destination);
        return md;
    }

    private static ActiveMQMessage toAMQMessage(MessageReference reference, ICoreMessage coreMessage, WireFormat marshaller, AMQConsumer consumer, UUID serverNodeUUID) throws IOException {
        Set props;
        Long ingressTimestamp;
        SimpleString lastValueProperty;
        SimpleString dlqCause;
        Boolean isDroppable;
        SimpleString userId;
        byte[] marshalledBytes;
        byte[] producerIdBytes;
        byte[] origTxIdBytes;
        MessageId mid;
        byte[] dsBytes;
        Integer commandId;
        SimpleString clusterPath;
        byte[] bytes;
        Object amqMsg;
        byte coreType = coreMessage.getType();
        Boolean compressProp = OpenWireMessageConverter.getObjectProperty(coreMessage, Boolean.class, AMQ_MSG_COMPRESSED);
        boolean isCompressed = compressProp != null && compressProp != false;
        ActiveMQBuffer buffer = coreMessage.getDataBuffer();
        buffer.resetReaderIndex();
        switch (coreType) {
            case 4: {
                amqMsg = new EagerActiveMQBytesMessage(0);
                bytes = OpenWireMessageConverter.toAMQMessageBytesType(buffer, isCompressed);
                break;
            }
            case 5: {
                amqMsg = new ActiveMQMapMessage();
                bytes = OpenWireMessageConverter.toAMQMessageMapType(buffer, isCompressed);
                break;
            }
            case 2: {
                amqMsg = new ActiveMQObjectMessage();
                bytes = OpenWireMessageConverter.toAMQMessageObjectType(buffer, isCompressed);
                break;
            }
            case 6: {
                amqMsg = new ActiveMQStreamMessage();
                bytes = OpenWireMessageConverter.toAMQMessageStreamType(buffer, isCompressed);
                break;
            }
            case 3: {
                amqMsg = new ActiveMQTextMessage();
                bytes = OpenWireMessageConverter.toAMQMessageTextType(buffer, isCompressed);
                break;
            }
            case 0: {
                amqMsg = new ActiveMQMessage();
                bytes = OpenWireMessageConverter.toAMQMessageDefaultType(buffer, isCompressed);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown message type: " + coreMessage.getType());
            }
        }
        String type = OpenWireMessageConverter.getObjectProperty(coreMessage, String.class, JMS_TYPE_PROPERTY);
        if (type != null) {
            amqMsg.setJMSType(type);
        }
        amqMsg.setPersistent(coreMessage.isDurable());
        amqMsg.setExpiration(coreMessage.getExpiration());
        amqMsg.setPriority(coreMessage.getPriority());
        amqMsg.setTimestamp(coreMessage.getTimestamp());
        Long brokerInTime = OpenWireMessageConverter.getObjectProperty(coreMessage, Long.class, AMQ_MSG_BROKER_IN_TIME);
        if (brokerInTime == null) {
            brokerInTime = 0L;
        }
        amqMsg.setBrokerInTime(brokerInTime.longValue());
        amqMsg.setCompressed(isCompressed);
        Long arrival = OpenWireMessageConverter.getObjectProperty(coreMessage, Long.class, AMQ_MSG_ARRIVAL);
        if (arrival == null) {
            arrival = 0L;
        }
        amqMsg.setArrival(arrival.longValue());
        SimpleString brokerPath = OpenWireMessageConverter.getObjectProperty(coreMessage, SimpleString.class, AMQ_MSG_BROKER_PATH);
        if (brokerPath != null && brokerPath.length() > 0) {
            OpenWireMessageConverter.setAMQMsgBrokerPath((ActiveMQMessage)amqMsg, brokerPath.toString());
        }
        if ((clusterPath = OpenWireMessageConverter.getObjectProperty(coreMessage, SimpleString.class, AMQ_MSG_CLUSTER)) != null && clusterPath.length() > 0) {
            OpenWireMessageConverter.setAMQMsgClusterPath((ActiveMQMessage)amqMsg, clusterPath.toString());
        }
        if ((commandId = OpenWireMessageConverter.getObjectProperty(coreMessage, Integer.class, AMQ_MSG_COMMAND_ID)) == null) {
            commandId = -1;
        }
        amqMsg.setCommandId(commandId.intValue());
        SimpleString corrId = OpenWireMessageConverter.getObjectProperty(coreMessage, SimpleString.class, JMS_CORRELATION_ID_PROPERTY);
        if (corrId != null) {
            amqMsg.setCorrelationId(corrId.toString());
        }
        if ((dsBytes = OpenWireMessageConverter.getObjectProperty(coreMessage, byte[].class, AMQ_MSG_DATASTRUCTURE)) != null) {
            OpenWireMessageConverter.setAMQMsgDataStructure((ActiveMQMessage)amqMsg, marshaller, dsBytes);
        }
        ActiveMQDestination actualDestination = consumer.getOpenwireDestination();
        amqMsg.setDestination(OpenWireUtil.toAMQAddress((Message)coreMessage, actualDestination));
        SimpleString value = coreMessage.getGroupID();
        if (value != null) {
            String groupId = value.toString();
            amqMsg.setGroupID(groupId);
        }
        amqMsg.setGroupSequence(coreMessage.getGroupSequence());
        byte[] midBytes = OpenWireMessageConverter.getObjectProperty(coreMessage, byte[].class, AMQ_MSG_MESSAGE_ID);
        if (midBytes != null) {
            ByteSequence midSeq = new ByteSequence(midBytes);
            mid = (MessageId)marshaller.unmarshal(midSeq);
        } else {
            String midd = "ID:" + serverNodeUUID + ":-1:-1:-1";
            mid = new MessageId(midd, coreMessage.getMessageID());
        }
        amqMsg.setMessageId(mid);
        byte[] origDestBytes = OpenWireMessageConverter.getObjectProperty(coreMessage, byte[].class, AMQ_MSG_ORIG_DESTINATION);
        if (origDestBytes != null) {
            OpenWireMessageConverter.setAMQMsgOriginalDestination((ActiveMQMessage)amqMsg, marshaller, origDestBytes);
        }
        if ((origTxIdBytes = OpenWireMessageConverter.getObjectProperty(coreMessage, byte[].class, AMQ_MSG_ORIG_TXID)) != null) {
            OpenWireMessageConverter.setAMQMsgOriginalTransactionId((ActiveMQMessage)amqMsg, marshaller, origTxIdBytes);
        }
        if ((producerIdBytes = OpenWireMessageConverter.getObjectProperty(coreMessage, byte[].class, AMQ_MSG_PRODUCER_ID)) != null) {
            ProducerId producerId = (ProducerId)marshaller.unmarshal(new ByteSequence(producerIdBytes));
            amqMsg.setProducerId(producerId);
        }
        if ((marshalledBytes = OpenWireMessageConverter.getObjectProperty(coreMessage, byte[].class, AMQ_MSG_MARSHALL_PROP)) != null) {
            amqMsg.setMarshalledProperties(new ByteSequence(marshalledBytes));
        }
        amqMsg.setRedeliveryCounter(reference.getDeliveryCount() - 1);
        byte[] replyToBytes = OpenWireMessageConverter.getObjectProperty(coreMessage, byte[].class, AMQ_MSG_REPLY_TO);
        if (replyToBytes != null) {
            OpenWireMessageConverter.setAMQMsgReplyTo((ActiveMQMessage)amqMsg, marshaller, replyToBytes);
        }
        if ((userId = OpenWireMessageConverter.getObjectProperty(coreMessage, SimpleString.class, AMQ_MSG_USER_ID)) != null && userId.length() > 0) {
            amqMsg.setUserID(userId.toString());
        }
        if ((isDroppable = OpenWireMessageConverter.getObjectProperty(coreMessage, Boolean.class, AMQ_MSG_DROPPABLE)) != null) {
            amqMsg.setDroppable(isDroppable.booleanValue());
        }
        if ((dlqCause = OpenWireMessageConverter.getObjectProperty(coreMessage, SimpleString.class, AMQ_MSG_DLQ_DELIVERY_FAILURE_CAUSE_PROPERTY)) != null) {
            OpenWireMessageConverter.setAMQMsgDlqDeliveryFailureCause((ActiveMQMessage)amqMsg, dlqCause);
        }
        if ((lastValueProperty = coreMessage.getLastValueProperty()) != null) {
            OpenWireMessageConverter.setAMQMsgHdrLastValueName((ActiveMQMessage)amqMsg, lastValueProperty);
        }
        if ((ingressTimestamp = OpenWireMessageConverter.getObjectProperty(coreMessage, Long.class, Message.HDR_INGRESS_TIMESTAMP)) != null) {
            OpenWireMessageConverter.setAMQMsgHdrIngressTimestamp((ActiveMQMessage)amqMsg, ingressTimestamp);
        }
        if ((props = coreMessage.getPropertyNames()) != null) {
            OpenWireMessageConverter.setAMQMsgObjectProperties((ActiveMQMessage)amqMsg, coreMessage, props);
        }
        if (bytes != null) {
            ByteSequence content = new ByteSequence(bytes);
            amqMsg.setContent(content);
        }
        return amqMsg;
    }

    private static <T> T getObjectProperty(ICoreMessage message, Class<T> type, SimpleString property) {
        if (message.getPropertyNames().contains(property)) {
            try {
                Object value = message.getObjectProperty(property);
                if (type == String.class && value != null) {
                    return (T)value.toString();
                }
                return type.cast(value);
            }
            catch (ClassCastException e) {
                ActiveMQServerLogger.LOGGER.failedToDealWithObjectProperty(property, e.getMessage());
            }
        }
        return null;
    }

    private static byte[] toAMQMessageTextType(ActiveMQBuffer buffer, boolean isCompressed) throws IOException {
        byte[] bytes = null;
        SimpleString text = buffer.readNullableSimpleString();
        if (text != null) {
            java.io.ByteArrayOutputStream bytesOut;
            OutputStream out = bytesOut = new java.io.ByteArrayOutputStream(text.length() + 4);
            if (isCompressed) {
                out = new DeflaterOutputStream(out, true);
            }
            try (DataOutputStream dataOut = new DataOutputStream(out);){
                MarshallingSupport.writeUTF8((DataOutput)dataOut, (String)text.toString());
                dataOut.flush();
                bytes = bytesOut.toByteArray();
            }
        }
        return bytes;
    }

    private static byte[] toAMQMessageMapType(ActiveMQBuffer buffer, boolean isCompressed) throws IOException {
        byte[] bytes = null;
        if (buffer.readableBytes() > 0) {
            java.io.ByteArrayOutputStream out;
            TypedProperties mapData = new TypedProperties();
            mapData.decode(buffer.byteBuf());
            Map map = mapData.getMap();
            OutputStream os = out = new java.io.ByteArrayOutputStream(mapData.getEncodeSize());
            if (isCompressed) {
                os = new DeflaterOutputStream(os, true);
            }
            try (DataOutputStream dataOut = new DataOutputStream(os);){
                MarshallingSupport.marshalPrimitiveMap((Map)map, (DataOutputStream)dataOut);
                dataOut.flush();
            }
            bytes = out.toByteArray();
        }
        return bytes;
    }

    private static byte[] toAMQMessageObjectType(ActiveMQBuffer buffer, boolean isCompressed) throws IOException {
        byte[] bytes = null;
        if (buffer.readableBytes() > 0) {
            int len = buffer.readInt();
            bytes = new byte[len];
            buffer.readBytes(bytes);
            if (isCompressed) {
                java.io.ByteArrayOutputStream bytesOut = new java.io.ByteArrayOutputStream();
                try (DeflaterOutputStream out = new DeflaterOutputStream((OutputStream)bytesOut, true);){
                    out.write(bytes);
                    out.flush();
                }
                bytes = bytesOut.toByteArray();
            }
        }
        return bytes;
    }

    private static byte[] toAMQMessageStreamType(ActiveMQBuffer buffer, boolean isCompressed) throws IOException {
        ByteArrayOutputStream bytesOut;
        Object out = bytesOut = new ByteArrayOutputStream();
        if (isCompressed) {
            out = new DeflaterOutputStream((OutputStream)bytesOut, true);
        }
        try (DataOutputStream dataOut = new DataOutputStream((OutputStream)out);){
            boolean stop = false;
            while (!stop && buffer.readable()) {
                byte primitiveType = buffer.readByte();
                switch (primitiveType) {
                    case 2: {
                        MarshallingSupport.marshalBoolean((DataOutputStream)dataOut, (boolean)buffer.readBoolean());
                        break;
                    }
                    case 3: {
                        MarshallingSupport.marshalByte((DataOutputStream)dataOut, (byte)buffer.readByte());
                        break;
                    }
                    case 4: {
                        int len = buffer.readInt();
                        byte[] bytesData = new byte[len];
                        buffer.readBytes(bytesData);
                        MarshallingSupport.marshalByteArray((DataOutputStream)dataOut, (byte[])bytesData);
                        break;
                    }
                    case 11: {
                        char ch = (char)buffer.readShort();
                        MarshallingSupport.marshalChar((DataOutputStream)dataOut, (char)ch);
                        break;
                    }
                    case 9: {
                        double doubleVal = Double.longBitsToDouble(buffer.readLong());
                        MarshallingSupport.marshalDouble((DataOutputStream)dataOut, (double)doubleVal);
                        break;
                    }
                    case 8: {
                        float floatVal = Float.intBitsToFloat(buffer.readInt());
                        MarshallingSupport.marshalFloat((DataOutputStream)dataOut, (float)floatVal);
                        break;
                    }
                    case 6: {
                        MarshallingSupport.marshalInt((DataOutputStream)dataOut, (int)buffer.readInt());
                        break;
                    }
                    case 7: {
                        MarshallingSupport.marshalLong((DataOutputStream)dataOut, (long)buffer.readLong());
                        break;
                    }
                    case 5: {
                        MarshallingSupport.marshalShort((DataOutputStream)dataOut, (short)buffer.readShort());
                        break;
                    }
                    case 10: {
                        String string = buffer.readNullableString();
                        if (string == null) {
                            MarshallingSupport.marshalNull((DataOutputStream)dataOut);
                            break;
                        }
                        MarshallingSupport.marshalString((DataOutputStream)dataOut, (String)string);
                        break;
                    }
                    default: {
                        stop = true;
                    }
                }
                dataOut.flush();
            }
        }
        byte[] bytes = bytesOut.toByteArray();
        return bytes;
    }

    private static byte[] toAMQMessageBytesType(ActiveMQBuffer buffer, boolean isCompressed) throws IOException {
        int n = buffer.readableBytes();
        byte[] bytes = new byte[n];
        buffer.readBytes(bytes);
        if (isCompressed) {
            bytes = OpenWireMessageConverter.toAMQMessageCompressedBytesType(bytes);
        }
        return bytes;
    }

    /*
     * Loose catch block
     */
    private static byte[] toAMQMessageCompressedBytesType(byte[] bytes) throws IOException {
        int length = bytes.length;
        Deflater deflater = new Deflater();
        try {
            try (ByteArrayOutputStream compressed = new ByteArrayOutputStream();){
                compressed.write(new byte[4]);
                deflater.setInput(bytes);
                deflater.finish();
                byte[] bytesBuf = new byte[1024];
                while (!deflater.finished()) {
                    int count = deflater.deflate(bytesBuf);
                    compressed.write(bytesBuf, 0, count);
                }
                compressed.flush();
                ByteSequence byteSeq = compressed.toByteSequence();
                ByteSequenceData.writeIntBig((ByteSequence)byteSeq, (int)length);
                byte[] byArray = Arrays.copyOfRange(byteSeq.data, 0, byteSeq.length);
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            deflater.end();
        }
    }

    private static byte[] toAMQMessageDefaultType(ActiveMQBuffer buffer, boolean isCompressed) throws IOException {
        int n = buffer.readableBytes();
        byte[] bytes = new byte[n];
        buffer.readBytes(bytes);
        if (isCompressed) {
            try (java.io.ByteArrayOutputStream bytesOut = new java.io.ByteArrayOutputStream();
                 DeflaterOutputStream out = new DeflaterOutputStream((OutputStream)bytesOut, true);){
                out.write(bytes);
                out.flush();
                bytes = bytesOut.toByteArray();
            }
        }
        return bytes;
    }

    private static void setAMQMsgBrokerPath(ActiveMQMessage amqMsg, String brokerPath) {
        String[] brokers = brokerPath.split(",");
        BrokerId[] bids = new BrokerId[brokers.length];
        for (int i = 0; i < bids.length; ++i) {
            bids[i] = new BrokerId(brokers[i]);
        }
        amqMsg.setBrokerPath(bids);
    }

    private static void setAMQMsgClusterPath(ActiveMQMessage amqMsg, String clusterPath) {
        String[] cluster = clusterPath.split(",");
        BrokerId[] bids = new BrokerId[cluster.length];
        for (int i = 0; i < bids.length; ++i) {
            bids[i] = new BrokerId(cluster[i]);
        }
        amqMsg.setCluster(bids);
    }

    private static void setAMQMsgDataStructure(ActiveMQMessage amqMsg, WireFormat marshaller, byte[] dsBytes) throws IOException {
        ByteSequence seq = new ByteSequence(dsBytes);
        DataStructure ds = (DataStructure)marshaller.unmarshal(seq);
        amqMsg.setDataStructure(ds);
    }

    private static void setAMQMsgOriginalDestination(ActiveMQMessage amqMsg, WireFormat marshaller, byte[] origDestBytes) throws IOException {
        ActiveMQDestination origDest = (ActiveMQDestination)marshaller.unmarshal(new ByteSequence(origDestBytes));
        amqMsg.setOriginalDestination(origDest);
    }

    private static void setAMQMsgOriginalTransactionId(ActiveMQMessage amqMsg, WireFormat marshaller, byte[] origTxIdBytes) throws IOException {
        TransactionId origTxId = (TransactionId)marshaller.unmarshal(new ByteSequence(origTxIdBytes));
        amqMsg.setOriginalTransactionId(origTxId);
    }

    private static void setAMQMsgReplyTo(ActiveMQMessage amqMsg, WireFormat marshaller, byte[] replyToBytes) throws IOException {
        ActiveMQDestination replyTo = (ActiveMQDestination)marshaller.unmarshal(new ByteSequence(replyToBytes));
        amqMsg.setReplyTo(replyTo);
    }

    private static void setAMQMsgDlqDeliveryFailureCause(ActiveMQMessage amqMsg, SimpleString dlqCause) throws IOException {
        try {
            amqMsg.setStringProperty("dlqDeliveryFailureCause", dlqCause.toString());
        }
        catch (JMSException e) {
            throw new IOException("failure to set dlq property " + dlqCause, e);
        }
    }

    private static void setAMQMsgHdrLastValueName(ActiveMQMessage amqMsg, SimpleString lastValueProperty) throws IOException {
        try {
            amqMsg.setStringProperty(Message.HDR_LAST_VALUE_NAME.toString(), lastValueProperty.toString());
        }
        catch (JMSException e) {
            throw new IOException("failure to set lvq property " + lastValueProperty, e);
        }
    }

    private static void setAMQMsgHdrIngressTimestamp(ActiveMQMessage amqMsg, Long ingressTimestamp) throws IOException {
        try {
            amqMsg.setLongProperty(Message.HDR_INGRESS_TIMESTAMP.toString(), ingressTimestamp.longValue());
        }
        catch (JMSException e) {
            throw new IOException("failure to set ingress timestamp property " + ingressTimestamp, e);
        }
    }

    private static void setAMQMsgObjectProperties(ActiveMQMessage amqMsg, ICoreMessage coreMessage, Set<SimpleString> props) throws IOException {
        for (SimpleString s : props) {
            String keyStr = s.toString();
            if (!coreMessage.containsProperty(ManagementHelper.HDR_NOTIFICATION_TYPE) && (keyStr.startsWith("_AMQ") || keyStr.startsWith("__HDR_"))) continue;
            Object prop = coreMessage.getObjectProperty(s);
            try {
                if (prop instanceof SimpleString) {
                    amqMsg.setObjectProperty(keyStr, (Object)prop.toString());
                    continue;
                }
                if (prop instanceof byte[]) {
                    amqMsg.setObjectProperty(keyStr, (Object)BaseEncoding.base16().encode((byte[])prop));
                    continue;
                }
                if (keyStr.equals("JMSXDeliveryCount") && prop instanceof Long) {
                    Long l = (Long)prop;
                    amqMsg.setObjectProperty(keyStr, (Object)l.intValue());
                    continue;
                }
                amqMsg.setObjectProperty(keyStr, prop);
            }
            catch (JMSException e) {
                ActiveMQServerLogger.LOGGER.failedToDealWithObjectProperty(s, e.getMessage());
            }
        }
    }

    private static final class EagerActiveMQBytesMessage
    extends ActiveMQBytesMessage {
        EagerActiveMQBytesMessage(int size) {
            ByteArrayOutputStream os = this.bytesOut = new ByteArrayOutputStream(size);
            this.dataOut = new DataOutputStream((OutputStream)os);
        }
    }
}

