/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.activemq.artemis.shaded.org.jboss.logging.Logger;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.SensitiveDataCodec;

public class DefaultSensitiveStringCodec
implements SensitiveDataCodec<String> {
    private static final Logger logger = Logger.getLogger(DefaultSensitiveStringCodec.class);
    public static final String ALGORITHM = "algorithm";
    public static final String BLOWFISH_KEY = "key";
    public static final String ONE_WAY = "one-way";
    public static final String TWO_WAY = "two-way";
    public static final String KEY_SYSTEM_PROPERTY = "artemis.default.sensitive.string.codec.key";
    private CodecAlgorithm algorithm = new BlowfishAlgorithm(Collections.EMPTY_MAP);

    @Override
    public String decode(Object secret) throws Exception {
        return this.algorithm.decode((String)secret);
    }

    @Override
    public String encode(Object secret) throws Exception {
        return this.algorithm.encode((String)secret);
    }

    @Override
    public void init(Map<String, String> params) throws Exception {
        String algorithm = params.get(ALGORITHM);
        if (algorithm == null || algorithm.equals(TWO_WAY)) {
            this.algorithm = new BlowfishAlgorithm(params);
        } else if (algorithm.equals(ONE_WAY)) {
            this.algorithm = new PBKDF2Algorithm(params);
        } else {
            throw new IllegalArgumentException("Invalid algorithm: " + algorithm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Properties properties;
        if (args.length != 1) {
            System.err.println("Use: java -cp <classPath> org.apache.activemq.artemis.utils.DefaultSensitiveStringCodec password-to-encode");
            System.err.println("Error: no password on the args");
            System.exit(-1);
        }
        DefaultSensitiveStringCodec codec = new DefaultSensitiveStringCodec();
        HashMap<String, String> params = new HashMap<String, String>();
        Properties properties2 = properties = System.getProperties();
        synchronized (properties2) {
            for (String name : properties.stringPropertyNames()) {
                params.put(name, properties.getProperty(name));
            }
        }
        codec.init(params);
        String encode = codec.encode(args[0]);
        System.out.println("Encoded password (without quotes): \"" + encode + "\"");
    }

    @Override
    public boolean verify(char[] inputValue, String storedValue) {
        return this.algorithm.verify(inputValue, storedValue);
    }

    private class PBKDF2Algorithm
    extends CodecAlgorithm {
        private static final String SEPARATOR = ":";
        private String sceretKeyAlgorithm;
        private String randomScheme;
        private int keyLength;
        private int saltLength;
        private int iterations;
        private SecretKeyFactory skf;

        PBKDF2Algorithm(Map<String, String> params) throws NoSuchAlgorithmException {
            super(params);
            this.sceretKeyAlgorithm = "PBKDF2WithHmacSHA1";
            this.randomScheme = "SHA1PRNG";
            this.keyLength = 512;
            this.saltLength = 32;
            this.iterations = 1024;
            this.skf = SecretKeyFactory.getInstance(this.sceretKeyAlgorithm);
        }

        @Override
        public String decode(String secret) throws Exception {
            throw new IllegalArgumentException("Algorithm doesn't support decoding");
        }

        public byte[] getSalt() throws NoSuchAlgorithmException {
            byte[] salt = RandomUtil.randomBytes(this.saltLength);
            return salt;
        }

        @Override
        public String encode(String secret) throws Exception {
            char[] chars = secret.toCharArray();
            byte[] salt = this.getSalt();
            StringBuilder builder = new StringBuilder();
            builder.append(this.iterations).append(SEPARATOR).append(ByteUtil.bytesToHex(salt)).append(SEPARATOR);
            PBEKeySpec spec = new PBEKeySpec(chars, salt, this.iterations, this.keyLength);
            byte[] hash = this.skf.generateSecret(spec).getEncoded();
            String hexValue = ByteUtil.bytesToHex(hash);
            builder.append(hexValue);
            return builder.toString();
        }

        @Override
        public boolean verify(char[] plainChars, String storedValue) {
            byte[] newHash;
            String[] parts = storedValue.split(SEPARATOR);
            int originalIterations = Integer.parseInt(parts[0]);
            byte[] salt = ByteUtil.hexToBytes(parts[1]);
            byte[] originalHash = ByteUtil.hexToBytes(parts[2]);
            PBEKeySpec spec = new PBEKeySpec(plainChars, salt, originalIterations, originalHash.length * 8);
            try {
                newHash = this.skf.generateSecret(spec).getEncoded();
            }
            catch (InvalidKeySpecException e) {
                return false;
            }
            return Arrays.equals(newHash, originalHash);
        }
    }

    private class BlowfishAlgorithm
    extends CodecAlgorithm {
        private byte[] internalKey;

        BlowfishAlgorithm(Map<String, String> params) {
            super(params);
            this.internalKey = "clusterpassword".getBytes();
            String key = params.get(DefaultSensitiveStringCodec.BLOWFISH_KEY);
            if (key != null) {
                this.updateKey(key);
            } else {
                key = System.getProperty(DefaultSensitiveStringCodec.KEY_SYSTEM_PROPERTY);
                if (key != null && key.trim().length() > 0) {
                    logger.trace("Set key from system property artemis.default.sensitive.string.codec.key");
                    this.updateKey(key);
                }
            }
        }

        private void updateKey(String key) {
            this.internalKey = key.getBytes();
        }

        @Override
        public String decode(String secret) throws Exception {
            byte[] encoding;
            SecretKeySpec key = new SecretKeySpec(this.internalKey, "Blowfish");
            try {
                encoding = new BigInteger(secret, 16).toByteArray();
            }
            catch (Exception ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)ex.getMessage(), ex);
                }
                throw new IllegalArgumentException("Password must be encrypted.");
            }
            if (encoding.length % 8 != 0) {
                int length = encoding.length;
                int newLength = (length / 8 + 1) * 8;
                int pad = newLength - length;
                byte[] old = encoding;
                encoding = new byte[newLength];
                System.arraycopy(old, 0, encoding, pad, old.length);
            }
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(2, key);
            byte[] decode = cipher.doFinal(encoding);
            return new String(decode);
        }

        @Override
        public String encode(String secret) throws Exception {
            SecretKeySpec key = new SecretKeySpec(this.internalKey, "Blowfish");
            Cipher cipher = Cipher.getInstance("Blowfish");
            cipher.init(1, key);
            byte[] encoding = cipher.doFinal(secret.getBytes());
            BigInteger n = new BigInteger(encoding);
            return n.toString(16);
        }

        @Override
        public boolean verify(char[] inputValue, String storedValue) {
            try {
                return Objects.equals(storedValue, this.encode(String.valueOf(inputValue)));
            }
            catch (Exception e) {
                logger.debug("Exception on verifying: " + e);
                return false;
            }
        }
    }

    private abstract class CodecAlgorithm {
        protected Map<String, String> params;

        CodecAlgorithm(Map<String, String> params) {
            this.params = params;
        }

        public abstract String decode(String var1) throws Exception;

        public abstract String encode(String var1) throws Exception;

        public boolean verify(char[] inputValue, String storedValue) {
            return false;
        }
    }
}

