/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Experimental;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.NoBundler;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ByteArrayDataOutputStream;
import org.apache.activemq.artemis.shaded.org.jgroups.util.DefaultThreadFactory;

@Experimental
public class AsyncNoBundler
extends NoBundler {
    protected int max_threads = 20;
    protected final ThreadPoolExecutor thread_pool = new ThreadPoolExecutor(0, this.max_threads, 30000L, TimeUnit.MICROSECONDS, new SynchronousQueue<Runnable>(), new DefaultThreadFactory("async-bundler", true, true), new ThreadPoolExecutor.CallerRunsPolicy());

    public AsyncNoBundler() {
        this.thread_pool.allowCoreThreadTimeOut(true);
    }

    @Override
    public void send(Message msg) throws Exception {
        Runnable async_send = () -> {
            ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(msg.size() + 10);
            try {
                this.sendSingleMessage(msg, out);
            }
            catch (Exception e) {
                this.log.error("failed sending message", e);
            }
        };
        this.thread_pool.execute(async_send);
    }
}

