/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.fork;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Event;
import org.apache.activemq.artemis.shaded.org.jgroups.JChannel;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.fork.UnknownForkHandler;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.FORK;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.ProtocolStack;
import org.apache.activemq.artemis.shaded.org.jgroups.util.MessageBatch;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class ForkProtocolStack
extends ProtocolStack {
    protected final String fork_stack_id;
    protected final ConcurrentMap<String, JChannel> fork_channels = new ConcurrentHashMap<String, JChannel>();
    protected UnknownForkHandler unknownForkHandler;
    protected final List<Protocol> protocols;
    protected int inits;
    protected int connects;

    public ForkProtocolStack(UnknownForkHandler unknownForkHandler, List<Protocol> protocols, String fork_stack_id) {
        this.unknownForkHandler = unknownForkHandler;
        this.fork_stack_id = fork_stack_id;
        this.protocols = new ArrayList<Protocol>(protocols != null ? protocols.size() : 0);
        if (protocols != null) {
            for (int i = protocols.size() - 1; i >= 0; --i) {
                this.protocols.add(protocols.get(i));
            }
        }
    }

    public ConcurrentMap<String, JChannel> getForkChannels() {
        return this.fork_channels;
    }

    public JChannel get(String fork_channel_id) {
        return (JChannel)this.fork_channels.get(fork_channel_id);
    }

    public JChannel putIfAbsent(String id, JChannel fc) {
        return this.fork_channels.putIfAbsent(id, fc);
    }

    public void remove(String fork_channel_id) {
        this.fork_channels.remove(fork_channel_id);
    }

    public synchronized int getInits() {
        return this.inits;
    }

    public synchronized int getConnects() {
        return this.connects;
    }

    public void setUnknownForkHandler(UnknownForkHandler ufh) {
        this.unknownForkHandler = ufh;
    }

    public UnknownForkHandler getUnknownForkHandler() {
        return this.unknownForkHandler;
    }

    @Override
    public Object down(Event evt) {
        return this.down_prot.down(evt);
    }

    @Override
    public Object down(Message msg) {
        return this.down_prot.down(msg);
    }

    public void setLocalAddress(Address addr) {
        if (Objects.equals(this.local_addr, addr)) {
            return;
        }
        this.local_addr = addr;
        for (Protocol p = this.down_prot; p != null; p = p.getDownProtocol()) {
            p.setAddress(addr);
        }
    }

    @Override
    public List<Protocol> getProtocols() {
        return new ArrayList<Protocol>(this.protocols);
    }

    public synchronized ForkProtocolStack incrInits() {
        ++this.inits;
        return this;
    }

    @Override
    public void init() throws Exception {
        super.init();
    }

    @Override
    public synchronized void startStack() throws Exception {
        if (++this.connects == 1) {
            super.startStack();
        }
    }

    @Override
    public synchronized void stopStack(String cluster) {
        if (--this.connects == 0) {
            super.stopStack(cluster);
        }
    }

    @Override
    public synchronized void destroy() {
        if (--this.inits == 0) {
            super.destroy();
            this.protocols.clear();
            FORK fork = (FORK)this.findProtocol((Class<? extends Protocol>)FORK.class);
            fork.remove(this.fork_stack_id);
        }
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 104: {
                for (JChannel ch : this.fork_channels.values()) {
                    ch.up(evt);
                }
                break;
            }
        }
        return null;
    }

    @Override
    public Object up(Message msg) {
        FORK.ForkHeader hdr = (FORK.ForkHeader)msg.getHeader(FORK.ID);
        if (hdr == null) {
            return null;
        }
        String forkId = hdr.getForkChannelId();
        if (forkId == null) {
            throw new IllegalArgumentException("header has a null fork_channel_id");
        }
        JChannel fork_channel = this.get(forkId);
        if (fork_channel == null) {
            return this.unknownForkHandler.handleUnknownForkChannel(msg, forkId);
        }
        return fork_channel.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        HashMap<String, List> map = new HashMap<String, List>();
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            FORK.ForkHeader hdr = (FORK.ForkHeader)msg.getHeader(FORK.ID);
            if (hdr == null) continue;
            it.remove();
            List list = map.computeIfAbsent(hdr.getForkChannelId(), k -> new ArrayList());
            list.add(msg);
        }
        for (Map.Entry entry : map.entrySet()) {
            String fork_channel_id = (String)entry.getKey();
            List list = (List)entry.getValue();
            JChannel fork_channel = this.get(fork_channel_id);
            if (fork_channel == null) {
                for (Message m : list) {
                    this.unknownForkHandler.handleUnknownForkChannel(m, fork_channel_id);
                }
                continue;
            }
            MessageBatch mb = new MessageBatch(batch.dest(), batch.sender(), batch.clusterName(), batch.multicast(), list);
            try {
                fork_channel.up(mb);
            }
            catch (Throwable t) {
                this.log.error(Util.getMessage("FailedPassingUpBatch"), t);
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }
}

