/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.server.master.state.SuspendingTServer;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletState;
import org.apache.hadoop.io.Text;

public class TabletLocationState {
    public final KeyExtent extent;
    public final TServerInstance future;
    public final TServerInstance current;
    public final TServerInstance last;
    public final SuspendingTServer suspend;
    public final Collection<Collection<String>> walogs;
    public final boolean chopped;
    private static final int _HAS_CURRENT = 1;
    private static final int _HAS_FUTURE = 2;
    private static final int _HAS_SUSPEND = 4;

    public TabletLocationState(KeyExtent extent, TServerInstance future, TServerInstance current, TServerInstance last, SuspendingTServer suspend, Collection<Collection<String>> walogs, boolean chopped) throws BadLocationStateException {
        this.extent = extent;
        this.future = future;
        this.current = current;
        this.last = last;
        this.suspend = suspend;
        if (walogs == null) {
            walogs = Collections.emptyList();
        }
        this.walogs = walogs;
        this.chopped = chopped;
        if (current != null && future != null) {
            throw new BadLocationStateException(extent + " is both assigned and hosted, which should never happen: " + this, extent.getMetadataEntry());
        }
    }

    public TServerInstance futureOrCurrent() {
        if (this.current != null) {
            return this.current;
        }
        return this.future;
    }

    public String toString() {
        return this.extent + "@(" + this.future + "," + this.current + "," + this.last + ")" + (this.chopped ? " chopped" : "");
    }

    public TServerInstance getServer() {
        TServerInstance result = null;
        result = this.current != null ? this.current : (this.future != null ? this.future : this.last);
        return result;
    }

    public TabletState getState(Set<TServerInstance> liveServers) {
        switch ((this.current == null ? 0 : 1) | (this.future == null ? 0 : 2) | (this.suspend == null ? 0 : 4)) {
            case 0: {
                return TabletState.UNASSIGNED;
            }
            case 4: {
                return TabletState.SUSPENDED;
            }
            case 2: 
            case 6: {
                return liveServers.contains(this.future) ? TabletState.ASSIGNED : TabletState.ASSIGNED_TO_DEAD_SERVER;
            }
            case 1: 
            case 5: {
                return liveServers.contains(this.current) ? TabletState.HOSTED : TabletState.ASSIGNED_TO_DEAD_SERVER;
            }
        }
        throw new IllegalStateException();
    }

    public static class BadLocationStateException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private Text metadataTableEntry;

        BadLocationStateException(String msg, Text row) {
            super(msg);
            this.metadataTableEntry = row;
        }

        public Text getEncodedEndRow() {
            return this.metadataTableEntry;
        }
    }
}

