/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.converter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.activiti.workflow.simple.converter.WorkflowDefinitionConversion;
import org.activiti.workflow.simple.converter.listener.DefaultWorkflowDefinitionConversionListener;
import org.activiti.workflow.simple.converter.listener.WorkflowDefinitionConversionListener;
import org.activiti.workflow.simple.converter.step.ChoiceStepsDefinitionConverter;
import org.activiti.workflow.simple.converter.step.DelayStepDefinitionConverter;
import org.activiti.workflow.simple.converter.step.FeedbackStepDefinitionConverter;
import org.activiti.workflow.simple.converter.step.HumanStepDefinitionConverter;
import org.activiti.workflow.simple.converter.step.ParallelStepsDefinitionConverter;
import org.activiti.workflow.simple.converter.step.ScriptStepDefinitionConverter;
import org.activiti.workflow.simple.converter.step.StepDefinitionConverter;
import org.activiti.workflow.simple.definition.StepDefinition;
import org.activiti.workflow.simple.definition.WorkflowDefinition;

public class WorkflowDefinitionConversionFactory {
    private static final long serialVersionUID = 229288964476630200L;
    protected HashMap<Class<?>, StepDefinitionConverter> defaultStepConverters;
    protected HashMap<Class<?>, StepDefinitionConverter> stepConverters;
    protected List<WorkflowDefinitionConversionListener> defaultWorkflowDefinitionConversionListeners;
    protected List<WorkflowDefinitionConversionListener> workflowDefinitionConversionListeners;
    protected List<WorkflowDefinitionConversionListener> allWorkflowDefinitionConversionListeners;

    public WorkflowDefinitionConversionFactory() {
        this.initDefaultStepConverters();
        this.initDefaultWorkflowDefinitionConversionListeners();
    }

    protected void initDefaultStepConverters() {
        ArrayList<StepDefinitionConverter> converters = new ArrayList<StepDefinitionConverter>();
        converters.add(new ParallelStepsDefinitionConverter());
        converters.add(new ChoiceStepsDefinitionConverter());
        converters.add(new HumanStepDefinitionConverter());
        converters.add(new FeedbackStepDefinitionConverter());
        converters.add(new ScriptStepDefinitionConverter());
        converters.add(new DelayStepDefinitionConverter());
        this.setDefaultStepDefinitionConverters(converters);
    }

    protected void initDefaultWorkflowDefinitionConversionListeners() {
        ArrayList<WorkflowDefinitionConversionListener> listeners = new ArrayList<WorkflowDefinitionConversionListener>();
        listeners.add(new DefaultWorkflowDefinitionConversionListener());
        this.setDefaultWorkflowDefinitionConversionListeners(listeners);
    }

    public WorkflowDefinitionConversion createWorkflowDefinitionConversion() {
        return new WorkflowDefinitionConversion(this);
    }

    public WorkflowDefinitionConversion createWorkflowDefinitionConversion(WorkflowDefinition workflowDefinition) {
        return new WorkflowDefinitionConversion(this, workflowDefinition);
    }

    public void setDefaultStepDefinitionConverters(List<StepDefinitionConverter> stepConverters) {
        this.defaultStepConverters = new HashMap();
        for (StepDefinitionConverter converter : stepConverters) {
            this.defaultStepConverters.put(converter.getHandledClass(), converter);
        }
    }

    public void setStepDefinitionConverters(List<StepDefinitionConverter> stepConverters) {
        this.stepConverters = new HashMap();
        for (StepDefinitionConverter converter : stepConverters) {
            this.stepConverters.put(converter.getHandledClass(), converter);
        }
    }

    public List<WorkflowDefinitionConversionListener> getAllWorkflowDefinitionConversionListeners() {
        if (this.allWorkflowDefinitionConversionListeners == null) {
            this.allWorkflowDefinitionConversionListeners = new ArrayList<WorkflowDefinitionConversionListener>();
            if (this.defaultWorkflowDefinitionConversionListeners != null) {
                this.allWorkflowDefinitionConversionListeners.addAll(this.defaultWorkflowDefinitionConversionListeners);
            }
            if (this.workflowDefinitionConversionListeners != null) {
                this.allWorkflowDefinitionConversionListeners.addAll(this.workflowDefinitionConversionListeners);
            }
        }
        return this.allWorkflowDefinitionConversionListeners;
    }

    public void setDefaultWorkflowDefinitionConversionListeners(List<WorkflowDefinitionConversionListener> defaultWorkflowDefinitionConversionListeners) {
        this.defaultWorkflowDefinitionConversionListeners = defaultWorkflowDefinitionConversionListeners;
        this.allWorkflowDefinitionConversionListeners = null;
    }

    public void setWorkflowDefinitionConversionListeners(List<WorkflowDefinitionConversionListener> workflowDefinitionConversionListeners) {
        this.workflowDefinitionConversionListeners = workflowDefinitionConversionListeners;
        this.allWorkflowDefinitionConversionListeners = null;
    }

    public StepDefinitionConverter getStepConverterFor(StepDefinition definition) {
        StepDefinitionConverter converter = null;
        if (this.stepConverters != null) {
            converter = this.stepConverters.get(definition.getClass());
        }
        if (converter == null && this.defaultStepConverters != null) {
            converter = this.defaultStepConverters.get(definition.getClass());
        }
        if (converter == null) {
            throw new IllegalArgumentException("No converter found for step: " + definition.getClass());
        }
        return converter;
    }
}

