/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.webservice;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.webservice.SyncWebServiceClient;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;

public class CxfWebServiceClient
implements SyncWebServiceClient {
    protected Client client;

    public CxfWebServiceClient(String wsdl) {
        JaxWsDynamicClientFactory dcf = JaxWsDynamicClientFactory.newInstance();
        try {
            URL xjcBindingUrl;
            Enumeration<URL> xjcBindingUrls = Thread.currentThread().getContextClassLoader().getResources("activiti-bindings.xjc");
            if (xjcBindingUrls.hasMoreElements()) {
                xjcBindingUrl = xjcBindingUrls.nextElement();
                if (xjcBindingUrls.hasMoreElements()) {
                    throw new ActivitiException("Several JAXB binding definitions found for activiti-cxf: activiti-bindings.xjc");
                }
            } else {
                throw new ActivitiException("The JAXB binding definitions are not found for activiti-cxf: activiti-bindings.xjc");
            }
            this.client = dcf.createClient(wsdl, Arrays.asList(xjcBindingUrl.toString()));
            this.client.getRequestContext().put("org.apache.cxf.stax.force-start-document", Boolean.TRUE);
        }
        catch (IOException e) {
            throw new ActivitiException("An error occurs creating a web-service client for WSDL '" + wsdl + "'.", (Throwable)e);
        }
    }

    public Object[] send(String methodName, Object[] arguments) throws Exception {
        return this.client.invoke(methodName, arguments);
    }
}

