/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish.mapper;

import jadex.commons.SUtil;
import jadex.extension.rs.publish.mapper.IValueMapper;
import jadex.extension.rs.publish.mapper.ResourceInfo;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.util.Map;

public class NativeResponseMapper
implements IValueMapper {
    @Override
    public Object convertValue(Object value) throws Exception {
        Object o = this.extractContent(value);
        Response.ResponseBuilder ret = null;
        if (o instanceof ResourceInfo) {
            String cttype;
            ResourceInfo ri = (ResourceInfo)o;
            if (ri.getPath() != null) {
                o = SUtil.getResource0((String)ri.getPath(), null);
            } else if (ri.getData() != null) {
                o = new ByteArrayInputStream(ri.getData());
            }
            ret = Response.ok((Object)o);
            if (ri.getStatus() != null) {
                ret.status(ri.getStatus().intValue());
            }
            if (ri.getMediatype() != null) {
                ret = ret.type(ri.getMediatype());
            }
            if (ri.getHeaders() != null) {
                Map<String, String> headers = ri.getHeaders();
                if (headers != null) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        ret = ret.header(entry.getKey(), (Object)entry.getValue());
                    }
                }
            } else if (ri.getPath() != null && (cttype = SUtil.guessContentTypeByFilename((String)ri.getPath())) != null) {
                ret = ret.type(cttype);
            }
            ret.header("Access-Control-Allow-Origin", (Object)"*");
            ret.header("Access-Control-Allow-Credentials", (Object)"true ");
            ret.header("Access-Control-Allow-Methods", (Object)"OPTIONS, GET, POST");
            ret.header("Access-Control-Allow-Headers", (Object)"Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");
        } else if (o instanceof String) {
            ret = Response.ok((Object)o);
            ret.header("Access-Control-Allow-Origin", (Object)"*");
            ret.header("Access-Control-Allow-Credentials", (Object)"true ");
            ret.header("Access-Control-Allow-Methods", (Object)"OPTIONS, GET, POST");
            ret.header("Access-Control-Allow-Headers", (Object)"Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");
        } else if (o instanceof Exception) {
            if (!this.isProduction()) {
                ret = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("<html><head></head><body><pre>\n" + SUtil.getExceptionStacktrace((Throwable)((Exception)o)) + "\n</pre></body></html>"));
                ret.header("Access-Control-Allow-Origin", (Object)"*");
                ret.header("Access-Control-Allow-Credentials", (Object)"true ");
                ret.header("Access-Control-Allow-Methods", (Object)"OPTIONS, GET, POST");
                ret.header("Access-Control-Allow-Headers", (Object)"Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");
            } else {
                ret = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"<html><head></head><body><h1>500 Internal server error</h1></body></html>");
                ret.header("Access-Control-Allow-Origin", (Object)"*");
                ret.header("Access-Control-Allow-Credentials", (Object)"true ");
                ret.header("Access-Control-Allow-Methods", (Object)"OPTIONS, GET, POST");
                ret.header("Access-Control-Allow-Headers", (Object)"Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");
            }
        } else if (o instanceof URI) {
            URI uri = (URI)o;
            if (uri.toString().indexOf(":") == -1) {
                uri = new URI("http://" + uri.toString());
            }
            ret = Response.status((Response.Status)Response.Status.SEE_OTHER).location(uri);
            ret.header("Access-Control-Allow-Origin", (Object)"*");
            ret.header("Access-Control-Allow-Credentials", (Object)"true ");
            ret.header("Access-Control-Allow-Methods", (Object)"OPTIONS, GET, POST");
            ret.header("Access-Control-Allow-Headers", (Object)"Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");
        }
        return ret == null ? value : ret.build();
    }

    protected Object extractContent(Object value) {
        return value;
    }

    protected boolean isProduction() {
        boolean ret = false;
        String pro = System.getProperty("production", System.getenv("production"));
        if (pro != null) {
            try {
                ret = Boolean.parseBoolean(pro);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }
}

