/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import jadex.bridge.service.IService;
import jadex.bridge.service.IServiceIdentifier;
import jadex.bridge.service.PublishInfo;
import jadex.bridge.service.annotation.OnStart;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.component.IProvidedServicesFeature;
import jadex.bridge.service.component.IRequiredServicesFeature;
import jadex.bridge.service.search.ServiceQuery;
import jadex.commons.Tuple2;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.extension.rs.publish.AbstractRestPublishService;
import jadex.extension.rs.publish.IPathHandler;
import jadex.extension.rs.publish.IRequestHandler;
import jadex.extension.rs.publish.IRequestHandlerService;
import jadex.extension.rs.publish.PathHandler;
import jadex.extension.rs.publish.PathManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

@Service
public class ExternalRestPublishService
extends AbstractRestPublishService
implements IRequestHandlerService {
    public static final String DEFAULT_HOST = "DEFAULTHOST";
    public static final int DEFAULT_PORT = 0;
    public static final String DEFAULT_APP = "DEFAULTAPP";
    public static final String DEFAULT_COMPLETECONTEXT = "http://DEFAULTHOST:0/DEFAULTAPP/";
    protected Map<IServiceIdentifier, Tuple2<IPathHandler, URI>> sidservers;
    protected Map<Integer, IPathHandler> portservers;
    protected boolean inited;

    @Override
    @OnStart
    public IFuture<Void> init() {
        if (!this.inited) {
            this.inited = true;
            super.init();
            IProvidedServicesFeature psf = (IProvidedServicesFeature)this.component.getFeature(IProvidedServicesFeature.class);
            return psf.addService("requesthandlerser", IRequestHandlerService.class, (Object)this);
        }
        return IFuture.DONE;
    }

    @Override
    public IFuture<Void> handleRequest(HttpServletRequest request, HttpServletResponse response, Object args) {
        Future ret = new Future();
        Object err = null;
        if (this.portservers != null) {
            IPathHandler ph = this.portservers.get(request.getLocalPort());
            if (ph == null) {
                ph = this.portservers.get(0);
            }
            if (ph != null) {
                try {
                    ph.handleRequest(request, response, args);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    err = this.getServicesInfo(request, ph);
                }
            } else {
                err = "No service registered to handle the request.";
            }
        } else {
            err = "No server at port: " + request.getLocalPort();
        }
        if (err != null) {
            response.setContentType("text/html");
            try {
                PrintWriter out = response.getWriter();
                ((Writer)out).write("<html><head></head><body>" + (String)err + "</body></html>");
                this.complete(request, response);
                ret.setResult(null);
            }
            catch (Exception e) {
                ret.setException(e);
            }
        } else {
            ret.setResult(null);
        }
        return ret;
    }

    @Override
    public IFuture<Boolean> isSupported(String publishtype) {
        return "rs".equals(publishtype) ? IFuture.TRUE : IFuture.FALSE;
    }

    @Override
    public IFuture<Void> publishService(final IServiceIdentifier serviceid, final PublishInfo info) {
        System.out.println("publish service: " + serviceid + " " + info);
        final Future ret = new Future();
        IFuture<PathManager<AbstractRestPublishService.MappingInfo>> fut = this.evaluateMapping(serviceid, info);
        fut.addResultListener((IResultListener)new ExceptionDelegationResultListener<PathManager<AbstractRestPublishService.MappingInfo>, Void>(ret){

            public void customResultAvailable(final PathManager<AbstractRestPublishService.MappingInfo> mappings) {
                try {
                    String infopid = info.getPublishId();
                    if (infopid.endsWith("/")) {
                        infopid = infopid.substring(0, infopid.length() - 1);
                    }
                    URI uri = ExternalRestPublishService.this.convertUri(infopid);
                    ExternalRestPublishService.this.component.getLogger().info("Adding http handler to server: " + uri.getPath());
                    ExternalRestPublishService.this.getHttpServer(uri, info);
                    IPathHandler ph = ExternalRestPublishService.this.portservers.get(uri.getPort());
                    IRequestHandler rh = new IRequestHandler(){
                        protected IService service = null;

                        @Override
                        public void handleRequest(HttpServletRequest request, HttpServletResponse response, Object args) throws Exception {
                            if (this.service == null) {
                                this.service = (IService)((IRequiredServicesFeature)ExternalRestPublishService.this.component.getFeature(IRequiredServicesFeature.class)).searchService(new ServiceQuery((Class)null).setServiceIdentifier(serviceid)).get();
                            }
                            ExternalRestPublishService.this.handleRequest(this.service, mappings, request, response, null);
                        }
                    };
                    if (ph.containsSubhandlerForExactUri(null, uri.getPath())) {
                        ExternalRestPublishService.this.component.getLogger().info("The URL " + uri.getPath() + " is already published, unpublishing...");
                        ph.removeSubhandler(null, uri.getPath());
                    }
                    ph.addSubhandler(null, uri.getPath(), rh);
                    if (ExternalRestPublishService.this.sidservers == null) {
                        ExternalRestPublishService.this.sidservers = new HashMap<IServiceIdentifier, Tuple2<IPathHandler, URI>>();
                    }
                    ExternalRestPublishService.this.sidservers.put(serviceid, (Tuple2<IPathHandler, URI>)new Tuple2((Object)ph, (Object)uri));
                    ret.setResult(null);
                }
                catch (Exception e) {
                    ret.setException(e);
                }
            }
        });
        return ret;
    }

    @Override
    public Object getHttpServer(URI uri, PublishInfo info) {
        IRequestHandler server = null;
        try {
            IRequestHandler iRequestHandler = server = this.portservers == null ? null : (IRequestHandler)this.portservers.get(uri.getPort());
            if (server == null) {
                System.out.println("Starting new server: " + uri.getPort());
                PathHandler ph = new PathHandler();
                if (this.portservers == null) {
                    this.portservers = new HashMap<Integer, IPathHandler>();
                }
                this.portservers.put(uri.getPort(), ph);
                server = ph;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return server;
    }

    public IFuture<Void> unpublishService(IServiceIdentifier sid) {
        Tuple2<IPathHandler, URI> tup = this.sidservers.get(sid);
        if (tup != null) {
            ((IPathHandler)tup.getFirstEntity()).removeSubhandler(null, ((URI)tup.getSecondEntity()).getPath());
        }
        return IFuture.DONE;
    }

    public IFuture<Void> publishHMTLPage(String pid, String vhost, final String html) {
        try {
            URI uri = this.convertUri(pid);
            this.component.getLogger().info("Adding http handler to server: " + uri.getPath());
            this.getHttpServer(uri, null);
            IPathHandler ph = this.portservers.get(uri.getPort());
            IRequestHandler rh = new IRequestHandler(){

                @Override
                public void handleRequest(HttpServletRequest request, HttpServletResponse response, Object args) throws Exception {
                    response.getWriter().write(html);
                }
            };
            if (ph.containsSubhandlerForExactUri(null, uri.getPath())) {
                this.component.getLogger().info("The URL " + uri.getPath() + " is already published, unpublishing...");
                ph.removeSubhandler(null, uri.getPath());
            }
            ph.addSubhandler(null, uri.getPath(), rh);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return IFuture.DONE;
    }

    public IFuture<Void> publishResources(String uri, String rootpath) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> publishExternal(URI uri, String rootpath) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> publishRedirect(URI uri, String html) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> unpublish(String vhost, URI uri) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> mirrorHttpServer(URI sourceserveruri, URI targetserveruri, PublishInfo info) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> shutdownHttpServer(URI uri) {
        throw new UnsupportedOperationException();
    }

    public String getServicesInfo(HttpServletRequest request, IPathHandler ph) {
        StringBuffer ret = new StringBuffer();
        try {
            String functionsjs = this.loadFunctionJS();
            String stylecss = this.loadStyleCSS();
            ret.append("<html>");
            ret.append("\n");
            ret.append("<head>");
            ret.append("\n");
            ret.append(stylecss);
            ret.append("\n");
            ret.append(functionsjs);
            ret.append("\n");
            ret.append("</head>");
            ret.append("\n");
            ret.append("<body>");
            ret.append("\n");
            ret.append("<div class=\"header\">");
            ret.append("\n");
            ret.append("<h1>");
            ret.append("Published Services Info");
            ret.append("</h1>");
            ret.append("\n");
            ret.append("</div>");
            ret.append("\n");
            ret.append("<div class=\"middle\">");
            ret.append("\n");
            Map<Tuple2<String, String>, Tuple2<String, IRequestHandler>> subhandlers = ph.getSubhandlers();
            for (Tuple2<String, String> key : subhandlers.keySet()) {
                ret.append("<div class=\"method\">");
                String path = (String)key.getSecondEntity();
                if (path.startsWith("/DEFAULTAPP")) {
                    path = path.replaceFirst("/DEFAULTAPP", request.getContextPath());
                }
                String url = ExternalRestPublishService.getServletHost(request) + path;
                ret.append("Host: ").append(key.getFirstEntity() != null ? (String)key.getFirstEntity() : "-").append(" Path: ").append(path).append("<br/>");
                ret.append("<a href=\"").append(url).append("\">").append(url).append("</a>");
                ret.append("</div>");
            }
            ret.append("</div>");
            ret.append("\n");
            ret.append("<div id=\"result\"></div>");
            ret.append("<div class=\"powered\"> <span class=\"powered\">powered by</span> <span class=\"jadex\">Jadex Active Components</span> <a class=\"jadexurl\" href=\"http://www.activecomponents.org\">http://www.activecomponents.org</a> </div>\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        ret.append("</body>\n</html>\n");
        return ret.toString();
    }

    public URI convertUri(String pid) {
        try {
            URI uri = null;
            if (pid.startsWith("[")) {
                pid = pid.substring(pid.indexOf("]") + 1);
                uri = new URI(DEFAULT_COMPLETECONTEXT + pid);
            } else {
                uri = new URI(pid);
            }
            return uri;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

