/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import jadex.base.Starter;
import jadex.binary.IDecoderHandler;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.ServiceCall;
import jadex.bridge.VersionInfo;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.BasicService;
import jadex.bridge.service.IService;
import jadex.bridge.service.IServiceIdentifier;
import jadex.bridge.service.PublishInfo;
import jadex.bridge.service.annotation.OnStart;
import jadex.bridge.service.annotation.ParameterInfo;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.annotation.ServiceComponent;
import jadex.bridge.service.types.publish.IWebPublishService;
import jadex.bridge.service.types.security.ISecurityService;
import jadex.bridge.service.types.serialization.ISerializationServices;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.Tuple2;
import jadex.commons.collection.LeaseTimeMap;
import jadex.commons.collection.MultiCollection;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.FutureTerminatedException;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.IIntermediateFutureCommandResultListener;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ITerminableFuture;
import jadex.commons.transformation.IObjectStringConverter;
import jadex.commons.transformation.IStringConverter;
import jadex.commons.transformation.traverser.ITraverseProcessor;
import jadex.extension.rs.publish.IAsyncContextInfo;
import jadex.extension.rs.publish.PathManager;
import jadex.extension.rs.publish.annotation.ParametersMapper;
import jadex.extension.rs.publish.annotation.ResultMapper;
import jadex.extension.rs.publish.binary.BinaryResponseProcessor;
import jadex.extension.rs.publish.clone.CloneResponseProcessor;
import jadex.extension.rs.publish.json.JsonResponseProcessor;
import jadex.extension.rs.publish.mapper.DefaultParameterMapper;
import jadex.extension.rs.publish.mapper.IParameterMapper;
import jadex.extension.rs.publish.mapper.IParameterMapper2;
import jadex.extension.rs.publish.mapper.IValueMapper;
import jadex.javaparser.SJavaParser;
import jadex.platform.service.serialization.SerializationServices;
import jadex.platform.service.serialization.serializers.JadexBinarySerializer;
import jadex.platform.service.serialization.serializers.JadexJsonSerializer;
import jadex.transformation.jsonserializer.JsonTraverser;
import jadex.xml.bean.JavaWriter;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.stream.Collectors;

@Service
public abstract class AbstractRestPublishService
implements IWebPublishService {
    public static final String ASYNC_CONTEXT_INFO = "__cinfo";
    public static final String HEADER_JADEX_VERSION = "x-jadex-version";
    public static final String HEADER_JADEX_CALLID = "x-jadex-callid";
    public static final String HEADER_JADEX_CALLFINISHED = "x-jadex-callidfin";
    public static final String HEADER_JADEX_MAX = "x-jadex-max";
    public static final String HEADER_JADEX_CLIENTTIMEOUT = "x-jadex-clienttimeout";
    public static final String HEADER_JADEX_ALIVE = "x-jadex-alive";
    public static final String HEADER_JADEX_TERMINATE = "x-jadex-terminate";
    public static final String HEADER_JADEX_LOGIN = "x-jadex-login";
    public static final String HEADER_JADEX_LOGOUT = "x-jadex-logout";
    public static final String HEADER_JADEX_ISLOGGEDIN = "x-jadex-isloggedin";
    public static final String FINISHED = "__finished__";
    public static final String RANDOM = "__random";
    public static final String CONTENTTYPE = "contenttype";
    public static final String ACCEPT = "__accept__";
    public static final List<String> PARAMETER_MEDIATYPES = Arrays.asList("text/plain", "application/json", "application/xml");
    @ServiceComponent
    protected IInternalAccess component;
    protected Map<String, ConversationInfo> conversationinfos;
    protected List<SSEEvent> sseevents;
    protected MultiCollection<String, IObjectStringConverter> converters;
    protected boolean loginsec;
    protected JadexJsonSerializer jsonser;
    protected JadexBinarySerializer binser;
    protected Map<String, Map<String, Object>> sessions;

    @OnStart
    public IFuture<Void> init() {
        this.loginsec = false;
        ISerializationServices ss = SerializationServices.getSerializationServices((IComponentIdentifier)this.component.getId());
        this.jsonser = (JadexJsonSerializer)ss.getSerializer(1);
        JsonResponseProcessor jrp = new JsonResponseProcessor();
        this.jsonser.addProcessor((ITraverseProcessor)jrp, (ITraverseProcessor)jrp);
        this.binser = (JadexBinarySerializer)ss.getSerializer(0);
        BinaryResponseProcessor brp = new BinaryResponseProcessor();
        this.binser.addProcessor((IDecoderHandler)brp, (ITraverseProcessor)brp);
        ss.getCloneProcessors().add(0, new CloneResponseProcessor());
        this.converters = new MultiCollection();
        this.conversationinfos = new LinkedHashMap<String, ConversationInfo>();
        this.sseevents = new ArrayList<SSEEvent>();
        this.sessions = new LeaseTimeMap(600000L);
        IObjectStringConverter jsonc = new IObjectStringConverter(){
            Map<String, Object> conv = new HashMap<String, Object>();
            {
                this.conv.put("writeclass", false);
                this.conv.put("writeid", false);
            }

            public String convertObject(Object val, Object context) {
                byte[] data = AbstractRestPublishService.this.jsonser.encode(val, AbstractRestPublishService.this.component.getClassLoader(), null, this.conv);
                return new String(data, StandardCharsets.UTF_8);
            }
        };
        this.converters.add((Object)"application/json", (Object)jsonc);
        this.converters.add((Object)"*/*", (Object)jsonc);
        this.converters.add((Object)"text/event-stream", (Object)jsonc);
        IObjectStringConverter jjsonc = new IObjectStringConverter(){

            public String convertObject(Object val, Object context) {
                byte[] data = AbstractRestPublishService.this.jsonser.encode(val, AbstractRestPublishService.this.component.getClassLoader(), null, null);
                String ret = new String(data, StandardCharsets.UTF_8);
                return ret;
            }
        };
        this.converters.add((Object)"application/x.json+jadex", (Object)jjsonc);
        this.converters.add((Object)"*/*", (Object)jjsonc);
        IObjectStringConverter xmlc = new IObjectStringConverter(){

            public String convertObject(Object val, Object context) {
                byte[] data = JavaWriter.objectToByteArray((Object)val, (ClassLoader)AbstractRestPublishService.this.component.getClassLoader());
                return new String(data, StandardCharsets.UTF_8);
            }
        };
        this.converters.add((Object)"application/xml", (Object)xmlc);
        this.converters.add((Object)"*/*", (Object)xmlc);
        IObjectStringConverter tostrc = new IObjectStringConverter(){

            public String convertObject(Object val, Object context) {
                System.out.println("write response in plain text (toString)");
                return val.toString();
            }
        };
        this.converters.add((Object)"text/plain", (Object)tostrc);
        this.converters.add((Object)"*/*", (Object)tostrc);
        Long to = (Long)Starter.getPlatformValue((IComponentIdentifier)this.component.getId(), (String)Starter.DATA_DEFAULT_TIMEOUT);
        this.component.getLogger().info("Using default client timeout: " + to);
        return IFuture.DONE;
    }

    public Map<String, Object> getSession(HttpServletRequest request, boolean create) {
        String id = this.getSessionId(request);
        return this.getSession(id, create);
    }

    public Map<String, Object> getSession(String sessionid, boolean create) {
        if (sessionid == null && !create) {
            return null;
        }
        if (sessionid == null) {
            throw new RuntimeException("Session id null, no jadex cookie for session provided by client");
        }
        Map<String, Object> session = this.sessions.get(sessionid);
        if (session == null && create) {
            session = new HashMap<String, Object>();
            this.sessions.put(sessionid, session);
        }
        return session;
    }

    public String getSessionId(HttpServletRequest request) {
        String cookie = request.getHeader("cookie");
        String id = null;
        if (cookie != null) {
            StringTokenizer stok = new StringTokenizer(cookie, ";");
            while (stok.hasMoreTokens()) {
                int del;
                String c = stok.nextToken();
                String name = c.substring(0, del = c.indexOf("=")).trim();
                if (!"jadex".equals(name)) continue;
                id = c.substring(del + 1, c.length()).trim();
                break;
            }
        }
        return id;
    }

    public IFuture<Void> setLoginSecurity(boolean sec) {
        this.loginsec = sec;
        return IFuture.DONE;
    }

    public void addConverter(String[] mediatypes, IObjectStringConverter converter) {
        for (String mediatype : mediatypes) {
            this.converters.add((Object)mediatype, (Object)converter);
        }
    }

    public void removeConverter(String[] mediatypes, IObjectStringConverter converter) {
        for (String mediatype : mediatypes) {
            this.converters.removeObject((Object)mediatype, (Object)converter);
        }
    }

    public IFuture<Boolean> isSupported(String publishtype) {
        return "rs".equals(publishtype) ? IFuture.TRUE : IFuture.FALSE;
    }

    public void handleRequest(final IService service, final PathManager<MappingInfo> pm, final HttpServletRequest request, final HttpServletResponse response, final Object[] others) throws IOException, ServletException {
        final ResponseInfo ri = new ResponseInfo().setRequest(request).setResponse(response);
        if (!((IExecutionFeature)this.component.getFeature(IExecutionFeature.class)).isComponentThread()) {
            ((IExecutionFeature)this.component.getFeature(IExecutionFeature.class)).scheduleStep((IComponentStep)new IComponentStep<Void>(){

                public IFuture<Void> execute(IInternalAccess ia) {
                    try {
                        AbstractRestPublishService.this.handleRequest(service, pm, request, response, others);
                        return IFuture.DONE;
                    }
                    catch (Exception e) {
                        return new Future(e);
                    }
                }
            }).get();
            return;
        }
        this.pruneObsoleteConversations();
        final String sessionid = this.getSessionId(request);
        this.getAsyncContextInfo(request);
        String callid = request.getHeader(HEADER_JADEX_CALLID);
        ri.setCallid(callid);
        String alive = request.getHeader(HEADER_JADEX_ALIVE);
        String platformsecret = request.getHeader(HEADER_JADEX_LOGIN);
        String logout = request.getHeader(HEADER_JADEX_LOGOUT);
        String isloggedin = request.getHeader(HEADER_JADEX_ISLOGGEDIN);
        if (platformsecret != null) {
            this.login(request, platformsecret).then(ok -> {
                if (ok.booleanValue()) {
                    this.writeResponse(ri.setResult(Boolean.TRUE).setStatus(Response.Status.OK.getStatusCode()).setFinished(true));
                } else {
                    this.writeResponse(ri.setResult(Boolean.FALSE).setStatus(Response.Status.UNAUTHORIZED.getStatusCode()).setFinished(true));
                }
            }).catchEx(e -> this.writeResponse(ri.setResult(new SecurityException("Login failed")).setStatus(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).setFinished(true)));
        } else if (logout != null) {
            this.logout(request).then(ok -> this.writeResponse(ri.setResult(ok).setStatus(Response.Status.OK.getStatusCode()).setFinished(true))).catchEx(e -> this.writeResponse(ri.setResult(new SecurityException("Logout failed")).setStatus(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).setFinished(true)));
        } else if (isloggedin != null) {
            boolean ret = this.isLoggedIn(request);
            this.writeResponse(ri.setResult(ret).setStatus(Response.Status.OK.getStatusCode()).setFinished(true));
        } else if (alive != null) {
            ConversationInfo cinfo = this.conversationinfos.get(callid);
            if (cinfo != null) {
                boolean aliveb = Boolean.parseBoolean(alive);
                if (aliveb) {
                    cinfo.updateTimestamp();
                } else {
                    this.terminateConversation(cinfo, new RuntimeException("Terminated from client"), true);
                }
                this.writeResponse(ri.setStatus(Response.Status.OK.getStatusCode()).setFinished(true));
            } else {
                System.out.println("callid not found for alive: " + callid);
                this.writeResponse(ri.setStatus(Response.Status.NOT_FOUND.getStatusCode()).setFinished(true));
            }
        } else {
            String terminate = request.getHeader(HEADER_JADEX_TERMINATE);
            if (this.conversationinfos.containsKey(callid)) {
                ConversationInfo rinfo = this.conversationinfos.get(callid);
                if (terminate != null && rinfo.getFuture() instanceof ITerminableFuture) {
                    this.terminateConversation(rinfo, null, true);
                    this.writeResponse(ri.setStatus(Response.Status.OK.getStatusCode()).setFinished(true));
                } else if (terminate != null && rinfo.getFuture() == null) {
                    rinfo.setTerminated(true);
                    this.writeResponse(ri.setStatus(Response.Status.OK.getStatusCode()).setFinished(true));
                } else if (terminate != null) {
                    System.out.println("Future cannot be terminated: " + callid + " " + request);
                    this.writeResponse(ri.setStatus(Response.Status.NOT_FOUND.getStatusCode()).setFinished(true));
                }
            } else {
                String methodname = request.getPathInfo();
                if (methodname != null && methodname.startsWith("/")) {
                    methodname = methodname.substring(1);
                }
                if (methodname != null && methodname.endsWith("()")) {
                    methodname = methodname.substring(0, methodname.length() - 2);
                }
                String fmn = methodname;
                Collection<MappingInfo> mis = pm.getElementsForPath(methodname);
                List<Map<String, String>> bindings = mis.stream().map(x -> pm.getBindingsForPath(fmn)).collect(Collectors.toList());
                if (methodname.endsWith("jadex.js")) {
                    this.loadJadexJS().then(js -> this.writeResponse(ri.setStatus(Response.Status.OK.getStatusCode()).setFinished(true).setResult(js)));
                } else if (mis != null && mis.size() > 0) {
                    Tuple2<MappingInfo, Object[]> tup = this.mapParameters(request, mis, bindings);
                    final MappingInfo mi = (MappingInfo)tup.getFirstEntity();
                    Object[] params = (Object[])tup.getSecondEntity();
                    Map<String, String> callerinfos = this.extractCallerValues(request);
                    ServiceCall.getOrCreateNextInvocation().setProperty("webcallerinfos", callerinfos);
                    final String fcallid = callid == null ? SUtil.createUniqueId((String)fmn) : callid;
                    ServiceCall.getOrCreateNextInvocation().setProperty("callid", (Object)fcallid);
                    ri.setCallid(fcallid);
                    final ConversationInfo cinfo = new ConversationInfo(fcallid, sessionid);
                    this.conversationinfos.put(fcallid, cinfo);
                    BasicService.isUnrestricted((IServiceIdentifier)service.getServiceId(), (IInternalAccess)this.component, (Method)mi.getMethod()).then(unres -> {
                        try {
                            if (this.loginsec && !unres.booleanValue() && !this.isLoggedIn(request)) {
                                this.writeResponse(ri.setResult(new SecurityException("Access not allowed as not logged in")).setStatus(Response.Status.UNAUTHORIZED.getStatusCode()).setMappingInfo(mi).setFinished(true));
                            } else {
                                final Method method = mi.getMethod();
                                Object ret = method.invoke((Object)service, params);
                                ri.setMethod(method);
                                if (ret instanceof IFuture) {
                                    cinfo.setFuture((IFuture)ret);
                                }
                                if (cinfo.isTerminated()) {
                                    if (ret instanceof ITerminableFuture) {
                                        ((ITerminableFuture)ret).terminate();
                                    } else {
                                        System.out.println("Call cannot be terminated, future not terminable: " + method + " " + callid);
                                    }
                                }
                                if (ret instanceof IIntermediateFuture) {
                                    this.writeResponse(ri.setResult("sse").setStatus(Response.Status.OK.getStatusCode()).setMappingInfo(mi).setFinished(true));
                                    ((IIntermediateFuture)ret).addResultListener((IResultListener)((IExecutionFeature)this.component.getFeature(IExecutionFeature.class)).createResultListener((IIntermediateResultListener)new IIntermediateFutureCommandResultListener<Object>(){

                                        public void resultAvailable(Collection<Object> result) {
                                            for (Object res : result) {
                                                this.intermediateResultAvailable(res);
                                            }
                                            this.finished();
                                        }

                                        public void exceptionOccurred(Exception exception) {
                                            this.handleResult(null, exception, null, null);
                                        }

                                        public void intermediateResultAvailable(Object result) {
                                            this.handleResult(result, null, null, null);
                                        }

                                        public void commandAvailable(Object command) {
                                            this.handleResult(null, null, command, null);
                                        }

                                        public void finished() {
                                            this.handleResult(AbstractRestPublishService.FINISHED, null, null, null);
                                        }

                                        public void maxResultCountAvailable(int max) {
                                            this.handleResult(null, null, null, max);
                                        }

                                        protected void handleResult(Object result, Throwable exception, Object command, Integer max) {
                                            Map<String, Object> session;
                                            AsyncContext ctx;
                                            ResponseInfo ri = new ResponseInfo().setCallid(fcallid).setMappingInfo(mi).setMethod(method);
                                            if (AbstractRestPublishService.FINISHED.equals(result)) {
                                                ri.setFinished(true);
                                            } else if (exception != null) {
                                                ri.setException((Exception)exception);
                                                int rescode = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
                                                if (exception instanceof FutureTerminatedException) {
                                                    rescode = Response.Status.OK.getStatusCode();
                                                }
                                                ri.setStatus(rescode);
                                            } else if (command != null) {
                                                ri.setResult(command);
                                                ri.setStatus(202);
                                            } else {
                                                ri.setResult(result);
                                            }
                                            if (max != null) {
                                                ri.setMax(max);
                                            }
                                            if ((ctx = (AsyncContext)(session = AbstractRestPublishService.this.getSession(sessionid, true)).get("sse")) == null) {
                                                System.out.println("No sse connection, delay sending: " + result + " " + sessionid);
                                                AbstractRestPublishService.this.sseevents.add(AbstractRestPublishService.this.createSSEEvent(ri));
                                                return;
                                            }
                                            ri.setRequest((HttpServletRequest)ctx.getRequest());
                                            ri.setResponse((HttpServletResponse)ctx.getResponse());
                                            if (cinfo == null || !cinfo.isTerminated()) {
                                                AbstractRestPublishService.this.writeResponse(ri);
                                            }
                                        }
                                    }));
                                } else if (ret instanceof IFuture) {
                                    ((IFuture)ret).addResultListener(((IExecutionFeature)this.component.getFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<Object>(){

                                        public void resultAvailable(Object ret) {
                                            AbstractRestPublishService.this.writeResponse(ri.setResult(ret).setCallid(fcallid).setMappingInfo(mi).setFinished(true));
                                        }

                                        public void exceptionOccurred(Exception exception) {
                                            AbstractRestPublishService.this.writeResponse(ri.setException(exception).setStatus(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).setCallid(fcallid).setMappingInfo(mi).setFinished(true));
                                        }
                                    }));
                                } else {
                                    this.writeResponse(ri.setResult(ret).setStatus(202).setCallid(fcallid).setMappingInfo(mi).setFinished(true));
                                }
                            }
                        }
                        catch (Exception e) {
                            this.writeResponse(ri.setException(e).setStatus(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).setFinished(true));
                        }
                    });
                } else {
                    response.setCharacterEncoding("utf-8");
                    PrintWriter out = response.getWriter();
                    this.setCORSHeader(response);
                    this.setNoCachingHeader(response);
                    String ah = request.getHeader("Accept");
                    if (ah != null && ah.toLowerCase().indexOf("text/event-stream") != -1) {
                        String fsessionid = sessionid;
                        if (fsessionid == null) {
                            fsessionid = SUtil.createUniqueId();
                        }
                        this.getSession(fsessionid, true).put("sse", request.getAsyncContext());
                        response.addHeader(HEADER_JADEX_CALLID, ri.getCallid());
                        response.setContentType("text/event-stream; charset=utf-8");
                        response.setCharacterEncoding("UTF-8");
                        response.setStatus(200);
                        response.flushBuffer();
                        System.out.println("sse connection saved: " + request.getAsyncContext() + " " + fsessionid + " " + this.getSessionId(request));
                        this.sendDelayedSSEEvents(this.getSession(fsessionid, true));
                    } else {
                        response.setContentType("text/html; charset=utf-8");
                        String info = this.getServiceInfo(service, AbstractRestPublishService.getServletUrl(request), pm);
                        out.write(info);
                        response.setStatus(200);
                        this.complete(request, response);
                    }
                }
            }
        }
    }

    protected void pruneObsoleteConversations() {
        for (Map.Entry entry : this.conversationinfos.entrySet().toArray(new Map.Entry[this.conversationinfos.size()])) {
            if (System.currentTimeMillis() - ((ConversationInfo)entry.getValue()).getTimestamp() <= Starter.getDefaultTimeout((IComponentIdentifier)this.component.getId())) continue;
            this.terminateConversation((ConversationInfo)entry.getValue(), null, false);
        }
    }

    protected void terminateConversation(ConversationInfo cinfo, Exception ex, boolean clientterm) {
        cinfo.setTerminated(true);
        if (cinfo.getFuture() instanceof ITerminableFuture) {
            if (ex != null) {
                ((ITerminableFuture)cinfo.getFuture()).terminate(ex);
            } else {
                ((ITerminableFuture)cinfo.getFuture()).terminate();
            }
            this.conversationinfos.remove(cinfo.getCallId());
        } else if (clientterm) {
            System.out.println("WARNING: future cannot be terminated: " + cinfo + " " + cinfo.getFuture());
        }
    }

    protected void setCORSHeader(HttpServletResponse response) {
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.addHeader("Access-Control-Allow-Credentials", "true ");
        response.addHeader("Access-Control-Allow-Methods", "OPTIONS, GET, POST");
        response.addHeader("Access-Control-Allow-Headers", "Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");
    }

    protected void setNoCachingHeader(HttpServletResponse response) {
        response.addHeader("Cache-Control", "no-cache, no-store");
        response.addHeader("Expires", "-1");
    }

    protected void sendDelayedSSEEvents(Map<String, Object> session) {
        int cnt = this.sseevents.size();
        AsyncContext ctx = (AsyncContext)session.get("sse");
        if (ctx != null) {
            HttpServletResponse response = (HttpServletResponse)ctx.getResponse();
            response.setContentType("text/event-stream; charset=utf-8");
            response.setCharacterEncoding("UTF-8");
            response.setStatus(200);
            try {
                for (SSEEvent event : this.sseevents) {
                    if (this.conversationinfos.containsKey(event.getCallId())) {
                        String ret = this.createSSEJson(event);
                        response.getWriter().write(ret);
                        continue;
                    }
                    System.out.println("trashing delayed but obsolete event: " + event);
                }
                response.flushBuffer();
                this.sseevents.clear();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (cnt != 0 && this.sseevents.size() != 0) {
            System.out.println("sent delayed events: " + cnt + " " + this.sseevents.size());
        }
    }

    public abstract IFuture<Void> publishService(IServiceIdentifier var1, PublishInfo var2);

    public abstract Object getHttpServer(URI var1, PublishInfo var2);

    public IFuture<Boolean> login(HttpServletRequest request, String secret) {
        Future ret = new Future();
        ISecurityService ss = (ISecurityService)this.component.getLocalService(ISecurityService.class);
        ss.checkPlatformPassword(secret).then(ok -> {
            if (ok.booleanValue()) {
                this.getSession(request, true).put("loggedin", Boolean.TRUE);
            }
            ret.setResult(ok);
        }).catchEx(e -> ret.setResult((Object)Boolean.FALSE));
        return ret;
    }

    public IFuture<Boolean> logout(HttpServletRequest request) {
        boolean ret = true;
        if (this.getSession(request, false) != null) {
            this.getSession(request, false).remove("loggedin");
        } else {
            ret = false;
        }
        return new Future((Object)ret);
    }

    public boolean isLoggedIn(HttpServletRequest request) {
        Map<String, Object> sess = this.getSession(request, false);
        return sess != null && sess.get("loggedin") == Boolean.TRUE;
    }

    public IFuture<Boolean> isLoggedIn(String callid) {
        boolean ret = false;
        ConversationInfo cinfo = this.conversationinfos.get(callid);
        if (cinfo != null) {
            ret = this.getSession(cinfo.getSessionId(), false).get("loggedin") == Boolean.TRUE;
        }
        return new Future((Object)(ret ? Boolean.TRUE : Boolean.FALSE));
    }

    protected IAsyncContextInfo getAsyncContextInfo(HttpServletRequest request) {
        IAsyncContextInfo ret = (IAsyncContextInfo)request.getAttribute(ASYNC_CONTEXT_INFO);
        if (ret == null) {
            final AsyncContext rctx = request.startAsync();
            final boolean[] complete = new boolean[1];
            AsyncListener alis = new AsyncListener(){

                public void onTimeout(AsyncEvent arg0) throws IOException {
                }

                public void onStartAsync(AsyncEvent arg0) throws IOException {
                }

                public void onError(AsyncEvent arg0) throws IOException {
                }

                public void onComplete(AsyncEvent arg0) throws IOException {
                    complete[0] = true;
                }
            };
            rctx.addListener(alis);
            request.setAttribute(ASYNC_CONTEXT_INFO, (Object)new IAsyncContextInfo(){

                @Override
                public boolean isComplete() {
                    return complete[0];
                }

                @Override
                public AsyncContext getAsyncContext() {
                    return rctx;
                }
            });
        }
        return ret;
    }

    public static void addMimeTypes(Object cs, List<String> types) {
        String c;
        if (cs instanceof Collection) {
            for (String c2 : (Collection)cs) {
                if (types.contains(c2)) continue;
                types.add(c2);
            }
        } else if (cs instanceof String && !types.contains(c = (String)cs)) {
            types.add(c);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Tuple2<MappingInfo, Object[]> mapParameters(HttpServletRequest request, Collection<MappingInfo> mis, List<Map<String, String>> bindings) {
        try {
            int i;
            int i2;
            Tuple2 pinfo;
            Object b;
            Object[] targetparams = null;
            LinkedHashMap<String, Object> inparamsmap = new LinkedHashMap<String, Object>();
            String ct = request.getHeader("Content-Type");
            if (ct == null) {
                ct = request.getHeader("Accept");
            }
            if (request.getQueryString() != null) {
                inparamsmap.putAll(AbstractRestPublishService.splitQueryString(request.getQueryString()));
            }
            if (request.getContentType() != null && request.getContentType().startsWith("multipart/form-data") && request.getParts().size() > 0) {
                for (Part part : request.getParts()) {
                    byte[] data = SUtil.readStream((InputStream)part.getInputStream());
                    String mime = SUtil.guessContentTypeByBytes((byte[])data);
                    if (mime != null && (mime.indexOf("application") != -1 || mime.indexOf("image") != -1 || mime.indexOf("audio") != -1)) {
                        AbstractRestPublishService.addEntry(inparamsmap, part.getName(), data);
                        continue;
                    }
                    AbstractRestPublishService.addEntry(inparamsmap, part.getName(), new String(data, StandardCharsets.UTF_8));
                }
            }
            inparamsmap.remove(RANDOM);
            Object cs = inparamsmap.remove(CONTENTTYPE);
            MappingInfo mi = null;
            Map binding = null;
            if (mis.size() == 1) {
                mi = mis.iterator().next();
                binding = bindings.get(0);
            } else {
                Object[] res;
                ArrayList<Object[]> matches1 = new ArrayList<Object[]>();
                ArrayList<Object[]> matches2 = new ArrayList<Object[]>();
                int psize = inparamsmap.size();
                Iterator<Map<String, String>> bit = bindings.iterator();
                for (MappingInfo tst : mis) {
                    b = bit.next();
                    List<String> declaredparamnames = tst.getParameterNames();
                    Set paramnames = inparamsmap.keySet();
                    if (declaredparamnames.size() > 0 && declaredparamnames.containsAll(paramnames)) {
                        matches1.add(new Object[]{tst, b, paramnames.size()});
                    }
                    if (psize + b.size() != tst.getMethod().getParameterTypes().length) continue;
                    matches2.add(new Object[]{tst, b, psize + b.size()});
                }
                if (matches1.size() > 0) {
                    matches1.sort((x, y) -> (Integer)y[2] - (Integer)x[2]);
                    res = (Object[])matches1.get(0);
                    mi = (MappingInfo)res[0];
                    binding = (Map)res[1];
                } else if (matches2.size() > 0) {
                    matches2.sort((x, y) -> (Integer)y[2] - (Integer)x[2]);
                    res = (Object[])matches2.get(0);
                    mi = (MappingInfo)res[0];
                    binding = (Map)res[1];
                }
            }
            if (mi == null) {
                throw new RuntimeException("No method mapping found.");
            }
            if (binding != null && binding.size() > 0) {
                inparamsmap.putAll(binding);
            }
            Method method = mi.getMethod();
            Class<?>[] types = method.getParameterTypes();
            List<String> cl = AbstractRestPublishService.parseMimetypes(ct);
            AbstractRestPublishService.addMimeTypes(cs, cl);
            List<String> sr = new ArrayList<String>(mi.getConsumedMediaTypes());
            if (sr == null || sr.size() == 0) {
                sr = cl;
            } else {
                sr.retainAll(cl);
            }
            Tuple2<List<Tuple2<String, String>>, Map<String, Class<?>>> pinfos = this.getParameterInfos(method);
            boolean hasformparam = false;
            b = ((List)pinfos.getFirstEntity()).iterator();
            while (b.hasNext() && !(hasformparam = "form".equals((pinfo = (Tuple2)b.next()).getFirstEntity()))) {
            }
            byte[] bytes = null;
            try {
                ServletInputStream is = request.getInputStream();
                if (is != null) {
                    bytes = SUtil.readStream((InputStream)is);
                }
            }
            catch (Exception is) {
                // empty catch block
            }
            if (bytes != null && bytes.length > 0) {
                String mime = SUtil.guessContentTypeByBytes((byte[])bytes);
                if (mime != null && (mime.indexOf("application") != -1 || mime.indexOf("image") != -1 || mime.indexOf("audio") != -1)) {
                    AbstractRestPublishService.addEntry(inparamsmap, "body", bytes);
                } else {
                    String str = new String(bytes, SUtil.UTF8);
                    if (ct != null && ct.trim().startsWith("application/x-www-form-urlencoded")) {
                        Map<String, Object> vals = AbstractRestPublishService.splitQueryString(str);
                        inparamsmap.putAll(vals);
                    } else {
                        if (ct == null || !ct.trim().startsWith("application/json") && !ct.trim().startsWith("test/plain")) throw new RuntimeException("Content type not supported for body: " + ct);
                        if (types.length == 1) {
                            Object arg0;
                            if (str.trim().startsWith("{")) {
                                arg0 = AbstractRestPublishService.convertJsonValue(str, types[0], this.component.getClassLoader(), true);
                                inparamsmap.put("0", arg0);
                            } else if (str.trim().startsWith("\"")) {
                                arg0 = JsonTraverser.objectFromString((String)str, (ClassLoader)this.component.getClassLoader(), null, types[0], null);
                                inparamsmap.put("0", arg0);
                            }
                        } else {
                            JsonValue args = Json.parse((String)str);
                            if (args instanceof JsonArray) {
                                JsonArray array = (JsonArray)args;
                                for (i2 = 0; i2 < array.size(); ++i2) {
                                    inparamsmap.put("" + i2, AbstractRestPublishService.convertJsonValue(array.get(i2).toString(), types[i2], this.component.getClassLoader(), false));
                                }
                            } else if (args instanceof JsonObject) {
                                JsonObject jobj = (JsonObject)args;
                                if (hasformparam) {
                                    Map typesmap = (Map)pinfos.getSecondEntity();
                                    int[] i3 = new int[1];
                                    LinkedHashMap<String, Object> finparamsmap = inparamsmap;
                                    jobj.forEach(x -> {
                                        i[0] = i3[0] + 1;
                                        Class type = (Class)typesmap.get(x.getName());
                                        if (type != null) {
                                            Object val = AbstractRestPublishService.convertJsonValue(x.getValue().toString(), type, this.component.getClassLoader(), false);
                                            finparamsmap.put(x.getName(), val);
                                        } else {
                                            System.out.println("Ignoring argument with no type: " + x.getName());
                                        }
                                    });
                                }
                            }
                        }
                    }
                }
            }
            if (method.isAnnotationPresent(ParametersMapper.class)) {
                ParametersMapper mm = method.getAnnotation(ParametersMapper.class);
                if (!mm.automapping()) {
                    Class pclazz = mm.value().clazz();
                    Object mapper = !Object.class.equals((Object)pclazz) ? pclazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : SJavaParser.evaluateExpression((String)mm.value().value(), null);
                    if (mapper instanceof IValueMapper) {
                        mapper = new DefaultParameterMapper((IValueMapper)mapper);
                    }
                    if (mapper instanceof IParameterMapper) {
                        Object[] inparams = AbstractRestPublishService.generateInParameters(inparamsmap, pinfos, types);
                        for (i2 = 0; i2 < inparams.length; ++i2) {
                            if (!(inparams[i2] instanceof String)) continue;
                            inparams[i2] = this.convertParameter(sr, (String)inparams[i2], types[i2]);
                        }
                        targetparams = ((IParameterMapper)mapper).convertParameters(inparams, request);
                    } else {
                        if (!(mapper instanceof IParameterMapper2)) throw new RuntimeException("Mapper does not implement IParameterMapper/2");
                        targetparams = ((IParameterMapper2)mapper).convertParameters(inparamsmap, pinfos, request);
                    }
                } else {
                    Class<?>[] ts = method.getParameterTypes();
                    targetparams = new Object[ts.length];
                    if (ts.length == 1 && inparamsmap != null && SReflect.isSupertype(ts[0], Map.class)) {
                        targetparams[0] = inparamsmap;
                        ((Map)targetparams[0]).putAll(this.extractCallerValues(request));
                    }
                }
            }
            if (targetparams == null) {
                int i4;
                targetparams = new Object[types.length];
                Object[] inparams = AbstractRestPublishService.generateInParameters(inparamsmap, pinfos, types);
                for (i4 = 0; i4 < inparams.length; ++i4) {
                    inparams[i4] = this.convertParameter(sr, inparams[i4], types[i4]);
                }
                for (i4 = 0; i4 < targetparams.length && i4 < inparams.length; ++i4) {
                    targetparams[i4] = inparams[i4];
                }
            }
            for (i = 0; i < targetparams.length; ++i) {
                Object p = targetparams[i];
                Object v = null;
                if (p == null) continue;
                if (!SReflect.isSupertype(types[i], p.getClass())) {
                    if (types[i].isArray()) {
                        if (p instanceof Collection) {
                            Object ar;
                            Collection col = (Collection)p;
                            v = ar = Array.newInstance(types[i].getComponentType(), col.size());
                            Iterator it = col.iterator();
                            for (int j = 0; j < col.size(); ++j) {
                                Object a = this.convertParameter(sr, it.next(), types[i].getComponentType());
                                if (a == null) continue;
                                Array.set(ar, j, a);
                            }
                        } else if (SReflect.isSupertype(types[i].getComponentType(), p.getClass())) {
                            v = Array.newInstance(types[i].getComponentType(), 1);
                            Array.set(targetparams[i], 0, p);
                        }
                    } else {
                        v = this.convertParameter(sr, p, types[i]);
                    }
                }
                if (v == null) continue;
                targetparams[i] = v;
            }
            for (i = 0; i < targetparams.length; ++i) {
                if (targetparams[i] != null) continue;
                if (types[i].equals(Boolean.TYPE)) {
                    targetparams[i] = Boolean.FALSE;
                    continue;
                }
                if (types[i].equals(Character.TYPE)) {
                    targetparams[i] = Character.valueOf('\u0000');
                    continue;
                }
                if (SReflect.getWrappedType(types[i]) == types[i]) continue;
                targetparams[i] = 0;
            }
            return new Tuple2((Object)mi, (Object)targetparams);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static Object[] generateInParameters(Map<String, Object> inparamsmap, Tuple2<List<Tuple2<String, String>>, Map<String, Class<?>>> pinfos, Class<?>[] types) {
        Object[] inparams = new Object[types.length];
        ArrayList<Integer> todo = new ArrayList<Integer>();
        for (int i = 0; i < ((List)pinfos.getFirstEntity()).size(); ++i) {
            Tuple2 pinfo = (Tuple2)((List)pinfos.getFirstEntity()).get(i);
            if ("name".equals(pinfo.getFirstEntity())) {
                inparams[i] = inparamsmap.remove(pinfo.getSecondEntity());
                continue;
            }
            if ("path".equals(pinfo.getFirstEntity())) {
                inparams[i] = inparamsmap.remove(pinfo.getSecondEntity());
                continue;
            }
            if ("query".equals(pinfo.getFirstEntity())) {
                inparams[i] = inparamsmap.remove(pinfo.getSecondEntity());
                continue;
            }
            if ("form".equals(pinfo.getFirstEntity())) {
                inparams[i] = inparamsmap.remove(pinfo.getSecondEntity());
                continue;
            }
            todo.add(i);
        }
        Iterator<String> innames = inparamsmap.keySet().iterator();
        Iterator iterator = todo.iterator();
        while (iterator.hasNext()) {
            String inname;
            int i = (Integer)iterator.next();
            Tuple2 pinfo = (Tuple2)((List)pinfos.getFirstEntity()).get(i);
            String string = inname = innames.hasNext() ? innames.next() : null;
            if (!"no".equals(pinfo.getFirstEntity()) || inname == null || inparamsmap.get(inname) == null) continue;
            inparams[i] = inparamsmap.get(inname);
        }
        return inparams;
    }

    public static Object convertJsonValue(String val, Class<?> type, ClassLoader cl, boolean tomap) {
        List procs = null;
        if (tomap && SReflect.isSupertype(Map.class, type)) {
            procs = JsonTraverser.nestedreadprocs;
        }
        return JsonTraverser.objectFromString((String)val.toString(), (ClassLoader)cl, null, type, (List)procs);
    }

    public Object convertParameter(Object val, Class<?> target) {
        Object ret = null;
        ISerializationServices ser = SerializationServices.getSerializationServices((IComponentIdentifier)this.component.getId().getRoot());
        IStringConverter conv = (IStringConverter)ser.getStringConverters().get("basic");
        if (val != null && SReflect.isSupertype(target, val.getClass())) {
            ret = val;
        } else if (val instanceof String && ((String)val).length() > 0 && conv.isSupportedType(target)) {
            try {
                ret = conv.convertString((String)val, target, this.component.getClassLoader(), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    protected Object convertParameter(List<String> sr, Object val, Class<?> targetclazz) {
        Object ret = val;
        boolean done = false;
        if (val instanceof String) {
            if (sr != null && sr.contains("application/json")) {
                try {
                    ret = this.jsonser.convertString((String)val, targetclazz, this.component.getClassLoader(), null);
                    done = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!done && sr != null && sr.contains("application/xml")) {
                try {
                    ret = this.binser.decode(((String)val).getBytes(StandardCharsets.UTF_8), this.component.getClassLoader(), null, null, null);
                    done = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!done) {
            ret = this.convertParameter(val, targetclazz);
        }
        return ret;
    }

    protected Object mapResult(Method method, Object ret) {
        if (method.isAnnotationPresent(ResultMapper.class)) {
            try {
                ResultMapper mm = method.getAnnotation(ResultMapper.class);
                Class pclazz = mm.value().clazz();
                IValueMapper mapper = !Object.class.equals((Object)pclazz) ? (IValueMapper)pclazz.newInstance() : (IValueMapper)SJavaParser.evaluateExpression((String)mm.value().value(), null);
                ret = mapper.convertValue(ret);
            }
            catch (Exception e) {
                SUtil.throwUnchecked((Throwable)e);
            }
        }
        return ret;
    }

    protected void writeResponse(ResponseInfo ri) {
        if (this.isComplete(ri.getRequest(), ri.getResponse())) {
            return;
        }
        List<String> sr = this.writeResponseHeader(ri);
        this.writeResponseContent(ri.setResultTypes(sr));
        if (ri.isFinished() && ri.getCallid() != null && this.conversationinfos.get(ri.getCallid()) != null && !this.conversationinfos.get(ri.getCallid()).isIntermediateFuture()) {
            this.conversationinfos.remove(ri.getCallid());
        }
    }

    protected List<String> writeResponseHeader(ResponseInfo ri) {
        List<String> sr = ri.getResultTypes();
        if (sr == null) {
            sr = new ArrayList<String>();
        }
        if (ri.getResult() instanceof Response) {
            Response resp = (Response)ri.getResult();
            ri.getResponse().setStatus(resp.getStatus());
            for (String name : resp.getStringHeaders().keySet()) {
                ri.getResponse().addHeader(name, resp.getHeaderString(name));
            }
            ri.setResult(resp.getEntity());
            if (resp.getMediaType() != null) {
                sr.add(resp.getMediaType().toString());
            }
        } else {
            List<String> pmt;
            if (ri.getStatus() > 0) {
                ri.getResponse().setStatus(ri.getStatus());
            }
            ArrayList<String> cl = new ArrayList<String>();
            String acc = ri.getRequest().getParameter(ACCEPT);
            if (acc != null) {
                AbstractRestPublishService.addMimeTypes(acc, cl);
            }
            String mts = ri.getRequest().getHeader("accept");
            cl.addAll(AbstractRestPublishService.parseMimetypes(mts));
            List<String> list = pmt = ri.getMappingInfo() == null ? null : ri.getMappingInfo().getProducedMediaTypes();
            if (pmt != null) {
                sr.addAll(pmt);
            }
            if (sr == null || sr.size() == 0) {
                sr = cl;
            } else {
                sr.retainAll(cl);
            }
            if (ri.getCallid() != null) {
                if (ri.isFinished()) {
                    ri.getResponse().addHeader(HEADER_JADEX_CALLFINISHED, ri.getCallid());
                } else {
                    ri.getResponse().addHeader(HEADER_JADEX_CALLID, ri.getCallid());
                }
                if (ri.getMax() != null) {
                    ri.getResponse().addHeader(HEADER_JADEX_MAX, "" + ri.getMax());
                }
            }
            this.setCORSHeader(ri.getResponse());
            this.setNoCachingHeader(ri.getResponse());
            if (Boolean.TRUE.equals(Starter.getPlatformArgument((IComponentIdentifier)this.component.getId(), (String)"showversion"))) {
                ri.getResponse().addHeader(HEADER_JADEX_VERSION, VersionInfo.getInstance().toString());
            }
        }
        return sr;
    }

    protected void writeResponseContent(ResponseInfo ri) {
        if (ri.getException() != null) {
            System.out.println("ex: " + ri.getException());
        }
        try {
            if (ri.isSSERequest() || (IAsyncContextInfo)ri.getRequest().getAttribute(ASYNC_CONTEXT_INFO) == null || ((IAsyncContextInfo)ri.getRequest().getAttribute(ASYNC_CONTEXT_INFO)).isComplete()) {
                ri.getResponse().setHeader("Content-Type", "text/event-stream");
                ri.getResponse().setHeader("Connection", "keep-alive");
                SSEEvent event = this.createSSEEvent(ri);
                if (!this.conversationinfos.containsKey(event.getCallId())) {
                    System.out.println("trashing obsolete event: " + event);
                    return;
                }
                PrintWriter out = ri.getResponse().getWriter();
                String ret = this.createSSEJson(event);
                out.write(ret);
                ri.getResponse().getWriter().flush();
                ri.getResponse().flushBuffer();
            } else if (ri.getResult() instanceof byte[]) {
                if (ri.getResponse().getHeader("Content-Type") == null && ri.getResultTypes() != null && ri.getResultTypes().size() > 0) {
                    ri.getResponse().setHeader("Content-Type", ri.getResultTypes().get(0));
                }
                ri.getResponse().getOutputStream().write((byte[])ri.getResult());
                this.complete(ri.getRequest(), ri.getResponse());
            } else {
                Object res;
                Object object = res = ri.getException() != null ? ri.getException() : ri.getResult();
                if (res != null) {
                    String ret = null;
                    Object mt = null;
                    if (ri.getResultTypes() != null) {
                        for (String mediatype : ri.getResultTypes()) {
                            Collection convs = this.converters.get((Object)(mediatype = mediatype.trim()));
                            if (convs == null || convs.size() <= 0) continue;
                            mt = mediatype;
                            Object input = res instanceof Response ? ((Response)res).getEntity() : res;
                            ret = ((IObjectStringConverter)convs.iterator().next()).convertObject(input, null);
                            break;
                        }
                    }
                    if (mt != null) {
                        if (!((String)mt).contains("charset")) {
                            mt = (String)mt + "; charset=utf-8";
                        }
                        if (ri.getResponse().getHeader("Content-Type") == null) {
                            ri.getResponse().setHeader("Content-Type", (String)mt);
                        }
                        ri.getResponse().getWriter().write(ret);
                    } else {
                        if (ri.getResponse().getHeader("Content-Type") == null) {
                            ri.getResponse().setHeader("Content-Type", "text/plain; charset=utf-8");
                        }
                        if (!(res instanceof String) && !(res instanceof Response)) {
                            System.out.println("cannot convert result, writing as string: " + res);
                        }
                        ret = res instanceof Response ? "" + ((Response)res).getEntity() : res.toString();
                        ri.getResponse().getWriter().write(ret);
                    }
                }
                this.complete(ri.getRequest(), ri.getResponse());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected SSEEvent createSSEEvent(ResponseInfo ri) {
        if (ri.getException() != null) {
            Object ex = this.mapResult(ri.getMethod(), ri.getException());
            return this.createSSEEvent(ex, ri.isFinished(), ri.getCallid(), ri.getMax(), ri.getException().getClass().getName());
        }
        Object result = this.mapResult(ri.getMethod(), ri.getResult());
        result = result instanceof Response ? ((Response)result).getEntity() : result;
        return this.createSSEEvent(ri.getResult(), ri.isFinished(), ri.getCallid(), ri.getMax(), null);
    }

    protected SSEEvent createSSEEvent(Object result, boolean finished, String callid, Integer max, String exceptiontype) {
        SSEEvent event = new SSEEvent();
        event.setData(result).setFinished(finished).setCallId(callid).setMax(max).setExecptionType(exceptiontype);
        Collection convs = this.converters.get((Object)"text/event-stream");
        Object ret = ((IObjectStringConverter)convs.iterator().next()).convertObject((Object)event, null);
        ret = "id: " + callid + "\ndata: " + (String)ret + "\n\n";
        return event;
    }

    protected String createSSEJson(SSEEvent event) {
        Collection convs = this.converters.get((Object)"text/event-stream");
        Object ret = ((IObjectStringConverter)convs.iterator().next()).convertObject((Object)event, null);
        ret = "id: " + event.getCallId() + "\ndata: " + (String)ret + "\n\n";
        return ret;
    }

    public static long getRequestTimeout(HttpServletRequest request) {
        Long to;
        long ret = -1L;
        String tostr = request.getHeader(HEADER_JADEX_CLIENTTIMEOUT);
        Long l = to = tostr != null ? Long.valueOf(tostr) : null;
        if (to != null) {
            ret = (long)((double)to.longValue() * 0.9);
        }
        return ret;
    }

    public static List<String> parseMimetypes(String mts) {
        ArrayList<String> mimetypes = new ArrayList<String>();
        if (mts != null) {
            StringTokenizer stok = new StringTokenizer(mts, ",");
            while (stok.hasMoreTokens()) {
                String tok = stok.nextToken();
                StringTokenizer substok = new StringTokenizer(tok, ";");
                String mt = substok.nextToken();
                Object charset = null;
                while (substok.hasMoreTokens()) {
                    String subtok = substok.nextToken().trim();
                    if (!subtok.startsWith("charset")) continue;
                    charset = "; " + subtok;
                    break;
                }
                if (mimetypes == null) {
                    mimetypes = new ArrayList();
                }
                mimetypes.add(mt + (String)(charset != null ? charset : ""));
            }
        }
        return mimetypes;
    }

    public static Map<String, Object> splitQueryString(String query) throws Exception {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        String[] pairs = query.split("&");
        HashMap<String, TreeSet<Tuple2<Integer, String>>> compacted = new HashMap<String, TreeSet<Tuple2<Integer, String>>>();
        for (String pair : pairs) {
            int idx = pair.indexOf("=");
            String key = URLDecoder.decode(pair.substring(0, idx), "UTF-8");
            String val = URLDecoder.decode(pair.substring(idx + 1), "UTF-8");
            idx = key.indexOf("_");
            boolean added = false;
            if (idx != -1) {
                String p = key.substring(idx + 1);
                try {
                    int pos = Integer.parseInt(p);
                    String ckey = key.substring(0, idx);
                    TreeSet<Tuple2<Integer, String>> col = (TreeSet<Tuple2<Integer, String>>)compacted.get(ckey);
                    if (col == null) {
                        col = new TreeSet<Tuple2<Integer, String>>(new Comparator<Tuple2<Integer, String>>(){

                            @Override
                            public int compare(Tuple2<Integer, String> o1, Tuple2<Integer, String> o2) {
                                return (Integer)o1.getFirstEntity() - (Integer)o2.getFirstEntity();
                            }
                        });
                        compacted.put(ckey, col);
                    }
                    added = true;
                    col.add((Tuple2<Integer, String>)new Tuple2((Object)pos, (Object)val));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (added) continue;
            AbstractRestPublishService.addEntry(ret, key, val);
        }
        compacted.entrySet().stream().forEach(e -> {
            TreeSet vals = (TreeSet)e.getValue();
            Tuple2 lastval = (Tuple2)vals.last();
            String[] res = new String[(Integer)lastval.getFirstEntity() + 1];
            vals.stream().forEach(t -> {
                res[((Integer)t.getFirstEntity()).intValue()] = (String)t.getSecondEntity();
            });
            List<String> data = Arrays.asList(res);
            AbstractRestPublishService.addEntry(ret, (String)e.getKey(), data);
        });
        return ret;
    }

    public static void main(String[] args) throws Exception {
        Integer[] vals = new Integer[]{3, 5, 6, 2, 9, 1};
        List<Integer> vl = Arrays.asList(vals);
        vl.sort((x, y) -> y - x);
        System.out.println(vl);
    }

    protected static void addEntry(Map<String, Object> ret, String key, Object val) {
        if (ret.containsKey(key)) {
            Object v = ret.get(key);
            if (v instanceof String) {
                ArrayList<String> col = new ArrayList<String>();
                col.add((String)v);
                if (val instanceof Collection) {
                    col.addAll((Collection)val);
                } else {
                    col.add((String)val);
                }
                ret.put(key, col);
            } else if (v instanceof Collection) {
                Collection col = (Collection)v;
                if (val instanceof Collection) {
                    col.addAll((Collection)val);
                } else {
                    col.add((String)val);
                }
            }
        } else {
            ret.put(key, val);
        }
    }

    public IFuture<PathManager<MappingInfo>> evaluateMapping(final IServiceIdentifier sid, final PublishInfo pi) {
        Future ret = new Future();
        IComponentIdentifier cid = sid.getProviderId();
        IExternalAccess ea = this.component.getExternalAccess(cid);
        ea.scheduleStep((IComponentStep)new IComponentStep<PathManager<MappingInfo>>(){

            public IFuture<PathManager<MappingInfo>> execute(IInternalAccess ia) {
                Class mapcl;
                Class clazz = mapcl = pi.getMapping() == null ? null : pi.getMapping().getType(ia.getClassLoader());
                if (mapcl == null) {
                    mapcl = sid.getServiceType().getType(ia.getClassLoader());
                }
                PathManager<MappingInfo> ret = new PathManager<MappingInfo>();
                PathManager<MappingInfo> natret = new PathManager<MappingInfo>();
                for (Method m : SReflect.getAllMethods((Class)mapcl)) {
                    MappingInfo mi = new MappingInfo();
                    if (m.isAnnotationPresent(GET.class)) {
                        mi.setHttpMethod(MappingInfo.HttpMethod.GET);
                    } else if (m.isAnnotationPresent(POST.class)) {
                        mi.setHttpMethod(MappingInfo.HttpMethod.POST);
                    } else if (m.isAnnotationPresent(PUT.class)) {
                        mi.setHttpMethod(MappingInfo.HttpMethod.PUT);
                    } else if (m.isAnnotationPresent(DELETE.class)) {
                        mi.setHttpMethod(MappingInfo.HttpMethod.DELETE);
                    } else if (m.isAnnotationPresent(OPTIONS.class)) {
                        mi.setHttpMethod(MappingInfo.HttpMethod.OPTIONS);
                    } else if (m.isAnnotationPresent(HEAD.class)) {
                        mi.setHttpMethod(MappingInfo.HttpMethod.HEAD);
                    }
                    if (m.isAnnotationPresent(Path.class)) {
                        Path path = m.getAnnotation(Path.class);
                        mi.setPath(path.value());
                    } else if (!mi.isEmpty()) {
                        mi.setPath(m.getName());
                    }
                    if (!mi.isEmpty()) {
                        mi.setMethod(m);
                        ret.addPathElement(mi.getPath(), mi);
                    }
                    MappingInfo mi2 = new MappingInfo(null, m, m.getName());
                    natret.addPathElement(m.getName(), mi2);
                }
                return new Future(ret.size() > 0 ? ret : natret);
            }
        }).addResultListener((IResultListener)new DelegationResultListener(ret));
        return ret;
    }

    public static String getServletUrl(HttpServletRequest req) {
        StringBuffer url = new StringBuffer(AbstractRestPublishService.getServletHost(req));
        String cp = req.getContextPath();
        String serp = req.getServletPath();
        if (cp != null) {
            url.append(cp);
        }
        if (serp != null) {
            url.append(serp);
        }
        return url.toString();
    }

    public static String getServletHost(HttpServletRequest req) {
        StringBuffer url = new StringBuffer();
        String scheme = req.getScheme();
        int port = req.getServerPort();
        url.append(scheme);
        url.append("://");
        url.append(req.getServerName());
        if ("http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443) {
            url.append(':');
            url.append(req.getServerPort());
        }
        return url.toString();
    }

    public String getServiceInfo(Object service, String baseuri, PathManager<MappingInfo> mappings) {
        StringBuffer ret = new StringBuffer();
        try {
            String functionsjs = this.loadFunctionJS();
            String stylecss = this.loadStyleCSS();
            ret.append("<html>");
            ret.append("\n");
            ret.append("<head>");
            ret.append("\n");
            ret.append(stylecss);
            ret.append("\n");
            ret.append(functionsjs);
            ret.append("\n");
            ret.append("</head>");
            ret.append("\n");
            ret.append("<body>");
            ret.append("\n");
            ret.append("<div class=\"header\">");
            ret.append("\n");
            ret.append("<h1>");
            String ifacename = ((IService)service).getServiceId().getServiceType().getTypeName();
            ret.append(SReflect.getUnqualifiedTypeName((String)ifacename));
            ret.append("</h1>");
            ret.append("\n");
            ret.append("</div>");
            ret.append("\n");
            ret.append("<div class=\"middle\">");
            ret.append("\n");
            if (mappings != null) {
                for (MappingInfo mi : mappings.getElements()) {
                    int j;
                    int j2;
                    Method method = mi.getMethod();
                    MappingInfo.HttpMethod restmethod = mi.getHttpMethod() != null ? mi.getHttpMethod() : this.guessRestType(method);
                    String path = mi.getPath() != null ? mi.getPath() : method.getName();
                    List<String> consumed = mi.getConsumedMediaTypes();
                    List<String> produced = mi.getProducedMediaTypes();
                    if (consumed == null) {
                        consumed = PARAMETER_MEDIATYPES;
                    }
                    if (produced == null) {
                        produced = PARAMETER_MEDIATYPES;
                    }
                    Class<?>[] ptypes = method.getParameterTypes();
                    String[] pnames = new String[ptypes.length];
                    Annotation[][] pannos = method.getParameterAnnotations();
                    for (int p = 0; p < ptypes.length; ++p) {
                        for (int a = 0; a < pannos[p].length; ++a) {
                            if (!(pannos[p][a] instanceof ParameterInfo)) continue;
                            pnames[p] = ((ParameterInfo)pannos[p][a]).value();
                        }
                        if (pnames[p] != null) continue;
                        pnames[p] = "arg" + p;
                    }
                    ret.append("<div class=\"method\">");
                    ret.append("\n");
                    ret.append("<div class=\"methodname\">");
                    ret.append(method.getName());
                    ret.append("(");
                    if (ptypes != null && ptypes.length > 0) {
                        for (j2 = 0; j2 < ptypes.length; ++j2) {
                            ret.append(SReflect.getUnqualifiedClassName(ptypes[j2]));
                            ret.append(" ");
                            ret.append(pnames[j2]);
                            if (j2 + 1 >= ptypes.length) continue;
                            ret.append(", ");
                        }
                    }
                    ret.append(")");
                    ret.append("</div>");
                    ret.append("\n");
                    ret.append("<div class=\"restproperties\">");
                    ret.append("<div id=\"httpmethod\">").append((Object)restmethod).append("</div>");
                    if (consumed != null && consumed.size() > 0) {
                        ret.append("<i>");
                        if (consumed != PARAMETER_MEDIATYPES) {
                            ret.append("Consumes: ");
                        } else {
                            ret.append("Consumes [not declared by the service]: ");
                        }
                        ret.append("</i>");
                        for (j2 = 0; j2 < consumed.size(); ++j2) {
                            ret.append(consumed.get(j2));
                            if (j2 + 1 >= consumed.size()) continue;
                            ret.append(" ,");
                        }
                        ret.append(" ");
                    }
                    if (produced != null && produced.size() > 0) {
                        ret.append("<i>");
                        if (produced != PARAMETER_MEDIATYPES) {
                            ret.append("Produces: ");
                        } else {
                            ret.append("Produces [not declared by the service]: ");
                        }
                        ret.append("</i>");
                        for (j2 = 0; j2 < produced.size(); ++j2) {
                            ret.append(produced.get(j2));
                            if (j2 + 1 >= produced.size()) continue;
                            ret.append(" ,");
                        }
                        ret.append(" ");
                    }
                    ret.append("</div>");
                    ret.append("\n");
                    String link = path;
                    ret.append("<div class=\"servicelink\">");
                    ret.append(link);
                    ret.append("</div>");
                    ret.append("\n");
                    ret.append("<form class=\"arguments\" action=\"").append(link).append("\" method=\"").append((Object)restmethod).append("\" enctype=\"multipart/form-data\" ");
                    ret.append("onSubmit=\"return extract(this)\"");
                    ret.append(">");
                    ret.append("\n");
                    for (j = 0; j < ptypes.length; ++j) {
                        ret.append(pnames[j]).append(": ");
                        ret.append("<input name=\"").append(pnames[j]).append("\" type=\"text\" />");
                    }
                    ret.append("<select name=\"mediatype\">");
                    if (consumed != null && consumed.size() > 0) {
                        for (j = 0; j < consumed.size(); ++j) {
                            if ("multipart/form-data".equals(consumed.get(j)) || "application/x-www-form-urlencoded".equals(consumed.get(j))) continue;
                            ret.append("<option>").append(consumed.get(j)).append("</option>");
                        }
                    } else {
                        ret.append("<option>").append("text/plain").append("</option>");
                    }
                    ret.append("</select>");
                    ret.append("\n");
                    ret.append("<input type=\"submit\" value=\"invoke\"/>");
                    ret.append("</form>");
                    ret.append("\n");
                    ret.append("</div>");
                    ret.append("\n");
                }
            }
            ret.append("</div>");
            ret.append("\n");
            ret.append("<div id=\"result\"></div>");
            ret.append("<div class=\"powered\"> <span class=\"powered\">powered by</span> <span class=\"jadex\">");
            if (Boolean.TRUE.equals(Starter.getPlatformArgument((IComponentIdentifier)this.component.getId(), (String)"showversion"))) {
                ret.append(VersionInfo.getInstance());
            } else {
                ret.append("Jadex Active Components");
            }
            ret.append("</span> <a class=\"jadexurl\" href=\"http://www.activecomponents.org\">http://www.activecomponents.org</a> </div>\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        ret.append("</body>\n</html>\n");
        return ret.toString();
    }

    public String loadFunctionJS() {
        String functionsjs;
        try (Scanner sc = null;){
            InputStream is = SUtil.getResource0((String)"jadex/extension/rs/publish/functions.js", (ClassLoader)this.component.getClassLoader());
            sc = new Scanner(is);
            functionsjs = sc.useDelimiter("\\A").next();
        }
        return functionsjs;
    }

    public String loadStyleCSS() {
        String stylecss;
        try (Scanner sc = null;){
            InputStream is = SUtil.getResource0((String)"jadex/extension/rs/publish/style.css", (ClassLoader)this.component.getClassLoader());
            sc = new Scanner(is);
            stylecss = sc.useDelimiter("\\A").next();
            String stripes = SUtil.loadBinary((String)"jadex/extension/rs/publish/jadex_stripes.png");
            stylecss = stylecss.replace("$stripes", stripes);
        }
        return stylecss;
    }

    public MappingInfo.HttpMethod guessRestType(Method method) {
        boolean hasret;
        MappingInfo.HttpMethod ret = MappingInfo.HttpMethod.GET;
        Class rettype = SReflect.unwrapGenericType((Type)method.getGenericReturnType());
        Class<?>[] paramtypes = method.getParameterTypes();
        boolean hasparams = paramtypes.length > 0;
        boolean bl = hasret = rettype != null && !rettype.equals(Void.class) && !rettype.equals(Void.TYPE);
        if (hasret && hasparams) {
            ret = this.hasStringConvertableParameters(method, rettype, paramtypes) ? MappingInfo.HttpMethod.GET : MappingInfo.HttpMethod.POST;
        }
        return ret;
    }

    public boolean hasStringConvertableParameters(Method method, Class<?> rettype, Class<?>[] paramtypes) {
        boolean ret = true;
        for (int i = 0; i < paramtypes.length && ret; ++i) {
            ret = SReflect.isStringConvertableType(paramtypes[i]);
        }
        return ret;
    }

    protected void complete(HttpServletRequest request, HttpServletResponse response) {
        if (request.isAsyncStarted() && request.getAsyncContext() != null && !this.isComplete(request, response)) {
            try {
                request.getAsyncContext().complete();
            }
            catch (Exception e) {
                System.out.println("Exception in context complete(): " + e);
            }
        }
    }

    protected boolean isComplete(HttpServletRequest request, HttpServletResponse response) {
        IAsyncContextInfo cinfo = (IAsyncContextInfo)request.getAttribute(ASYNC_CONTEXT_INFO);
        if (cinfo == null) {
            System.out.println("warning, async context info is null: " + request);
        }
        return cinfo != null ? cinfo.isComplete() : response.isCommitted();
    }

    public IFuture<byte[]> loadJadexJS() {
        try {
            InputStream is = SUtil.getResource0((String)"jadex/extension/rs/publish/jadex.js", (ClassLoader)this.component.getClassLoader());
            byte[] data = SUtil.readStream((InputStream)is);
            return new Future((Object)data);
        }
        catch (Exception e) {
            return new Future(e);
        }
    }

    public Tuple2<List<Tuple2<String, String>>, Map<String, Class<?>>> getParameterInfos(Method method) {
        ArrayList<Tuple2> ret = new ArrayList<Tuple2>();
        HashMap targettypes = new HashMap();
        Annotation[][] anns = method.getParameterAnnotations();
        Class<?>[] types = method.getParameterTypes();
        for (int i = 0; i < anns.length; ++i) {
            boolean done = false;
            for (Annotation ann : anns[i]) {
                QueryParam qp;
                String name;
                if (ann instanceof PathParam) {
                    PathParam pp = (PathParam)ann;
                    name = pp.value();
                    ret.add(new Tuple2((Object)"path", (Object)name));
                    targettypes.put(name, types[i]);
                    done = true;
                    break;
                }
                if (ann instanceof QueryParam) {
                    qp = (QueryParam)ann;
                    name = qp.value();
                    ret.add(new Tuple2((Object)"query", (Object)name));
                    targettypes.put(name, types[i]);
                    done = true;
                    break;
                }
                if (ann instanceof FormParam) {
                    qp = (FormParam)ann;
                    name = qp.value();
                    ret.add(new Tuple2((Object)"form", (Object)name));
                    targettypes.put(name, types[i]);
                    done = true;
                    break;
                }
                if (!(ann instanceof ParameterInfo)) continue;
                qp = (ParameterInfo)ann;
                name = qp.value();
                ret.add(new Tuple2((Object)"name", (Object)name));
                targettypes.put(name, types[i]);
                done = true;
                break;
            }
            if (done) continue;
            String name = "" + i;
            ret.add(new Tuple2((Object)"no", (Object)name));
            targettypes.put(name, types[i]);
        }
        return new Tuple2(ret, targettypes);
    }

    public Map<String, String> extractCallerValues(Object request) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (request != null && request instanceof HttpServletRequest) {
            HttpServletRequest sreq = (HttpServletRequest)request;
            ret.put("ip", sreq.getRemoteAddr());
            ret.put("browser", sreq.getHeader("User-Agent"));
            ret.put("querystring", sreq.getQueryString());
        }
        return ret;
    }

    public String getCleanPublishId(String id) {
        return id != null ? id.replace("[", "").replace("]", "") : null;
    }

    public static class SSEEvent {
        protected Object data;
        protected String execptiontype;
        protected Integer max;
        protected boolean finished;
        protected String callid;

        public Object getData() {
            return this.data;
        }

        public SSEEvent setData(Object data) {
            this.data = data;
            return this;
        }

        public Integer getMax() {
            return this.max;
        }

        public SSEEvent setMax(Integer max) {
            this.max = max;
            return this;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public SSEEvent setFinished(boolean finished) {
            this.finished = finished;
            return this;
        }

        public String getCallId() {
            return this.callid;
        }

        public SSEEvent setCallId(String callid) {
            this.callid = callid;
            return this;
        }

        public String getExecptionType() {
            return this.execptiontype;
        }

        public SSEEvent setExecptionType(String execptiontype) {
            this.execptiontype = execptiontype;
            return this;
        }

        public String toString() {
            return "SSEEvent [data=" + this.data + ", max=" + this.max + ", finished=" + this.finished + ", callid=" + this.callid + "]";
        }
    }

    public class ResponseInfo {
        protected Object result;
        protected Exception exception;
        protected Method method;
        protected int status;
        protected String callid;
        protected MappingInfo mi;
        protected HttpServletRequest request;
        protected HttpServletResponse response;
        protected boolean finished;
        protected Integer max;
        protected List<String> resulttypes;
        protected boolean sse;

        public ResponseInfo() {
        }

        public ResponseInfo(Object result) {
            this.result = result;
        }

        public Object getResult() {
            return this.result;
        }

        public ResponseInfo setResult(Object result) {
            this.result = result;
            return this;
        }

        public Exception getException() {
            return this.exception;
        }

        public ResponseInfo setException(Exception exception) {
            this.exception = exception;
            return this;
        }

        public int getStatus() {
            return this.status;
        }

        public ResponseInfo setStatus(int status) {
            this.status = status;
            return this;
        }

        public String getCallid() {
            return this.callid;
        }

        public ResponseInfo setCallid(String callid) {
            this.callid = callid;
            return this;
        }

        public MappingInfo getMappingInfo() {
            return this.mi;
        }

        public ResponseInfo setMappingInfo(MappingInfo mi) {
            this.mi = mi;
            return this;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public ResponseInfo setRequest(HttpServletRequest request) {
            this.request = request;
            return this;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }

        public ResponseInfo setResponse(HttpServletResponse response) {
            this.response = response;
            return this;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public ResponseInfo setFinished(boolean finished) {
            this.finished = finished;
            return this;
        }

        public Method getMethod() {
            return this.method;
        }

        public ResponseInfo setMethod(Method method) {
            this.method = method;
            return this;
        }

        public Integer getMax() {
            return this.max;
        }

        public ResponseInfo setMax(Integer max) {
            this.max = max;
            return this;
        }

        public List<String> getResultTypes() {
            return this.resulttypes;
        }

        public ResponseInfo setResultTypes(List<String> resulttypes) {
            this.resulttypes = resulttypes;
            return this;
        }

        public boolean isSSERequest() {
            return this.getRequest().getHeader("Accept") != null && this.getRequest().getHeader("Accept").indexOf("text/event-stream") != -1;
        }

        public boolean isSSEConnectionAvailable() {
            boolean ret = false;
            Map<String, Object> session = AbstractRestPublishService.this.getSession(this.getRequest(), false);
            if (session != null) {
                ret = session.get("sse") != null;
            }
            return ret;
        }
    }

    public static class ConversationInfo {
        protected boolean terminated;
        protected long lastcheck;
        protected IFuture<?> future;
        protected String sessionid;
        protected String callid;

        public ConversationInfo(String callid, String sessionid) {
            this.callid = callid;
            this.sessionid = sessionid;
            this.lastcheck = this.updateTimestamp();
        }

        public void setTerminated(boolean term) {
            this.terminated = term;
        }

        public boolean isTerminated() {
            return this.terminated;
        }

        public long updateTimestamp() {
            this.lastcheck = System.currentTimeMillis();
            return this.lastcheck;
        }

        public long getTimestamp() {
            return this.lastcheck;
        }

        public IFuture<?> getFuture() {
            return this.future;
        }

        public void setFuture(IFuture<?> future) {
            this.future = future;
        }

        public String getSessionId() {
            return this.sessionid;
        }

        public void setSessionId(String sessionid) {
            this.sessionid = sessionid;
        }

        public String getCallId() {
            return this.callid;
        }

        public void setCallId(String callid) {
            this.callid = callid;
        }

        public boolean isIntermediateFuture() {
            return this.future instanceof IIntermediateFuture;
        }
    }

    public static class MappingInfo {
        protected HttpMethod httpmethod;
        protected Method method;
        protected String path;

        public MappingInfo() {
        }

        public MappingInfo(HttpMethod httpMethod, Method method, String path) {
            this.httpmethod = httpMethod;
            this.method = method;
            this.path = path;
        }

        public HttpMethod getHttpMethod() {
            return this.httpmethod;
        }

        public void setHttpMethod(HttpMethod httpMethod) {
            this.httpmethod = httpMethod;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean isEmpty() {
            return this.path == null && this.method == null && this.httpmethod == null;
        }

        public List<String> getParameterNames() {
            Annotation[][] anns;
            ArrayList<String> ret = new ArrayList<String>();
            Annotation[][] annotationArray = anns = this.method.getParameterAnnotations();
            int n = annotationArray.length;
            block0: for (int i = 0; i < n; ++i) {
                Annotation[] ans;
                for (Annotation an : ans = annotationArray[i]) {
                    String name;
                    ParameterInfo p;
                    if (an instanceof ParameterInfo) {
                        p = (ParameterInfo)an;
                        name = p.value();
                        ret.add(name);
                        continue block0;
                    }
                    if (an instanceof QueryParam) {
                        p = (QueryParam)an;
                        name = p.value();
                        ret.add(name);
                        continue block0;
                    }
                    if (an instanceof PathParam) {
                        p = (PathParam)an;
                        name = p.value();
                        ret.add(name);
                        continue block0;
                    }
                    if (!(an instanceof FormParam)) continue;
                    p = (FormParam)an;
                    name = p.value();
                    ret.add(name);
                    continue block0;
                }
            }
            return ret;
        }

        public List<String> getConsumedMediaTypes() {
            if (this.method.isAnnotationPresent(Consumes.class)) {
                Consumes con = this.method.getAnnotation(Consumes.class);
                return Arrays.asList(con.value());
            }
            return Collections.EMPTY_LIST;
        }

        public List<String> getProducedMediaTypes() {
            if (this.method.isAnnotationPresent(Produces.class)) {
                Produces prod = this.method.getAnnotation(Produces.class);
                return Arrays.asList(prod.value());
            }
            return Collections.EMPTY_LIST;
        }

        public static enum HttpMethod {
            GET,
            POST,
            PUT,
            DELETE,
            OPTIONS,
            HEAD;

        }
    }
}

