/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension;

import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;

public class SJavassist {
    public static void addMethodParameterAnnotation(CtMethod method, Annotation[][] annotations, ClassPool pool) throws Exception {
        MethodInfo mi = method.getMethodInfo();
        ParameterAnnotationsAttribute attribute = (ParameterAnnotationsAttribute)mi.getAttribute("RuntimeVisibleParameterAnnotations");
        ConstPool cp = method.getMethodInfo().getConstPool();
        if (attribute == null) {
            attribute = new ParameterAnnotationsAttribute(cp, "RuntimeVisibleParameterAnnotations");
        }
        attribute.setAnnotations(annotations);
        mi.addAttribute((AttributeInfo)attribute);
    }

    public static CtClass getCtClass(Class clazz, ClassPool pool) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class must not null.");
        }
        CtClass ret = null;
        try {
            ret = pool.get(clazz.getName());
        }
        catch (Exception e) {
            try {
                ClassClassPath cp = new ClassClassPath(clazz);
                pool.insertClassPath((ClassPath)cp);
                ret = pool.get(clazz.getName());
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        return ret;
    }

    public static CtClass getCtClass(String clname, ClassPool pool) {
        if (clname == null) {
            throw new IllegalArgumentException("Class must not null.");
        }
        CtClass ret = null;
        try {
            ret = pool.get(clname);
        }
        catch (Exception e) {
            try {
                ret = pool.get(clname);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        return ret;
    }

    public static CtClass[] getCtClasses(Class[] classes, ClassPool pool) {
        CtClass[] ret = new CtClass[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            ret[i] = SJavassist.getCtClass(classes[i], pool);
        }
        return ret;
    }
}

