/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.mapper;

import com.thoughtworks.xstream.alias.ClassMapper;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FieldAliasingMapper
extends MapperWrapper {
    protected final Map fieldToAliasMap = new HashMap();
    protected final Map aliasToFieldMap = new HashMap();
    protected final Set fieldsToOmit = new HashSet();
    static /* synthetic */ Class class$java$lang$Object;

    public FieldAliasingMapper(Mapper wrapped) {
        super(wrapped);
    }

    public FieldAliasingMapper(ClassMapper wrapped) {
        this((Mapper)wrapped);
    }

    public void addFieldAlias(String alias, Class type, String fieldName) {
        this.fieldToAliasMap.put(this.key(type, fieldName), alias);
        this.aliasToFieldMap.put(this.key(type, alias), fieldName);
    }

    private Key key(Class type, String value) {
        return new Key(type, value);
    }

    public String serializedMember(Class type, String memberName) {
        String alias = this.get(this.key(type, memberName), this.fieldToAliasMap);
        if (alias == null) {
            return super.serializedMember(type, memberName);
        }
        return alias;
    }

    public String realMember(Class type, String serialized) {
        String real = this.get(this.key(type, serialized), this.aliasToFieldMap);
        if (real == null) {
            return super.realMember(type, serialized);
        }
        return real;
    }

    public boolean shouldSerializeMember(Class definedIn, String fieldName, Class fieldType, Object value) {
        return this.omitted(this.key(definedIn, fieldName)) ? false : super.shouldSerializeMember(definedIn, fieldName, fieldType, value);
    }

    private boolean omitted(Key key) {
        if (this.fieldsToOmit.contains(key)) {
            return true;
        }
        Class superclass = key.getType().getSuperclass();
        if (superclass == null || superclass == (class$java$lang$Object == null ? (class$java$lang$Object = FieldAliasingMapper.class$("java.lang.Object")) : class$java$lang$Object)) {
            return false;
        }
        boolean omitted = this.omitted(new Key(superclass, key.getName()));
        if (omitted) {
            this.fieldsToOmit.add(key);
        }
        return omitted;
    }

    public void omitField(Class type, String fieldName) {
        this.fieldsToOmit.add(this.key(type, fieldName));
    }

    private String get(Key key, Map map) {
        String value = (String)map.get(key);
        if (value != null) {
            return value;
        }
        Class superclass = key.getType().getSuperclass();
        if (superclass == null || superclass == (class$java$lang$Object == null ? (class$java$lang$Object = FieldAliasingMapper.class$("java.lang.Object")) : class$java$lang$Object)) {
            return null;
        }
        value = this.get(new Key(superclass, key.getName()), map);
        if (value != null) {
            map.put(key, value);
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Key {
        private final Class type;
        private final String name;

        public Key(Class type, String name) {
            this.type = type;
            this.name = name;
        }

        public Class getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.name != null ? !this.name.equals(key.name) : key.name != null) {
                return false;
            }
            return !(this.type != null ? !this.type.equals(key.type) : key.type != null);
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "key(" + this.type.getName() + ", " + this.name + ")";
        }
    }
}

