/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

import com.thoughtworks.xstream.core.util.FastStack;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.StreamException;
import java.io.IOException;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Dom4JWriter
implements HierarchicalStreamWriter {
    private final XMLWriter writer;
    private final FastStack elementStack;
    private AttributesImpl attributes;
    private boolean started;
    private boolean children;

    public Dom4JWriter(XMLWriter writer) {
        this.writer = writer;
        this.elementStack = new FastStack(16);
        this.attributes = new AttributesImpl();
        try {
            writer.startDocument();
        }
        catch (SAXException e) {
            throw new StreamException(e);
        }
    }

    public void startNode(String name) {
        if (this.elementStack.size() > 0) {
            try {
                this.startElement();
            }
            catch (SAXException e) {
                throw new StreamException(e);
            }
            this.started = false;
        }
        this.elementStack.push(name);
        this.children = false;
    }

    public void setValue(String text) {
        char[] value = text.toCharArray();
        if (value.length > 0) {
            try {
                this.startElement();
                this.writer.characters(value, 0, value.length);
            }
            catch (SAXException e) {
                throw new StreamException(e);
            }
            this.children = true;
        }
    }

    public void addAttribute(String key, String value) {
        this.attributes.addAttribute("", "", key, "string", value);
    }

    public void endNode() {
        try {
            if (!this.children) {
                DefaultElement element = new DefaultElement((String)this.elementStack.pop());
                for (int i = 0; i < this.attributes.getLength(); ++i) {
                    element.addAttribute(this.attributes.getQName(i), this.attributes.getValue(i));
                }
                this.writer.write((Element)element);
                this.children = true;
                this.started = true;
            } else {
                this.startElement();
                this.writer.endElement("", "", (String)this.elementStack.pop());
            }
        }
        catch (SAXException e) {
            throw new StreamException(e);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
    }

    public void flush() {
    }

    public void close() {
        try {
            this.writer.endDocument();
        }
        catch (SAXException e) {
            throw new StreamException(e);
        }
    }

    public HierarchicalStreamWriter underlyingWriter() {
        return this;
    }

    private void startElement() throws SAXException {
        if (!this.started) {
            this.writer.startElement("", "", (String)this.elementStack.peek(), (Attributes)this.attributes);
            this.attributes.clear();
            this.started = true;
        }
    }
}

