/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.SerializationMethodInvoker;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractReflectionConverter
implements Converter {
    protected final ReflectionProvider reflectionProvider;
    protected final Mapper mapper;
    protected transient SerializationMethodInvoker serializationMethodInvoker;
    private transient ReflectionProvider pureJavaReflectionProvider;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;

    public AbstractReflectionConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        this.mapper = mapper;
        this.reflectionProvider = reflectionProvider;
        this.serializationMethodInvoker = new SerializationMethodInvoker();
    }

    public void marshal(Object original, HierarchicalStreamWriter writer, MarshallingContext context) {
        Object source = this.serializationMethodInvoker.callWriteReplace(original);
        if (source.getClass() != original.getClass()) {
            writer.addAttribute(this.mapper.aliasForAttribute("resolves-to"), this.mapper.serializedClass(source.getClass()));
        }
        this.doMarshal(source, writer, context);
    }

    protected void doMarshal(final Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        final HashSet seenFields = new HashSet();
        final HashSet seenAsAttributes = new HashSet();
        this.reflectionProvider.visitSerializableFields(source, new ReflectionProvider.Visitor(){

            public void visit(String fieldName, Class type, Class definedIn, Object value) {
                SingleValueConverter converter = AbstractReflectionConverter.this.mapper.getConverterFromItemType(fieldName, type);
                if (converter == null) {
                    converter = AbstractReflectionConverter.this.mapper.getConverterFromItemType(type);
                }
                if (converter != null) {
                    String str = converter.toString(value);
                    if (str != null) {
                        writer.addAttribute(AbstractReflectionConverter.this.mapper.aliasForAttribute(fieldName), str);
                    }
                    seenAsAttributes.add(fieldName);
                }
            }
        });
        this.reflectionProvider.visitSerializableFields(source, new ReflectionProvider.Visitor(){

            public void visit(String fieldName, Class fieldType, Class definedIn, Object newObj) {
                if (!seenAsAttributes.contains(fieldName) && newObj != null) {
                    Mapper.ImplicitCollectionMapping mapping = AbstractReflectionConverter.this.mapper.getImplicitCollectionDefForFieldName(source.getClass(), fieldName);
                    if (mapping != null) {
                        if (mapping.getItemFieldName() != null) {
                            Collection list = (Collection)newObj;
                            Iterator iter = list.iterator();
                            while (iter.hasNext()) {
                                Object obj = iter.next();
                                this.writeField(fieldName, mapping.getItemFieldName(), mapping.getItemType(), definedIn, obj);
                            }
                        } else {
                            context.convertAnother(newObj);
                        }
                    } else {
                        this.writeField(fieldName, fieldName, fieldType, definedIn, newObj);
                        seenFields.add(fieldName);
                    }
                }
            }

            private void writeField(String fieldName, String aliasName, Class fieldType, Class definedIn, Object newObj) {
                if (!AbstractReflectionConverter.this.mapper.shouldSerializeMember(source.getClass(), aliasName, fieldType, newObj)) {
                    return;
                }
                writer.startNode(AbstractReflectionConverter.this.mapper.serializedMember(source.getClass(), aliasName));
                Class<?> actualType = newObj.getClass();
                Class defaultType = AbstractReflectionConverter.this.mapper.defaultImplementationOf(fieldType);
                if (!actualType.equals(defaultType)) {
                    writer.addAttribute(AbstractReflectionConverter.this.mapper.aliasForAttribute("class"), AbstractReflectionConverter.this.mapper.serializedClass(actualType));
                }
                if (seenFields.contains(aliasName)) {
                    writer.addAttribute(AbstractReflectionConverter.this.mapper.aliasForAttribute("defined-in"), AbstractReflectionConverter.this.mapper.serializedClass(definedIn));
                }
                Field field = AbstractReflectionConverter.this.reflectionProvider.getField(definedIn, fieldName);
                AbstractReflectionConverter.this.marshallField(context, newObj, field);
                writer.endNode();
            }
        });
    }

    protected void marshallField(MarshallingContext context, Object newObj, Field field) {
        context.convertAnother(newObj);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Object result = this.instantiateNewInstance(reader, context);
        return this.doUnmarshal(result, reader, context);
    }

    public Object doUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
        SeenFields seenFields = new SeenFields();
        Iterator it = reader.getAttributeNames();
        while (it.hasNext()) {
            String attrAlias = (String)it.next();
            String attrName = this.mapper.attributeForAlias(attrAlias);
            Class classDefiningField = this.determineWhichClassDefinesField(reader);
            boolean fieldExistsInClass = this.reflectionProvider.fieldDefinedInClass(attrName, result.getClass());
            if (!fieldExistsInClass) continue;
            SingleValueConverter converter = this.mapper.getConverterFromAttribute(attrName);
            if (converter == null) {
                converter = this.mapper.getConverterFromItemType(this.reflectionProvider.getFieldType(result, attrName, classDefiningField));
            }
            if (converter == null) continue;
            Object value = converter.fromString(reader.getAttribute(attrAlias));
            this.reflectionProvider.writeField(result, attrName, value, classDefiningField);
            seenFields.add(classDefiningField, attrName);
        }
        Map implicitCollectionsForCurrentObject = null;
        while (reader.hasMoreChildren()) {
            Object value;
            reader.moveDown();
            String fieldName = this.mapper.realMember(result.getClass(), reader.getNodeName());
            boolean implicitCollectionHasSameName = this.mapper.getImplicitCollectionDefForFieldName(result.getClass(), reader.getNodeName()) != null;
            Class classDefiningField = this.determineWhichClassDefinesField(reader);
            boolean fieldExistsInClass = !implicitCollectionHasSameName && this.reflectionProvider.fieldDefinedInClass(fieldName, result.getClass());
            Class type = this.determineType(reader, fieldExistsInClass, result, fieldName, classDefiningField);
            if (fieldExistsInClass) {
                Field field = this.reflectionProvider.getField(result.getClass(), fieldName);
                value = this.unmarshallField(context, result, type, field);
            } else {
                value = context.convertAnother(result, type);
            }
            if (value != null && !type.isAssignableFrom(value.getClass())) {
                throw new ConversionException("Cannot convert type " + value.getClass().getName() + " to type " + type.getName());
            }
            if (fieldExistsInClass) {
                this.reflectionProvider.writeField(result, fieldName, value, classDefiningField);
                seenFields.add(classDefiningField, fieldName);
            } else {
                implicitCollectionsForCurrentObject = this.writeValueToImplicitCollectionOrMap(context, value, implicitCollectionsForCurrentObject, result, fieldName);
            }
            reader.moveUp();
        }
        return this.serializationMethodInvoker.callReadResolve(result);
    }

    protected Object unmarshallField(UnmarshallingContext context, Object result, Class type, Field field) {
        return context.convertAnother(result, type);
    }

    private Map writeValueToImplicitCollectionOrMap(UnmarshallingContext context, Object value, Map implicitCollections, Object result, String itemFieldName) {
        String fieldName = this.mapper.getFieldNameForItemTypeAndName(context.getRequiredType(), value.getClass(), itemFieldName);
        if (fieldName != null) {
            if (implicitCollections == null) {
                implicitCollections = new HashMap();
            }
            Object collection = implicitCollections.get(fieldName);
            if (this.pureJavaReflectionProvider == null) {
                this.pureJavaReflectionProvider = new PureJavaReflectionProvider();
            }
            if (collection == null) {
                Class fieldType;
                if (!(class$java$util$Collection == null ? (class$java$util$Collection = AbstractReflectionConverter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(fieldType = this.mapper.defaultImplementationOf(this.reflectionProvider.getFieldType(result, fieldName, null))) && !(class$java$util$Map == null ? (class$java$util$Map = AbstractReflectionConverter.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(fieldType)) {
                    throw new ObjectAccessException("Field " + fieldName + " of " + result.getClass().getName() + " is configured for an implicit Collection, but field is of type " + fieldType.getName());
                }
                collection = this.pureJavaReflectionProvider.newInstance(fieldType);
                this.reflectionProvider.writeField(result, fieldName, collection, null);
                implicitCollections.put(fieldName, collection);
            }
            if (collection instanceof Map) {
                String implicitKey = this.mapper.getImplicitKeyForType(value.getClass());
                if (implicitKey == null) {
                    throw new IllegalStateException("No Implicit key mapping found for " + value.getClass());
                }
                Object key = this.reflectionProvider.readField(value, implicitKey, value.getClass());
                ((Map)collection).put(key, value);
            } else {
                ((Collection)collection).add(value);
            }
        }
        return implicitCollections;
    }

    private Class determineWhichClassDefinesField(HierarchicalStreamReader reader) {
        String definedIn = reader.getAttribute(this.mapper.aliasForAttribute("defined-in"));
        return definedIn == null ? null : this.mapper.realClass(definedIn);
    }

    protected Object instantiateNewInstance(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String readResolveValue = reader.getAttribute(this.mapper.aliasForAttribute("resolves-to"));
        Object currentObject = context.currentObject();
        if (currentObject != null) {
            return currentObject;
        }
        if (readResolveValue != null) {
            return this.reflectionProvider.newInstance(this.mapper.realClass(readResolveValue));
        }
        return this.reflectionProvider.newInstance(context.getRequiredType());
    }

    private Class determineType(HierarchicalStreamReader reader, boolean validField, Object result, String fieldName, Class definedInCls) {
        String classAttribute = reader.getAttribute(this.mapper.aliasForAttribute("class"));
        if (classAttribute != null) {
            return this.mapper.realClass(classAttribute);
        }
        if (!validField) {
            Class itemType = this.mapper.getItemTypeForItemFieldName(result.getClass(), fieldName);
            if (itemType != null) {
                return itemType;
            }
            return this.mapper.realClass(reader.getNodeName());
        }
        return this.mapper.defaultImplementationOf(this.reflectionProvider.getFieldType(result, fieldName, definedInCls));
    }

    private Object readResolve() {
        this.serializationMethodInvoker = new SerializationMethodInvoker();
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class DuplicateFieldException
    extends ConversionException {
        public DuplicateFieldException(String msg) {
            super(msg);
        }
    }

    private static class SeenFields {
        private Set seen = new HashSet();

        private SeenFields() {
        }

        public void add(Class definedInCls, String fieldName) {
            String uniqueKey = fieldName;
            if (definedInCls != null) {
                uniqueKey = uniqueKey + " [" + definedInCls.getName() + "]";
            }
            if (this.seen.contains(uniqueKey)) {
                throw new DuplicateFieldException(uniqueKey);
            }
            this.seen.add(uniqueKey);
        }
    }
}

