/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.enums;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.enums.EnumFormat;
import com.thoughtworks.xstream.converters.enums.SimpleEnumFormat;
import com.thoughtworks.xstream.core.util.Fields;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.Iterator;

public class EnumSetConverter
implements Converter {
    private final EnumFormat enumFormat;
    private final Field typeField;
    private final Mapper mapper;
    static /* synthetic */ Class class$java$util$EnumSet;

    public EnumSetConverter(Mapper mapper) {
        this(mapper, new SimpleEnumFormat());
    }

    public EnumSetConverter(Mapper mapper, EnumFormat enumFormat) {
        this.mapper = mapper;
        this.typeField = Fields.find(class$java$util$EnumSet == null ? (class$java$util$EnumSet = EnumSetConverter.class$("java.util.EnumSet")) : class$java$util$EnumSet, "elementType");
        this.enumFormat = enumFormat;
    }

    public boolean canConvert(Class type) {
        return (class$java$util$EnumSet == null ? (class$java$util$EnumSet = EnumSetConverter.class$("java.util.EnumSet")) : class$java$util$EnumSet).isAssignableFrom(type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        EnumSet set = (EnumSet)source;
        Class enumTypeForSet = (Class)Fields.read(this.typeField, set);
        writer.addAttribute(this.mapper.aliasForAttribute("enum-type"), this.mapper.serializedClass(enumTypeForSet));
        writer.setValue(this.joinEnumValues(set));
    }

    private String joinEnumValues(EnumSet set) {
        boolean seenFirst = false;
        StringBuffer result = new StringBuffer();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Enum value = (Enum)iterator.next();
            if (seenFirst) {
                result.append(',');
            } else {
                seenFirst = true;
            }
            String textValue = this.enumFormat.format(value);
            result.append(textValue);
        }
        return result.toString();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Class enumTypeForSet = this.mapper.realClass(reader.getAttribute(this.mapper.aliasForAttribute("enum-type")));
        EnumSet<Enum> set = EnumSet.noneOf(enumTypeForSet);
        String[] enumValues = reader.getValue().split(",");
        for (int i = 0; i < enumValues.length; ++i) {
            String enumValue = enumValues[i];
            if (enumValue.length() <= 0) continue;
            Enum enumItem = this.enumFormat.parse(enumTypeForSet, enumValue);
            set.add(enumItem);
        }
        return set;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

