/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.enums;

import com.thoughtworks.xstream.converters.enums.EnumFormat;
import com.thoughtworks.xstream.converters.enums.SimpleEnumFormat;

public class CamelcaseEnumFormat
implements EnumFormat {
    private final EnumFormat format;

    public CamelcaseEnumFormat() {
        this.format = new SimpleEnumFormat();
    }

    public CamelcaseEnumFormat(EnumFormat format) {
        this.format = format;
    }

    public String format(Enum enumItem) {
        String value = this.format.format(enumItem);
        if (value == null || value.length() < 1) {
            return value;
        }
        StringBuffer sb = new StringBuffer(value);
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        for (int i = 1; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c == '_' && i + 1 < sb.length()) {
                sb.deleteCharAt(i);
                c = sb.charAt(i);
                sb.setCharAt(i, Character.toUpperCase(c));
                continue;
            }
            sb.setCharAt(i, Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public Enum parse(Class enumType, String value) {
        if (value == null || value.length() < 1) {
            return this.format.parse(enumType, value);
        }
        StringBuffer sb = new StringBuffer(value);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (Character.isUpperCase(c) && i != 0) {
                sb.insert(i++, '_');
                continue;
            }
            sb.setCharAt(i, Character.toUpperCase(c));
        }
        value = sb.toString();
        return this.format.parse(enumType, value);
    }
}

