/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.enums;

import com.thoughtworks.xstream.converters.enums.EnumFormat;
import com.thoughtworks.xstream.converters.enums.SimpleEnumFormat;
import java.util.HashMap;
import java.util.Map;

public class AliasedEnumFormat
implements EnumFormat {
    private final Map aliasMap;
    private EnumFormat defaultFormat;

    public AliasedEnumFormat() {
        this(new SimpleEnumFormat());
    }

    public AliasedEnumFormat(EnumFormat format) {
        this(new HashMap(), format);
    }

    private AliasedEnumFormat(Map aliasMap, EnumFormat format) {
        this.aliasMap = aliasMap;
        this.defaultFormat = format;
    }

    public void setDefaultFormat(EnumFormat defaultFormat) {
        this.defaultFormat = defaultFormat;
    }

    public void aliasEnum(Enum enumItem, String xmlItem) {
        Alias alias = new Alias(enumItem, xmlItem);
        this.aliasMap.put(enumItem, alias);
        this.aliasMap.put(alias.getKey(), alias);
    }

    public void aliasEnumType(Class enumType, EnumFormat format) {
        FormatAlias alias = new FormatAlias(enumType, format);
        this.aliasMap.put(enumType, alias);
    }

    public String format(Enum enumItem) {
        Alias alias = (Alias)this.aliasMap.get(enumItem);
        if (alias != null) {
            return alias.getName();
        }
        FormatAlias formatAlias = (FormatAlias)this.aliasMap.get(enumItem.getClass());
        if (formatAlias != null) {
            return formatAlias.getFormat().format(enumItem);
        }
        return this.defaultFormat.format(enumItem);
    }

    public Enum parse(Class enumType, String value) {
        Alias alias = (Alias)this.aliasMap.get(new Key(enumType, value));
        if (alias != null) {
            return alias.getEnum();
        }
        FormatAlias formatAlias = (FormatAlias)this.aliasMap.get(enumType);
        if (formatAlias != null) {
            return formatAlias.getFormat().parse(enumType, value);
        }
        return this.defaultFormat.parse(enumType, value);
    }

    public static class Key {
        private final Class enumType;
        private final String aliasedName;

        public Key(Class enumType, String aliasedName) {
            this.enumType = enumType;
            this.aliasedName = aliasedName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.aliasedName != null ? !this.aliasedName.equals(key.aliasedName) : key.aliasedName != null) {
                return false;
            }
            return !(this.enumType != null ? !this.enumType.equals(key.enumType) : key.enumType != null);
        }

        public int hashCode() {
            int result = this.enumType != null ? this.enumType.hashCode() : 0;
            result = 29 * result + (this.aliasedName != null ? this.aliasedName.hashCode() : 0);
            return result;
        }
    }

    public static class Alias {
        private final Enum _enum;
        private final String name;

        public Alias(Enum _enum, String name) {
            this._enum = _enum;
            this.name = name;
        }

        public Enum getEnum() {
            return this._enum;
        }

        public String getName() {
            return this.name;
        }

        public Key getKey() {
            return new Key(this._enum.getClass(), this.name);
        }
    }

    public static class FormatAlias {
        private final Class enumType;
        private final EnumFormat format;

        public FormatAlias(Class enumType, EnumFormat format) {
            this.enumType = enumType;
            this.format = format;
        }

        public Class getEnumType() {
            return this.enumType;
        }

        public EnumFormat getFormat() {
            return this.format;
        }
    }
}

